/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.blockout.management.server.update;

import com.ldtteam.blockout.element.IUIElement;
import com.ldtteam.blockout.element.root.RootGuiElement;
import com.ldtteam.blockout.management.IUIManager;
import com.ldtteam.blockout.management.common.update.ChildUpdateManager;
import com.ldtteam.blockout.management.update.IUpdateManager;
import com.ldtteam.blockout.util.Log;
import com.ldtteam.blockout.util.profiler.ProfilerExporter;
import java.io.File;
import org.jetbrains.annotations.NotNull;

public class ServerUpdateManager
implements IUpdateManager {
    @NotNull
    private final IUIManager manager;
    private boolean dirty = false;

    public ServerUpdateManager(@NotNull IUIManager manager) {
        this.manager = manager;
    }

    public void updateElement(@NotNull IUIElement element) {
        if (element instanceof RootGuiElement) {
            RootGuiElement rootGuiElement = (RootGuiElement)element;
            rootGuiElement.getUiManager().getProfiler().clearProfiling();
            rootGuiElement.getUiManager().getProfiler().startSection("Global Update");
            ChildUpdateManager childUpdateManager = new ChildUpdateManager(this);
            childUpdateManager.updateElement((IUIElement)rootGuiElement);
            rootGuiElement.getUiManager().getProfiler().endSection();
            File tmpDir = new File("profiler.json");
            if (!tmpDir.exists()) {
                ProfilerExporter.exportProfiler(element);
            }
            IUIElement focusedElement = rootGuiElement.getUiManager().getFocusManager().getFocusedElement();
            if (!rootGuiElement.getAllCombinedChildElements().values().contains(focusedElement)) {
                rootGuiElement.getUiManager().getFocusManager().setFocusedElement(null);
            }
        } else {
            Log.getLogger().warn("Somebody tried to update a none root element.");
        }
    }

    public void markDirty() {
        this.dirty = true;
    }

    public void onNetworkTick() {
        if (this.dirty) {
            this.manager.getNetworkManager().onElementChanged((IUIElement)this.manager.getHost());
            this.dirty = false;
        }
    }

    public boolean isDirty() {
        return this.dirty;
    }
}

