/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.blockout.management.server.network.messages;

import com.ldtteam.blockout.element.IUIElement;
import com.ldtteam.blockout.gui.BlockOutGuiData;
import com.ldtteam.blockout.network.message.core.IBlockOutServerToClientMessage;
import com.ldtteam.jvoxelizer.IGameEngine;
import com.ldtteam.jvoxelizer.client.gui.IGuiContainer;
import com.ldtteam.jvoxelizer.client.gui.IGuiScreen;
import com.ldtteam.jvoxelizer.networking.messaging.IMessageContext;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OnFocusedElementChangedMessage
implements IBlockOutServerToClientMessage {
    private String focusedElementId = "";

    public OnFocusedElementChangedMessage(@Nullable IUIElement focusedElement) {
        this();
        if (focusedElement != null) {
            this.focusedElementId = focusedElement.getId();
        }
    }

    public OnFocusedElementChangedMessage() {
    }

    @Override
    public void onMessageArrivalAtClient(@NotNull IMessageContext ctx) {
        IGuiScreen openGuiScreen = IGameEngine.getInstance().getCurrentGui();
        if (openGuiScreen instanceof IGuiContainer && openGuiScreen.getInstanceData() instanceof BlockOutGuiData) {
            IGuiContainer blockOutGui = (IGuiContainer)openGuiScreen;
            if (this.focusedElementId != null && !this.focusedElementId.isEmpty()) {
                ((BlockOutGuiData)blockOutGui.getInstanceData()).getRoot().getUiManager().getFocusManager().setFocusedElement((IUIElement)((BlockOutGuiData)blockOutGui.getInstanceData()).getRoot().searchExactElementById(this.focusedElementId).orElseThrow(() -> new IllegalStateException("Tried to focus unknown element.")));
            } else {
                ((BlockOutGuiData)blockOutGui.getInstanceData()).getRoot().getUiManager().getFocusManager().setFocusedElement(null);
            }
        } else {
            throw new IllegalStateException("Server thinks a BlockOut guitemp was open.");
        }
    }
}

