/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.blockout.management.server.network.messages;

import com.ldtteam.blockout.element.IUIElement;
import com.ldtteam.blockout.element.IUIElementHost;
import com.ldtteam.blockout.element.root.RootGuiElement;
import com.ldtteam.blockout.gui.BlockOutGuiData;
import com.ldtteam.blockout.inventory.BlockOutContainerData;
import com.ldtteam.blockout.inventory.BlockOutContainerLogic;
import com.ldtteam.blockout.loader.core.IUIElementData;
import com.ldtteam.blockout.loader.object.ObjectUIElementData;
import com.ldtteam.blockout.management.UIManager;
import com.ldtteam.blockout.network.message.core.IBlockOutServerToClientMessage;
import com.ldtteam.blockout.proxy.ProxyHolder;
import com.ldtteam.jvoxelizer.IGameEngine;
import com.ldtteam.jvoxelizer.client.gui.IGuiContainer;
import com.ldtteam.jvoxelizer.client.gui.IGuiScreen;
import com.ldtteam.jvoxelizer.inventory.IContainer;
import com.ldtteam.jvoxelizer.networking.messaging.IMessageContext;
import org.jetbrains.annotations.NotNull;

public class OnElementUpdatedMessage
implements IBlockOutServerToClientMessage {
    @NotNull
    private final ObjectUIElementData elementData;

    public OnElementUpdatedMessage(@NotNull ObjectUIElementData elementData) {
        this.elementData = elementData;
    }

    @Override
    public void onMessageArrivalAtClient(@NotNull IMessageContext ctx) {
        UIManager uiManager;
        RootGuiElement rootGuiElement;
        BlockOutGuiData blockOutGui;
        IGuiScreen openGuiScreen = IGameEngine.getInstance().getCurrentGui();
        if (!(openGuiScreen instanceof IGuiContainer)) {
            throw new IllegalStateException("No container open!");
        }
        IGuiContainer openContainerScreen = (IGuiContainer)openGuiScreen;
        if (openContainerScreen.getInstanceData() instanceof BlockOutGuiData) {
            blockOutGui = (BlockOutGuiData)openContainerScreen.getInstanceData();
            IUIElement containedElement = ProxyHolder.getInstance().getFactoryController().getElementFromData((IUIElementData)this.elementData);
            if (!(containedElement instanceof RootGuiElement)) {
                throw new IllegalStateException("The synced element is not a root.");
            }
            IUIElementHost root = blockOutGui.getRoot();
            if (!(root instanceof RootGuiElement)) {
                throw new IllegalStateException("The client root is not a root instance");
            }
            rootGuiElement = (RootGuiElement)containedElement;
            uiManager = (UIManager)blockOutGui.getRoot().getUiManager();
            uiManager.setRootGuiElement(rootGuiElement);
            IUIElement focusedElement = uiManager.getFocusManager().getFocusedElement();
            if (focusedElement != null) {
                uiManager.getFocusManager().setFocusedElement((IUIElement)rootGuiElement.searchExactElementById(focusedElement.getId()).orElse(null));
            }
        } else {
            throw new IllegalStateException("Server thinks a BlockOut guitemp was open.");
        }
        rootGuiElement.setUiManager(uiManager);
        blockOutGui.setRoot((IUIElementHost)rootGuiElement);
        blockOutGui.getRoot().getUiManager().getRenderManager().setGuiData(blockOutGui);
        blockOutGui.getRoot().getUiManager().getUpdateManager().updateElement((IUIElement)blockOutGui.getRoot());
        openContainerScreen.initializeGui();
        IContainer container = openContainerScreen.getContainer();
        BlockOutContainerLogic.reinitializeSlots((IContainer<BlockOutContainerData>)container);
    }
}

