/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.blockout.management.server.network;

import com.ldtteam.blockout.connector.core.IGuiKey;
import com.ldtteam.blockout.connector.server.ServerGuiController;
import com.ldtteam.blockout.element.IUIElement;
import com.ldtteam.blockout.loader.core.IUIElementData;
import com.ldtteam.blockout.loader.object.ObjectUIElementData;
import com.ldtteam.blockout.management.network.INetworkManager;
import com.ldtteam.blockout.management.server.network.messages.OnElementUpdatedMessage;
import com.ldtteam.blockout.management.server.network.messages.OnFocusedElementChangedMessage;
import com.ldtteam.blockout.network.NetworkManager;
import com.ldtteam.blockout.network.message.core.IBlockOutServerToClientMessage;
import com.ldtteam.blockout.proxy.ProxyHolder;
import com.ldtteam.blockout.util.keyboard.KeyboardKey;
import com.ldtteam.blockout.util.mouse.MouseButton;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ServerNetworkManager
implements INetworkManager {
    @NotNull
    private final IGuiKey guiKey;
    @NotNull
    private final ServerGuiController guiController;

    public ServerNetworkManager(@NotNull IGuiKey guiKey) {
        this.guiKey = guiKey;
        this.guiController = (ServerGuiController)ProxyHolder.getInstance().getGuiController();
    }

    public void onFocusChanged(@Nullable IUIElement newElement) {
        this.guiController.getUUIDsOfPlayersWatching(this.guiKey).forEach(uuid -> NetworkManager.sendTo((IBlockOutServerToClientMessage)new OnFocusedElementChangedMessage(newElement), uuid));
    }

    public void onMouseClickBegin(int localX, int localY, MouseButton button) {
    }

    public void onMouseClickEnd(int localX, int localY, MouseButton button) {
    }

    public void onMouseClickMove(int localX, int localY, MouseButton button, float timeElapsed) {
    }

    public void onMouseWheel(int localX, int localY, int deltaWheel) {
    }

    public void onKeyPressed(int character, KeyboardKey key) {
    }

    public void onElementChanged(@NotNull IUIElement changedElement) {
        IUIElementData dataCandidate = ProxyHolder.getInstance().getFactoryController().getDataFromElement(changedElement);
        if (!(dataCandidate instanceof ObjectUIElementData)) {
            throw new IllegalArgumentException("Cannot serialize given element into a serializable form of data");
        }
        this.guiController.getUUIDsOfPlayersWatching(this.guiKey).forEach(uuid -> NetworkManager.sendTo((IBlockOutServerToClientMessage)new OnElementUpdatedMessage((ObjectUIElementData)dataCandidate), uuid));
    }
}

