/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.blockout.management.common.input;

import com.ldtteam.blockout.element.IUIElement;
import com.ldtteam.blockout.element.input.IScrollAcceptingUIElement;
import com.ldtteam.blockout.management.IUIManager;
import com.ldtteam.blockout.management.common.input.AbstractInputManager;
import com.ldtteam.blockout.management.input.IScrollManager;
import com.ldtteam.blockout.util.math.BoundingBox;
import com.ldtteam.blockout.util.math.Vector2d;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

public class ScrollManager
extends AbstractInputManager
implements IScrollManager {
    public ScrollManager(IUIManager manager) {
        super(manager);
    }

    public void onMouseWheel(int localX, int localY, int deltaWheel) {
        this.attemptInputInteraction(localX, localY, (u, x, y) -> u.isEnabled() && u.canAcceptScrollInput(x, y, deltaWheel), (u, x, y) -> u.onMouseScroll(x, y, deltaWheel));
    }

    protected void attemptInputInteraction(int localX, int localY, IInteractionAcceptanceCallback acceptanceCallback, IInteractionExecutionCallback executionCallback) {
        IUIElement currentFocus = this.getManager().getFocusManager().getFocusedElement();
        if (currentFocus instanceof IScrollAcceptingUIElement && this.attemptMouseInteractionWith(currentFocus, localX, localY, acceptanceCallback, executionCallback)) {
            return;
        }
        this.onAcceptanceFailure();
        Optional target = this.getManager().getHost().searchDeepestElementByCoord(new Vector2d((double)localX, (double)localY));
        this.attemptFailedInputInteraction(localX, localY, acceptanceCallback, executionCallback, target);
    }

    private void attemptFailedInputInteraction(int localX, int localY, IInteractionAcceptanceCallback acceptanceCallback, IInteractionExecutionCallback executionCallback, Optional<IUIElement> target) {
        if (target.isPresent()) {
            if (target.get() instanceof IScrollAcceptingUIElement && this.attemptMouseInteractionWith(target.get(), localX, localY, acceptanceCallback, executionCallback)) {
                this.getManager().getFocusManager().setFocusedElement(target.get());
            } else if (target.get().getParent() != null && target.get().getParent() != target.get()) {
                this.attemptFailedInputInteraction(localX, localY, acceptanceCallback, executionCallback, target.map(IUIElement::getParent));
            }
        }
    }

    private boolean attemptMouseInteractionWith(@NotNull IUIElement target, int localX, int localY, IInteractionAcceptanceCallback acceptanceCallback, IInteractionExecutionCallback executionCallback) {
        BoundingBox localTarget;
        IScrollAcceptingUIElement t = (IScrollAcceptingUIElement)target;
        Vector2d absoluteTarget = new Vector2d((double)localX, (double)localY);
        if (t.getAbsoluteBoundingBox().includes(absoluteTarget) && acceptanceCallback.apply(t, (int)(localTarget = new BoundingBox(absoluteTarget.move(t.getAbsoluteBoundingBox().getLocalOrigin().invert()), new Vector2d())).getLocalOrigin().getX(), (int)localTarget.getLocalOrigin().getY())) {
            executionCallback.apply(t, (int)localTarget.getLocalOrigin().getX(), (int)localTarget.getLocalOrigin().getY());
            return true;
        }
        return false;
    }

    @FunctionalInterface
    protected static interface IInteractionExecutionCallback {
        public void apply(@NotNull IScrollAcceptingUIElement var1, int var2, int var3);
    }

    @FunctionalInterface
    protected static interface IInteractionAcceptanceCallback {
        public boolean apply(@NotNull IScrollAcceptingUIElement var1, int var2, int var3);
    }
}

