/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.blockout.management.common.input;

import com.ldtteam.blockout.element.IUIElement;
import com.ldtteam.blockout.element.input.IKeyAcceptingUIElement;
import com.ldtteam.blockout.management.IUIManager;
import com.ldtteam.blockout.management.common.input.AbstractInputManager;
import com.ldtteam.blockout.management.input.IKeyManager;
import com.ldtteam.blockout.util.keyboard.KeyboardKey;
import org.jetbrains.annotations.NotNull;

public class KeyManager
extends AbstractInputManager
implements IKeyManager {
    public KeyManager(IUIManager manager) {
        super(manager);
    }

    public void onKeyPressed(int character, KeyboardKey key) {
        this.attemptInputInteraction(t -> t.isEnabled() && t.canAcceptKeyInput(character, key), t -> t.onKeyPressed(character, key));
    }

    protected void attemptInputInteraction(IInteractionAcceptanceCallback acceptanceCallback, IInteractionExecutionCallback executionCallback) {
        IUIElement currentFocus = this.getManager().getFocusManager().getFocusedElement();
        if (currentFocus instanceof IKeyAcceptingUIElement && this.attemptMouseInteractionWith(currentFocus, acceptanceCallback, executionCallback)) {
            return;
        }
        this.onAcceptanceFailure();
    }

    private boolean attemptMouseInteractionWith(@NotNull IUIElement target, IInteractionAcceptanceCallback acceptanceCallback, IInteractionExecutionCallback executionCallback) {
        IKeyAcceptingUIElement t = (IKeyAcceptingUIElement)target;
        if (acceptanceCallback.apply(t)) {
            executionCallback.apply(t);
            return true;
        }
        return false;
    }

    @FunctionalInterface
    protected static interface IInteractionExecutionCallback {
        public void apply(@NotNull IKeyAcceptingUIElement var1);
    }

    @FunctionalInterface
    protected static interface IInteractionAcceptanceCallback {
        public boolean apply(@NotNull IKeyAcceptingUIElement var1);
    }
}

