/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.blockout.management.common.input;

import com.ldtteam.blockout.element.IUIElement;
import com.ldtteam.blockout.element.input.IClickAcceptingUIElement;
import com.ldtteam.blockout.management.IUIManager;
import com.ldtteam.blockout.management.common.input.AbstractInputManager;
import com.ldtteam.blockout.management.input.IClickManager;
import com.ldtteam.blockout.util.math.BoundingBox;
import com.ldtteam.blockout.util.math.Vector2d;
import com.ldtteam.blockout.util.mouse.MouseButton;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

public class ClickManager
extends AbstractInputManager
implements IClickManager {
    public ClickManager(IUIManager manager) {
        super(manager);
    }

    public void onMouseClickBegin(int localX, int localY, MouseButton button) {
        this.attemptInputInteraction(localX, localY, (u, x, y) -> u.isEnabled() && u.canAcceptMouseInput(x, y, button), (u, x, y) -> u.onMouseClickBegin(x, y, button));
    }

    public void onMouseClickEnd(int localX, int localY, MouseButton button) {
        this.attemptInputInteraction(localX, localY, (u, x, y) -> u.isEnabled() && u.canAcceptMouseInput(x, y, button), (u, x, y) -> u.onMouseClickEnd(x, y, button));
    }

    public void onMouseClickMove(int localX, int localY, MouseButton button, float timeElapsed) {
        this.attemptInputInteraction(localX, localY, (u, x, y) -> u.isEnabled() && u.canAcceptMouseInput(x, y, button), (u, x, y) -> u.onMouseClickMove(x, y, button, timeElapsed));
    }

    protected void attemptInputInteraction(int localX, int localY, IInteractionAcceptanceCallback acceptanceCallback, IInteractionExecutionCallback executionCallback) {
        IUIElement currentFocus = this.getManager().getFocusManager().getFocusedElement();
        if (currentFocus instanceof IClickAcceptingUIElement) {
            if (this.attemptMouseInteractionWith(currentFocus, localX, localY, acceptanceCallback, executionCallback)) {
                return;
            }
            ((IClickAcceptingUIElement)currentFocus).onMouseLeave();
        }
        this.onAcceptanceFailure();
        Optional target = this.getManager().getHost().searchDeepestElementByCoordAndPredicate(new Vector2d((double)localX, (double)localY), e -> e instanceof IClickAcceptingUIElement);
        this.attemptFailedInputInteraction(localX, localY, acceptanceCallback, executionCallback, target);
    }

    private void attemptFailedInputInteraction(int localX, int localY, IInteractionAcceptanceCallback acceptanceCallback, IInteractionExecutionCallback executionCallback, Optional<IUIElement> target) {
        if (target.isPresent()) {
            if (target.get() instanceof IClickAcceptingUIElement && this.attemptMouseInteractionWith(target.get(), localX, localY, acceptanceCallback, executionCallback)) {
                this.getManager().getFocusManager().setFocusedElement(target.get());
            } else if (target.get().getParent() != null && target.get().getParent() != target.get()) {
                this.attemptFailedInputInteraction(localX, localY, acceptanceCallback, executionCallback, target.map(IUIElement::getParent));
            }
        }
    }

    private boolean attemptMouseInteractionWith(@NotNull IUIElement target, int localX, int localY, IInteractionAcceptanceCallback acceptanceCallback, IInteractionExecutionCallback executionCallback) {
        BoundingBox localTarget;
        IClickAcceptingUIElement t = (IClickAcceptingUIElement)target;
        Vector2d absoluteClickPos = new Vector2d((double)localX, (double)localY);
        if (t.getAbsoluteBoundingBox().includes(absoluteClickPos) && acceptanceCallback.apply(t, (int)(localTarget = new BoundingBox(absoluteClickPos.move(t.getAbsoluteBoundingBox().getLocalOrigin().invert()), new Vector2d())).getLocalOrigin().getX(), (int)localTarget.getLocalOrigin().getY())) {
            executionCallback.apply(t, (int)localTarget.getLocalOrigin().getX(), (int)localTarget.getLocalOrigin().getY());
            return true;
        }
        return false;
    }

    @FunctionalInterface
    protected static interface IInteractionExecutionCallback {
        public void apply(@NotNull IClickAcceptingUIElement var1, int var2, int var3);
    }

    @FunctionalInterface
    protected static interface IInteractionAcceptanceCallback {
        public boolean apply(@NotNull IClickAcceptingUIElement var1, int var2, int var3);
    }
}

