/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.blockout.management.common.focus;

import com.ldtteam.blockout.element.IUIElement;
import com.ldtteam.blockout.management.IUIManager;
import com.ldtteam.blockout.management.focus.IFocusManager;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FocusManager
implements IFocusManager {
    @NotNull
    private final IUIManager manager;
    @Nullable
    private IUIElement focusedElement = null;

    public FocusManager(IUIManager manager) {
        this.manager = manager;
    }

    @Nullable
    public IUIElement getFocusedElement() {
        return this.focusedElement;
    }

    public void setFocusedElement(@Nullable IUIElement focusedElement) {
        if (Objects.equals(this.focusedElement, focusedElement)) {
            return;
        }
        this.focusedElement = focusedElement;
        this.manager.getNetworkManager().onFocusChanged(focusedElement);
    }

    public boolean isFocusedElement(@NotNull IUIElement element) {
        if (this.focusedElement == null) {
            return false;
        }
        return element.getId().equals(this.focusedElement.getId());
    }
}

