/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.blockout.management.client.render;

import com.ldtteam.blockout.element.IUIElement;
import com.ldtteam.blockout.element.IUIElementHost;
import com.ldtteam.blockout.element.drawable.IChildDrawableUIElement;
import com.ldtteam.blockout.element.drawable.IDrawableUIElement;
import com.ldtteam.blockout.gui.BlockOutGuiData;
import com.ldtteam.blockout.management.render.IRenderManager;
import com.ldtteam.blockout.render.core.IRenderingController;
import com.ldtteam.blockout.render.standard.RenderingController;
import com.ldtteam.blockout.util.math.Vector2d;
import com.ldtteam.jvoxelizer.client.renderer.opengl.IOpenGl;
import org.jetbrains.annotations.NotNull;

public class RenderManager
implements IRenderManager {
    private final IRenderingController renderingController = new RenderingController(this);
    private BlockOutGuiData gui;
    private Vector2d scalingFactor;

    public void drawBackground(@NotNull IUIElement host) {
        if (!host.isVisible()) {
            return;
        }
        IOpenGl.pushMatrix();
        IOpenGl.translate((double)host.getAbsoluteBoundingBox().getLocalOrigin().getX(), (double)host.getAbsoluteBoundingBox().getLocalOrigin().getY(), (double)0.0);
        if (host instanceof IDrawableUIElement) {
            IDrawableUIElement iDrawableUIElement = (IDrawableUIElement)host;
            iDrawableUIElement.drawBackground(this.renderingController);
        }
        IOpenGl.popMatrix();
        if (host instanceof IChildDrawableUIElement) {
            ((IChildDrawableUIElement)host).preBackgroundDrawOfChildren((IRenderManager)this);
            ((IChildDrawableUIElement)host).backgroundDrawOfChildren((IRenderManager)this);
            ((IChildDrawableUIElement)host).postBackgroundDrawOfChildren((IRenderManager)this);
        } else if (host instanceof IUIElementHost) {
            IUIElementHost iuiElementHost = (IUIElementHost)host;
            iuiElementHost.values().forEach(this::drawBackground);
        }
    }

    public void drawForeground(@NotNull IUIElement host) {
        if (!host.isVisible()) {
            return;
        }
        IOpenGl.pushMatrix();
        IOpenGl.translate((double)host.getAbsoluteBoundingBox().getLocalOrigin().getX(), (double)host.getAbsoluteBoundingBox().getLocalOrigin().getY(), (double)0.0);
        if (host instanceof IDrawableUIElement) {
            IDrawableUIElement iDrawableUIElement = (IDrawableUIElement)host;
            iDrawableUIElement.drawForeground(this.renderingController);
        }
        IOpenGl.popMatrix();
        if (host instanceof IChildDrawableUIElement) {
            ((IChildDrawableUIElement)host).preForegroundDrawOfChildren((IRenderManager)this);
            ((IChildDrawableUIElement)host).foregroundDrawOfChildren((IRenderManager)this);
            ((IChildDrawableUIElement)host).postForegroundDrawOfChildren((IRenderManager)this);
        } else if (host instanceof IUIElementHost) {
            IUIElementHost iuiElementHost = (IUIElementHost)host;
            iuiElementHost.values().forEach(this::drawForeground);
        }
    }

    @NotNull
    public IRenderingController getRenderingController() {
        return this.renderingController;
    }

    @NotNull
    public BlockOutGuiData getGuiData() {
        return this.gui;
    }

    public void setGuiData(@NotNull BlockOutGuiData gui) {
        this.gui = gui;
    }

    public Vector2d getRenderingScalingFactor() {
        return this.scalingFactor;
    }

    public void setRenderingScalingFactor(@NotNull Vector2d scalingFactor) {
        this.scalingFactor = scalingFactor;
    }
}

