/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.blockout.management.client.input;

import com.ldtteam.blockout.element.IUIElement;
import com.ldtteam.blockout.element.input.client.IClientSideScrollAcceptingUIElement;
import com.ldtteam.blockout.management.IUIManager;
import com.ldtteam.blockout.management.input.client.IClientSideScrollManager;
import com.ldtteam.blockout.util.math.BoundingBox;
import com.ldtteam.blockout.util.math.Vector2d;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

public class ClientSideScrollManager
implements IClientSideScrollManager {
    private final IUIManager manager;

    public ClientSideScrollManager(IUIManager manager) {
        this.manager = manager;
    }

    public boolean onMouseWheel(int localX, int localY, int deltaWheel) {
        return this.attemptInputInteraction(localX, localY, (u, x, y) -> u.isEnabled() && u.canAcceptMouseInputClient(x, y, deltaWheel), (u, x, y) -> u.onMouseScrollClient(x, y, deltaWheel));
    }

    public IUIManager getManager() {
        return this.manager;
    }

    protected boolean attemptInputInteraction(int localX, int localY, IInteractionAcceptanceCallback acceptanceCallback, IInteractionExecutionCallback executionCallback) {
        Optional<Boolean> currentFocusInteractionResult;
        IUIElement currentFocus = this.getManager().getFocusManager().getFocusedElement();
        if (currentFocus instanceof IClientSideScrollAcceptingUIElement && (currentFocusInteractionResult = this.attemptMouseInteractionWith(currentFocus, localX, localY, acceptanceCallback, executionCallback)).isPresent()) {
            return currentFocusInteractionResult.get();
        }
        Optional target = this.getManager().getHost().searchDeepestElementByCoord(new Vector2d((double)localX, (double)localY));
        return this.attemptFailedInputInteraction(localX, localY, acceptanceCallback, executionCallback, target).orElse(false);
    }

    private Optional<Boolean> attemptFailedInputInteraction(int localX, int localY, IInteractionAcceptanceCallback acceptanceCallback, IInteractionExecutionCallback executionCallback, Optional<IUIElement> target) {
        if (target.isPresent()) {
            if (target.get() instanceof IClientSideScrollAcceptingUIElement) {
                return this.attemptMouseInteractionWith(target.get(), localX, localY, acceptanceCallback, executionCallback);
            }
            if (target.get().getParent() != null && target.get().getParent() != target.get()) {
                return this.attemptFailedInputInteraction(localX, localY, acceptanceCallback, executionCallback, target.map(IUIElement::getParent));
            }
        }
        return Optional.empty();
    }

    private Optional<Boolean> attemptMouseInteractionWith(@NotNull IUIElement target, int localX, int localY, IInteractionAcceptanceCallback acceptanceCallback, IInteractionExecutionCallback executionCallback) {
        BoundingBox localTarget;
        IClientSideScrollAcceptingUIElement t = (IClientSideScrollAcceptingUIElement)target;
        Vector2d absoluteTarget = new Vector2d((double)localX, (double)localY);
        if (t.getAbsoluteBoundingBox().includes(absoluteTarget) && acceptanceCallback.apply(t, (int)(localTarget = new BoundingBox(absoluteTarget.move(t.getAbsoluteBoundingBox().getLocalOrigin().invert()), new Vector2d())).getLocalOrigin().getX(), (int)localTarget.getLocalOrigin().getY())) {
            return Optional.of(executionCallback.apply(t, (int)localTarget.getLocalOrigin().getX(), (int)localTarget.getLocalOrigin().getY()));
        }
        return Optional.empty();
    }

    @FunctionalInterface
    protected static interface IInteractionExecutionCallback {
        public boolean apply(@NotNull IClientSideScrollAcceptingUIElement var1, int var2, int var3);
    }

    @FunctionalInterface
    protected static interface IInteractionAcceptanceCallback {
        public boolean apply(@NotNull IClientSideScrollAcceptingUIElement var1, int var2, int var3);
    }
}

