/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.blockout.management.client.input;

import com.ldtteam.blockout.element.IUIElement;
import com.ldtteam.blockout.element.input.client.IClientSideKeyAcceptingUIElement;
import com.ldtteam.blockout.management.IUIManager;
import com.ldtteam.blockout.management.input.client.IClientSideKeyManager;
import com.ldtteam.blockout.util.keyboard.KeyboardKey;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

public class ClientSideKeyManager
implements IClientSideKeyManager {
    private final IUIManager manager;

    public ClientSideKeyManager(IUIManager manager) {
        this.manager = manager;
    }

    public boolean onKeyPressed(int character, KeyboardKey key) {
        return this.attemptInputInteraction(t -> t.isEnabled() && t.canAcceptKeyInputClient(character, key), t -> t.onKeyPressedClient(character, key));
    }

    protected boolean attemptInputInteraction(IInteractionAcceptanceCallback acceptanceCallback, IInteractionExecutionCallback executionCallback) {
        Optional<Boolean> currentFocusInteractionResult;
        IUIElement currentFocus = this.getManager().getFocusManager().getFocusedElement();
        if (currentFocus instanceof IClientSideKeyAcceptingUIElement && (currentFocusInteractionResult = this.attemptMouseInteractionWith(currentFocus, acceptanceCallback, executionCallback)).isPresent()) {
            return currentFocusInteractionResult.get();
        }
        return false;
    }

    private IUIManager getManager() {
        return this.manager;
    }

    private Optional<Boolean> attemptMouseInteractionWith(@NotNull IUIElement target, IInteractionAcceptanceCallback acceptanceCallback, IInteractionExecutionCallback executionCallback) {
        IClientSideKeyAcceptingUIElement t = (IClientSideKeyAcceptingUIElement)target;
        if (acceptanceCallback.apply(t)) {
            return Optional.of(executionCallback.apply(t));
        }
        return Optional.empty();
    }

    @FunctionalInterface
    protected static interface IInteractionExecutionCallback {
        public boolean apply(@NotNull IClientSideKeyAcceptingUIElement var1);
    }

    @FunctionalInterface
    protected static interface IInteractionAcceptanceCallback {
        public boolean apply(@NotNull IClientSideKeyAcceptingUIElement var1);
    }
}

