/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.blockout.management.client.input;

import com.ldtteam.blockout.element.IUIElement;
import com.ldtteam.blockout.element.input.client.IClientSideClickAcceptingUIElement;
import com.ldtteam.blockout.management.IUIManager;
import com.ldtteam.blockout.management.input.client.IClientSideClickManager;
import com.ldtteam.blockout.util.math.BoundingBox;
import com.ldtteam.blockout.util.math.Vector2d;
import com.ldtteam.blockout.util.mouse.MouseButton;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

public class ClientSideClickManager
implements IClientSideClickManager {
    private final IUIManager manager;

    public ClientSideClickManager(IUIManager manager) {
        this.manager = manager;
    }

    public boolean onMouseClickBegin(int localX, int localY, MouseButton button) {
        return this.attemptInputInteraction(localX, localY, (u, x, y) -> u.isEnabled() && u.canAcceptMouseInputClient(x, y, button), (u, x, y) -> u.onMouseClickBeginClient(x, y, button));
    }

    public boolean onMouseClickEnd(int localX, int localY, MouseButton button) {
        return this.attemptInputInteraction(localX, localY, (u, x, y) -> u.isEnabled() && u.canAcceptMouseInputClient(x, y, button), (u, x, y) -> u.onMouseClickEndClient(x, y, button));
    }

    public boolean onMouseClickMove(int localX, int localY, MouseButton button, float timeElapsed) {
        return this.attemptInputInteraction(localX, localY, (u, x, y) -> u.isEnabled() && u.canAcceptMouseInputClient(x, y, button), (u, x, y) -> u.onMouseClickMoveClient(x, y, button, timeElapsed));
    }

    private IUIManager getManager() {
        return this.manager;
    }

    protected boolean attemptInputInteraction(int localX, int localY, IInteractionAcceptanceCallback acceptanceCallback, IInteractionExecutionCallback executionCallback) {
        Optional<Boolean> currentFocusInteractionResult;
        IUIElement currentFocus = this.getManager().getFocusManager().getFocusedElement();
        if (currentFocus instanceof IClientSideClickAcceptingUIElement && (currentFocusInteractionResult = this.attemptMouseInteractionWith(currentFocus, localX, localY, acceptanceCallback, executionCallback)).isPresent()) {
            return currentFocusInteractionResult.get();
        }
        Optional target = this.getManager().getHost().searchDeepestElementByCoordAndPredicate(new Vector2d((double)localX, (double)localY), e -> e instanceof IClientSideClickAcceptingUIElement);
        return this.attemptFailedInputInteraction(localX, localY, acceptanceCallback, executionCallback, target).orElse(false);
    }

    private Optional<Boolean> attemptFailedInputInteraction(int localX, int localY, IInteractionAcceptanceCallback acceptanceCallback, IInteractionExecutionCallback executionCallback, Optional<IUIElement> target) {
        if (target.isPresent()) {
            if (target.get() instanceof IClientSideClickAcceptingUIElement) {
                return this.attemptMouseInteractionWith(target.get(), localX, localY, acceptanceCallback, executionCallback);
            }
            if (target.get().getParent() != null && target.get().getParent() != target.get()) {
                return this.attemptFailedInputInteraction(localX, localY, acceptanceCallback, executionCallback, target.map(IUIElement::getParent));
            }
        }
        return Optional.empty();
    }

    private Optional<Boolean> attemptMouseInteractionWith(@NotNull IUIElement target, int localX, int localY, IInteractionAcceptanceCallback acceptanceCallback, IInteractionExecutionCallback executionCallback) {
        BoundingBox localTarget;
        IClientSideClickAcceptingUIElement t = (IClientSideClickAcceptingUIElement)target;
        Vector2d absoluteClickPos = new Vector2d((double)localX, (double)localY);
        if (t.getAbsoluteBoundingBox().includes(absoluteClickPos) && acceptanceCallback.apply(t, (int)(localTarget = new BoundingBox(absoluteClickPos.move(t.getAbsoluteBoundingBox().getLocalOrigin().invert()), new Vector2d())).getLocalOrigin().getX(), (int)localTarget.getLocalOrigin().getY())) {
            return Optional.of(executionCallback.apply(t, (int)localTarget.getLocalOrigin().getX(), (int)localTarget.getLocalOrigin().getY()));
        }
        return Optional.empty();
    }

    @FunctionalInterface
    protected static interface IInteractionExecutionCallback {
        public boolean apply(@NotNull IClientSideClickAcceptingUIElement var1, int var2, int var3);
    }

    @FunctionalInterface
    protected static interface IInteractionAcceptanceCallback {
        public boolean apply(@NotNull IClientSideClickAcceptingUIElement var1, int var2, int var3);
    }
}

