/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.blockout.management;

import com.ldtteam.blockout.connector.core.IGuiKey;
import com.ldtteam.blockout.element.root.RootGuiElement;
import com.ldtteam.blockout.management.IUIManager;
import com.ldtteam.blockout.management.client.input.ClientSideClickManager;
import com.ldtteam.blockout.management.client.input.ClientSideKeyManager;
import com.ldtteam.blockout.management.client.input.ClientSideScrollManager;
import com.ldtteam.blockout.management.common.focus.FocusManager;
import com.ldtteam.blockout.management.common.input.ClickManager;
import com.ldtteam.blockout.management.common.input.KeyManager;
import com.ldtteam.blockout.management.common.input.ScrollManager;
import com.ldtteam.blockout.management.focus.IFocusManager;
import com.ldtteam.blockout.management.input.IClickManager;
import com.ldtteam.blockout.management.input.IKeyManager;
import com.ldtteam.blockout.management.input.IScrollManager;
import com.ldtteam.blockout.management.input.client.IClientSideClickManager;
import com.ldtteam.blockout.management.input.client.IClientSideKeyManager;
import com.ldtteam.blockout.management.input.client.IClientSideScrollManager;
import com.ldtteam.blockout.management.network.INetworkManager;
import com.ldtteam.blockout.management.render.IRenderManager;
import com.ldtteam.blockout.management.update.IUpdateManager;
import com.ldtteam.blockout.proxy.ProxyHolder;
import com.ldtteam.jvoxelizer.profiler.IProfiler;
import com.ldtteam.jvoxelizer.util.distribution.executor.IDistributionExecutor;
import java.util.LinkedHashMap;
import org.jetbrains.annotations.NotNull;

public class UIManager
implements IUIManager {
    @NotNull
    private final INetworkManager networkManager;
    @NotNull
    private final IFocusManager focusManager = new FocusManager(this);
    @NotNull
    private final IClickManager clickManager = new ClickManager(this);
    @NotNull
    private final IKeyManager keyManager = new KeyManager(this);
    @NotNull
    private final IScrollManager scrollManager = new ScrollManager(this);
    @NotNull
    private final IClientSideClickManager clientSideClickManager = new ClientSideClickManager(this);
    @NotNull
    private final IClientSideKeyManager clientSideKeyManager = new ClientSideKeyManager(this);
    @NotNull
    private final IClientSideScrollManager clientSideScrollManager = new ClientSideScrollManager(this);
    @NotNull
    private final IUpdateManager updateManager;
    @NotNull
    private final IRenderManager renderManager;
    @NotNull
    private final IProfiler profiler;
    @NotNull
    private RootGuiElement rootGuiElement;

    public UIManager(@NotNull RootGuiElement rootGuiElement, @NotNull IGuiKey key) {
        this.rootGuiElement = rootGuiElement;
        this.networkManager = ProxyHolder.getInstance().generateNewNetworkManagerForGui(key);
        this.updateManager = ProxyHolder.getInstance().generateNewUpdateManager((IUIManager)this);
        this.renderManager = (IRenderManager)IDistributionExecutor.on(() -> ProxyHolder.getInstance().generateNewRenderManager(), () -> null);
        this.profiler = IProfiler.create();
        this.profiler.enableProfiling();
        this.profiler.setProfilingMap(new LinkedHashMap());
    }

    @NotNull
    public RootGuiElement getHost() {
        return this.rootGuiElement;
    }

    @NotNull
    public INetworkManager getNetworkManager() {
        return this.networkManager;
    }

    @NotNull
    public IFocusManager getFocusManager() {
        return this.focusManager;
    }

    @NotNull
    public IClickManager getClickManager() {
        return this.clickManager;
    }

    @NotNull
    public IKeyManager getKeyManager() {
        return this.keyManager;
    }

    @NotNull
    public IScrollManager getScrollManager() {
        return this.scrollManager;
    }

    @NotNull
    public IClientSideClickManager getClientSideClickManager() {
        return this.clientSideClickManager;
    }

    @NotNull
    public IClientSideKeyManager getClientSideKeyManager() {
        return this.clientSideKeyManager;
    }

    @NotNull
    public IClientSideScrollManager getClientSideScrollManager() {
        return this.clientSideScrollManager;
    }

    @NotNull
    public IUpdateManager getUpdateManager() {
        return this.updateManager;
    }

    @NotNull
    public IRenderManager getRenderManager() {
        return this.renderManager;
    }

    public IProfiler getProfiler() {
        return this.profiler;
    }

    public void setRootGuiElement(@NotNull RootGuiElement rootGuiElement) {
        this.rootGuiElement = rootGuiElement;
    }
}

