/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.blockout.loader.object;

import com.ldtteam.blockout.loader.core.IUIElementData;
import com.ldtteam.blockout.loader.core.IUIElementMetaData;
import com.ldtteam.blockout.loader.core.component.IUIElementDataComponent;
import com.ldtteam.blockout.loader.object.ObjectUIElementDataComponent;
import com.ldtteam.blockout.loader.object.ObjectUIElementMetaData;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ObjectUIElementData
implements IUIElementData<ObjectUIElementDataComponent>,
Serializable {
    @NotNull
    private final Map<String, ObjectUIElementDataComponent> object;
    @NotNull
    private final ObjectUIElementMetaData metaData;

    public ObjectUIElementData(@NotNull Map<String, ObjectUIElementDataComponent> object, @NotNull ObjectUIElementMetaData metaData) {
        this.object = object;
        this.metaData = metaData;
    }

    @NotNull
    public IUIElementMetaData getMetaData() {
        return this.metaData;
    }

    @Nullable
    public Optional<ObjectUIElementDataComponent> getComponentWithName(@NotNull String name, boolean isPrimary) {
        if (this.object.containsKey(name)) {
            return Optional.of(this.object.get(name));
        }
        return Optional.empty();
    }

    public <D extends IUIElementDataComponent> D toDataComponent(@NotNull D toWriteInto) {
        HashMap<String, ObjectUIElementDataComponent> dataMap = new HashMap<String, ObjectUIElementDataComponent>(this.object);
        this.metaData.mergeData(dataMap);
        toWriteInto.setMap(dataMap);
        return toWriteInto;
    }
}

