/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.blockout.loader.object;

import com.google.common.collect.Lists;
import com.google.inject.Key;
import com.google.inject.internal.MoreTypes;
import com.ldtteam.blockout.element.IUIElement;
import com.ldtteam.blockout.loader.core.IUIElementData;
import com.ldtteam.blockout.loader.core.IUIElementDataBuilder;
import com.ldtteam.blockout.loader.core.IUIElementMetaDataBuilder;
import com.ldtteam.blockout.loader.core.component.IUIElementDataComponent;
import com.ldtteam.blockout.loader.factory.core.IUIElementDataComponentConverter;
import com.ldtteam.blockout.loader.object.ObjectUIElementData;
import com.ldtteam.blockout.loader.object.ObjectUIElementDataComponent;
import com.ldtteam.blockout.loader.object.ObjectUIElementMetaData;
import com.ldtteam.blockout.loader.object.ObjectUIElementMetaDataBuilder;
import com.ldtteam.blockout.proxy.ProxyHolder;
import com.ldtteam.blockout.util.stream.CollectorHelper;
import com.ldtteam.blockout.util.stream.FunctionHelper;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.stream.Collectors;

public class ObjectUIElementBuilder
implements IUIElementDataBuilder<ObjectUIElementData> {
    private final List<ObjectUIElementData> children = Lists.newArrayList();
    private ObjectUIElementMetaData metaData;
    private Map<String, ObjectUIElementDataComponent> attributes = new HashMap<String, ObjectUIElementDataComponent>();

    public IUIElementDataBuilder<ObjectUIElementData> copyFrom(IUIElementData<?> elementData) {
        ObjectUIElementDataComponent elementDataComponent = (ObjectUIElementDataComponent)elementData.toDataComponent((IUIElementDataComponent)new ObjectUIElementDataComponent());
        this.attributes = (Map)elementDataComponent.getAsMap().entrySet().stream().map(FunctionHelper::castMapValue).collect(CollectorHelper.entryToMapCollector());
        this.metaData = new ObjectUIElementMetaData(this.attributes, null);
        this.children.clear();
        return this;
    }

    public IUIElementDataBuilder<ObjectUIElementData> withMetaData(Consumer<IUIElementMetaDataBuilder<?>> builder) {
        ObjectUIElementMetaDataBuilder metaDataBuilder = new ObjectUIElementMetaDataBuilder();
        builder.accept(metaDataBuilder);
        this.metaData = metaDataBuilder.build();
        return this;
    }

    public IUIElementDataBuilder<ObjectUIElementData> addChild(IUIElement element) {
        ObjectUIElementData data = (ObjectUIElementData)ProxyHolder.getInstance().getFactoryController().getDataFromElementWithBuilder(element, (IUIElementDataBuilder)new ObjectUIElementBuilder());
        this.children.add(data);
        return this;
    }

    public <T> IUIElementDataBuilder<ObjectUIElementData> addComponent(String componentName, T value, Type typeToken) {
        MoreTypes.ParameterizedTypeImpl type = new MoreTypes.ParameterizedTypeImpl(null, IUIElementDataComponentConverter.class, new Type[]{typeToken});
        IUIElementDataComponentConverter componentConverter = (IUIElementDataComponentConverter)ProxyHolder.getInstance().getInjector().getInstance(Key.get((Type)type));
        ObjectUIElementDataComponent component = (ObjectUIElementDataComponent)componentConverter.writeToElement(value, c -> new ObjectUIElementDataComponent());
        this.attributes.put(componentName, component);
        return this;
    }

    public ObjectUIElementData build() {
        ObjectUIElementDataComponent childrenComponent = new ObjectUIElementDataComponent();
        List childrenData = this.children.stream().map(objectUIElementData -> objectUIElementData.toDataComponent(new ObjectUIElementDataComponent())).collect(Collectors.toList());
        if (this.attributes.containsKey("children")) {
            childrenData.addAll(this.attributes.get("children").getAsList());
        }
        childrenComponent.setList(childrenData);
        this.attributes.put("children", childrenComponent);
        Map<String, ObjectUIElementDataComponent> combinedAttributes = this.metaData.mergeData(this.attributes);
        return new ObjectUIElementData(combinedAttributes, new ObjectUIElementMetaData(combinedAttributes, this.metaData.getParent().orElse(null)));
    }
}

