/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.blockout.inventory;

import com.ldtteam.blockout.connector.core.IGuiKey;
import com.ldtteam.blockout.element.IUIElementHost;
import com.ldtteam.blockout.element.simple.Slot;
import com.ldtteam.blockout.inventory.BlockOutContainerData;
import com.ldtteam.blockout.inventory.slot.BlockOutSlotData;
import com.ldtteam.blockout.inventory.slot.BlockOutSlotLogic;
import com.ldtteam.blockout.util.Log;
import com.ldtteam.blockout.util.itemstack.ItemStackHelper;
import com.ldtteam.jvoxelizer.core.logic.TypedPipelineElementContext;
import com.ldtteam.jvoxelizer.inventory.IContainer;
import com.ldtteam.jvoxelizer.inventory.logic.builder.IContainerBuilder;
import com.ldtteam.jvoxelizer.inventory.logic.builder.contexts.MergeItemStackContext;
import com.ldtteam.jvoxelizer.inventory.logic.builder.contexts.TransferStackInSlotContext;
import com.ldtteam.jvoxelizer.inventory.slot.ISlot;
import com.ldtteam.jvoxelizer.inventory.slot.ISlotItemHandler;
import com.ldtteam.jvoxelizer.item.IItemStack;
import com.ldtteam.jvoxelizer.item.handling.IItemHandler;
import com.ldtteam.jvoxelizer.util.identifier.IIdentifier;
import com.ldtteam.jvoxelizer.util.tuple.ITuple;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public final class BlockOutContainerLogic {
    public static IContainer<BlockOutContainerData> create(@NotNull IGuiKey key, @NotNull IUIElementHost root, @NotNull int windowId) {
        IContainerBuilder builder = IContainerBuilder.create();
        IContainer container = builder.TransferStackInSlot(new Function[]{BlockOutContainerLogic::TransferStackInSlot}).MergeItemStack(new Function[]{BlockOutContainerLogic::MergeItemStack}).CanInteractWith(new Function[]{context -> true}).build((Object)new BlockOutContainerData(key, root));
        BlockOutContainerLogic.initializeSlots((IContainer<BlockOutContainerData>)container);
        return container;
    }

    private static IItemStack TransferStackInSlot(TypedPipelineElementContext<TransferStackInSlotContext, IItemStack, IContainer<BlockOutContainerData>, BlockOutContainerData> context) {
        ISlotItemHandler slotBlockOut;
        IItemStack newItemStack = IItemStack.create();
        ISlot slot = (ISlot)((IContainer)context.getInstance()).getInventorySlots().get(((TransferStackInSlotContext)context.getContext()).getIndex());
        if (slot instanceof ISlotItemHandler && slot.getInstanceData() instanceof BlockOutSlotData && (slotBlockOut = (ISlotItemHandler)slot).getHasStack()) {
            IItemStack itemStack = slotBlockOut.getContainedStack();
            newItemStack = itemStack.copy();
            ITuple<Integer, Integer> containerRange = BlockOutContainerLogic.findNextInventoryIndices((IContainer<BlockOutContainerData>)((IContainer)context.getInstance()), (ISlotItemHandler<BlockOutSlotData>)slotBlockOut);
            if (!((IContainer)context.getInstance()).mergeItemStack(itemStack, ((Integer)containerRange.getFirst()).intValue(), ((Integer)containerRange.getSecond()).intValue(), false)) {
                return IItemStack.create();
            }
            if (itemStack.getCount() == 0 || itemStack.isEmpty()) {
                slotBlockOut.putStack(IItemStack.create());
            } else {
                slotBlockOut.onSlotChanged();
            }
        }
        return newItemStack;
    }

    public static void reinitializeSlots(IContainer<BlockOutContainerData> container) {
        container.clearInventory();
        BlockOutContainerLogic.initializeSlots(container);
        container.updateListeners();
    }

    private static ITuple<Integer, Integer> findNextInventoryIndices(IContainer<BlockOutContainerData> container, ISlotItemHandler<BlockOutSlotData> slotBlockOut) {
        Integer startIndex = BlockOutContainerLogic.findStartIndexOfNextInventory(container, slotBlockOut);
        ISlotItemHandler startSlot = (ISlotItemHandler)container.getInventorySlots().get(0);
        Integer endIndex = BlockOutContainerLogic.findStartIndexOfNextInventory(container, (ISlotItemHandler<BlockOutSlotData>)startSlot);
        if (startIndex == 0 && startIndex == endIndex) {
            return ITuple.create((Object)0, (Object)container.getInventorySlots().size());
        }
        return ITuple.create((Object)startIndex, (Object)endIndex);
    }

    private static boolean MergeItemStack(TypedPipelineElementContext<MergeItemStackContext, Boolean, IContainer<BlockOutContainerData>, BlockOutContainerData> context) {
        IItemStack stackInSlot;
        ISlot slot;
        int currentSlotIndex;
        boolean slotFound = false;
        int n = currentSlotIndex = ((MergeItemStackContext)context.getContext()).getReverseDirection() ? ((MergeItemStackContext)context.getContext()).getEndIndex() - 1 : ((MergeItemStackContext)context.getContext()).getStartIndex();
        if (((MergeItemStackContext)context.getContext()).getStack().isStackable()) {
            while (((MergeItemStackContext)context.getContext()).getStack().getCount() > 0 && (!((MergeItemStackContext)context.getContext()).getReverseDirection() && currentSlotIndex < ((MergeItemStackContext)context.getContext()).getEndIndex() || ((MergeItemStackContext)context.getContext()).getReverseDirection() && currentSlotIndex >= ((MergeItemStackContext)context.getContext()).getStartIndex())) {
                slot = (ISlot)((IContainer)context.getInstance()).getInventorySlots().get(currentSlotIndex);
                stackInSlot = slot.getContainedStack();
                if (slot.isItemValid(((MergeItemStackContext)context.getContext()).getStack()) && ItemStackHelper.equalsIgnoreStackSize(((MergeItemStackContext)context.getContext()).getStack(), stackInSlot)) {
                    int slotStackSizeLimit;
                    int combinedStackSize = stackInSlot.getCount() + ((MergeItemStackContext)context.getContext()).getStack().getCount();
                    if (combinedStackSize <= (slotStackSizeLimit = Math.min(stackInSlot.getMaxStackSize(), slot.getSlotStackLimit()))) {
                        ((MergeItemStackContext)context.getContext()).getStack().setCount(0);
                        stackInSlot.setCount(combinedStackSize);
                        slot.onSlotChanged();
                        slotFound = true;
                    } else if (stackInSlot.getCount() < slotStackSizeLimit) {
                        ((MergeItemStackContext)context.getContext()).getStack().shrink(slotStackSizeLimit - stackInSlot.getCount());
                        stackInSlot.setCount(slotStackSizeLimit);
                        slot.onSlotChanged();
                        slotFound = true;
                    }
                }
                if (((MergeItemStackContext)context.getContext()).getReverseDirection() && currentSlotIndex == ((IContainer)context.getInstance()).getInventorySlots().size() - 1) {
                    currentSlotIndex = 0;
                    continue;
                }
                if (!((MergeItemStackContext)context.getContext()).getReverseDirection() && currentSlotIndex == 0) {
                    currentSlotIndex = ((IContainer)context.getInstance()).getInventorySlots().size() - 1;
                    continue;
                }
                currentSlotIndex += ((MergeItemStackContext)context.getContext()).getReverseDirection() ? -1 : 1;
            }
        }
        if (((MergeItemStackContext)context.getContext()).getStack().getCount() > 0) {
            int n2 = currentSlotIndex = ((MergeItemStackContext)context.getContext()).getReverseDirection() ? ((MergeItemStackContext)context.getContext()).getEndIndex() - 1 : ((MergeItemStackContext)context.getContext()).getStartIndex();
            while (!((MergeItemStackContext)context.getContext()).getReverseDirection() && currentSlotIndex < ((MergeItemStackContext)context.getContext()).getEndIndex() || ((MergeItemStackContext)context.getContext()).getReverseDirection() && currentSlotIndex >= ((MergeItemStackContext)context.getContext()).getStartIndex()) {
                slot = (ISlot)((IContainer)context.getInstance()).getInventorySlots().get(currentSlotIndex);
                stackInSlot = slot.getContainedStack();
                if (slot.isItemValid(((MergeItemStackContext)context.getContext()).getStack()) && stackInSlot.isEmpty()) {
                    slot.putStack(ItemStackHelper.cloneItemStack(((MergeItemStackContext)context.getContext()).getStack(), Math.min(((MergeItemStackContext)context.getContext()).getStack().getCount(), slot.getSlotStackLimit())));
                    slot.onSlotChanged();
                    if (slot.getContainedStack().isEmpty()) break;
                    ((MergeItemStackContext)context.getContext()).getStack().shrink(slot.getContainedStack().getCount());
                    slotFound = true;
                    break;
                }
                if (((MergeItemStackContext)context.getContext()).getReverseDirection() && currentSlotIndex == ((IContainer)context.getInstance()).getInventorySlots().size() - 1) {
                    currentSlotIndex = 0;
                    continue;
                }
                if (!((MergeItemStackContext)context.getContext()).getReverseDirection() && currentSlotIndex == 0) {
                    currentSlotIndex = ((IContainer)context.getInstance()).getInventorySlots().size() - 1;
                    continue;
                }
                currentSlotIndex += ((MergeItemStackContext)context.getContext()).getReverseDirection() ? -1 : 1;
            }
        }
        return slotFound;
    }

    private static void initializeSlots(IContainer<BlockOutContainerData> container) {
        int slotIndex = 0;
        List slots = ((BlockOutContainerData)container.getInstanceData()).getRoot().getAllCombinedChildElements().values().stream().filter(element -> element instanceof Slot).map(element -> (Slot)((Object)element)).collect(Collectors.toCollection(LinkedList::new));
        for (Slot slot : slots) {
            IItemHandler itemHandler = ((BlockOutContainerData)container.getInstanceData()).getKey().getItemHandlerManager().getItemHandlerFromId(slot.getInventoryId());
            if (itemHandler == null) {
                StringBuilder errorMessageBuilder = new StringBuilder();
                errorMessageBuilder.append("Failed to find IItemHandler for Slot with index: ").append(slot.getInventoryIndex()).append(" with Inventory Id: ").append(slot.getInventoryId()).append(".\n").append("Possible Inventory candidates are:").append("\n");
                ((BlockOutContainerData)container.getInstanceData()).getKey().getItemHandlerManager().getAllItemHandlerIds().forEach(loc -> errorMessageBuilder.append("  * ").append(loc).append("\n"));
                Log.getLogger().error(errorMessageBuilder.toString());
                throw new IllegalArgumentException("Failed to find IItemHandler for Slot.");
            }
            slot.setSlotIndex(slotIndex++);
            ISlotItemHandler<BlockOutSlotData> slotItemHandler = BlockOutSlotLogic.create(itemHandler, slot);
            container.addSlotToContainer(slotItemHandler);
        }
    }

    private static Integer findStartIndexOfNextInventory(IContainer<BlockOutContainerData> container, ISlotItemHandler<BlockOutSlotData> slotBlockOut) {
        IIdentifier currentInventory = ((BlockOutSlotData)slotBlockOut.getInstanceData()).getUiSlotInstance().getInventoryId();
        IIdentifier workingInventory = ((BlockOutSlotData)slotBlockOut.getInstanceData()).getUiSlotInstance().getInventoryId();
        ISlotItemHandler workingSlot = slotBlockOut;
        while (currentInventory.equals(workingInventory)) {
            ISlotItemHandler iSlotItemHandler = workingSlot = workingSlot.getSlotNumber() + 1 == container.getInventorySlots().size() ? (ISlotItemHandler)container.getInventorySlots().get(0) : (ISlotItemHandler)container.getInventorySlots().get(workingSlot.getSlotNumber() + 1);
            if (workingSlot == slotBlockOut) break;
            workingInventory = ((BlockOutSlotData)workingSlot.getInstanceData()).getUiSlotInstance().getInventoryId();
        }
        if (workingSlot == slotBlockOut) {
            return 0;
        }
        return workingSlot.getSlotNumber();
    }
}

