/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.blockout.gui;

import com.ldtteam.blockout.connector.core.IGuiKey;
import com.ldtteam.blockout.element.IUIElement;
import com.ldtteam.blockout.element.IUIElementHost;
import com.ldtteam.blockout.element.values.AxisDistance;
import com.ldtteam.blockout.gui.BlockOutGuiData;
import com.ldtteam.blockout.inventory.BlockOutContainerData;
import com.ldtteam.blockout.inventory.slot.BlockOutSlotData;
import com.ldtteam.blockout.proxy.ProxyHolder;
import com.ldtteam.blockout.util.keyboard.KeyboardKey;
import com.ldtteam.blockout.util.math.Vector2d;
import com.ldtteam.blockout.util.mouse.MouseButton;
import com.ldtteam.jvoxelizer.IGameEngine;
import com.ldtteam.jvoxelizer.client.gui.IGuiContainer;
import com.ldtteam.jvoxelizer.client.gui.IGuiScreen;
import com.ldtteam.jvoxelizer.client.gui.logic.builder.IGuiContainerBuilder;
import com.ldtteam.jvoxelizer.client.gui.logic.builder.IGuiScreenBuilder;
import com.ldtteam.jvoxelizer.client.gui.logic.builder.contexts.DrawGuiContainerBackgroundLayerContext;
import com.ldtteam.jvoxelizer.client.gui.logic.builder.contexts.DrawGuiContainerForegroundLayerContext;
import com.ldtteam.jvoxelizer.client.gui.logic.builder.contexts.DrawScreenContext;
import com.ldtteam.jvoxelizer.client.gui.logic.builder.contexts.DrawSlotContext;
import com.ldtteam.jvoxelizer.client.gui.logic.builder.contexts.HandleMouseInputContext;
import com.ldtteam.jvoxelizer.client.gui.logic.builder.contexts.InitGuiContext;
import com.ldtteam.jvoxelizer.client.gui.logic.builder.contexts.IsMouseOverSlotContext;
import com.ldtteam.jvoxelizer.client.gui.logic.builder.contexts.KeyTypedContext;
import com.ldtteam.jvoxelizer.client.gui.logic.builder.contexts.MouseClickMoveContext;
import com.ldtteam.jvoxelizer.client.gui.logic.builder.contexts.MouseClickedContext;
import com.ldtteam.jvoxelizer.client.gui.logic.builder.contexts.MouseReleasedContext;
import com.ldtteam.jvoxelizer.client.gui.logic.builder.contexts.UpdateScreenContext;
import com.ldtteam.jvoxelizer.client.mouse.IMouse;
import com.ldtteam.jvoxelizer.client.renderer.opengl.IOpenGl;
import com.ldtteam.jvoxelizer.core.logic.TypedPipelineElementContext;
import com.ldtteam.jvoxelizer.core.logic.VoidPipelineElementContext;
import com.ldtteam.jvoxelizer.entity.living.player.IPlayerEntity;
import com.ldtteam.jvoxelizer.inventory.IContainer;
import java.util.function.Consumer;
import java.util.function.Function;

public class BlockOutGuiLogic {
    public static IGuiContainer<BlockOutGuiData> create(IGuiKey key, IUIElementHost host, IContainer<BlockOutContainerData> container) {
        IGuiContainerBuilder builder = IGuiContainerBuilder.create((Object)new BlockOutGuiData(key, host), container);
        IGuiContainer gui = (IGuiContainer)((IGuiContainerBuilder)((IGuiContainerBuilder)((IGuiContainerBuilder)((IGuiContainerBuilder)((IGuiContainerBuilder)((IGuiContainerBuilder)((IGuiContainerBuilder)((IGuiContainerBuilder)builder.HandleMouseInput(new Consumer[]{BlockOutGuiLogic::handleMouseInputContainer})).InitGui(new Consumer[]{BlockOutGuiLogic::initContainerGui})).DrawScreen(new Consumer[]{BlockOutGuiLogic::drawScreenContainer})).DrawGuiContainerForegroundLayer(new Consumer[]{BlockOutGuiLogic::drawGuiContainerForegroundLayer}).DrawGuiContainerBackgroundLayer(new Consumer[]{BlockOutGuiLogic::drawGuiContainerBackgroundLayer}).DrawSlot(new Consumer[]{BlockOutGuiLogic::drawSlot}).MouseClicked(new Consumer[]{BlockOutGuiLogic::mouseClickedContainer})).MouseClickMove(new Consumer[]{BlockOutGuiLogic::mouseClickMoveContainer})).MouseReleased(new Consumer[]{BlockOutGuiLogic::mouseReleasedContainer})).IsMouseOverSlot(new Function[]{BlockOutGuiLogic::isMouseOverSlot}).KeyTyped(new Consumer[]{BlockOutGuiLogic::keyTypedContainer})).UpdateScreen(new Consumer[]{BlockOutGuiLogic::updateScreen})).build();
        host.getUiManager().getRenderManager().setGuiData((BlockOutGuiData)gui.getInstanceData());
        return gui;
    }

    public static IGuiScreen<BlockOutGuiData> createClientSideOnly(IGuiKey key, IUIElementHost host) {
        IGuiScreenBuilder builder = IGuiScreenBuilder.create((Object)new BlockOutGuiData(key, host));
        IGuiScreen gui = (IGuiScreen)builder.HandleMouseInput(new Consumer[]{BlockOutGuiLogic::handleMouseInputScreen}).InitGui(new Consumer[]{BlockOutGuiLogic::initScreenGui}).DrawScreen(new Consumer[]{BlockOutGuiLogic::drawScreenScreen}).MouseClicked(new Consumer[]{BlockOutGuiLogic::mouseClickedScreen}).MouseClickMove(new Consumer[]{BlockOutGuiLogic::mouseClickMoveScreen}).MouseReleased(new Consumer[]{BlockOutGuiLogic::mouseReleasedScreen}).KeyTyped(new Consumer[]{BlockOutGuiLogic::keyTypedScreen}).UpdateScreen(new Consumer[]{BlockOutGuiLogic::updateScreen}).build();
        host.getUiManager().getRenderManager().setGuiData((BlockOutGuiData)gui.getInstanceData());
        return gui;
    }

    private static void handleMouseInputContainer(VoidPipelineElementContext<HandleMouseInputContext, IGuiContainer<BlockOutGuiData>, BlockOutGuiData> context) {
        int scaledMouseX = (int)(IMouse.getX() * (double)((IGuiContainer)context.getInstance()).getWidth() / (double)IGameEngine.getInstance().getDisplayWidth() * ((BlockOutGuiData)context.getInstanceData()).getScaleFactor().getX());
        int scaledMouseY = (int)(((double)((IGuiContainer)context.getInstance()).getHeight() - IMouse.getY() * (double)((IGuiContainer)context.getInstance()).getHeight() / (double)IGameEngine.getInstance().getDisplayHeight() - 1.0) * ((BlockOutGuiData)context.getInstanceData()).getScaleFactor().getY());
        int delta = IMouse.getDWheel();
        if (delta != 0 && !((BlockOutGuiData)context.getInstanceData()).getRoot().getUiManager().getClientSideScrollManager().onMouseWheel((int)((double)scaledMouseX - ((BlockOutGuiData)context.getInstanceData()).getGuiLeft() * ((BlockOutGuiData)context.getInstanceData()).getScaleFactor().getX()), (int)((double)scaledMouseY - ((BlockOutGuiData)context.getInstanceData()).getGuiTop() * ((BlockOutGuiData)context.getInstanceData()).getScaleFactor().getY()), delta)) {
            ((BlockOutGuiData)context.getInstanceData()).getRoot().getUiManager().getNetworkManager().onMouseWheel((int)((double)scaledMouseX - ((BlockOutGuiData)context.getInstanceData()).getGuiLeft() * ((BlockOutGuiData)context.getInstanceData()).getScaleFactor().getX()), (int)((double)scaledMouseY - ((BlockOutGuiData)context.getInstanceData()).getGuiTop() * ((BlockOutGuiData)context.getInstanceData()).getScaleFactor().getY()), delta);
        }
        context.callSuper();
    }

    private static void handleMouseInputScreen(VoidPipelineElementContext<HandleMouseInputContext, IGuiScreen<BlockOutGuiData>, BlockOutGuiData> context) {
        int scaledMouseX = (int)(IMouse.getX() * (double)((IGuiScreen)context.getInstance()).getWidth() / (double)IGameEngine.getInstance().getDisplayWidth() * ((BlockOutGuiData)context.getInstanceData()).getScaleFactor().getX());
        int scaledMouseY = (int)(((double)((IGuiScreen)context.getInstance()).getHeight() - IMouse.getY() * (double)((IGuiScreen)context.getInstance()).getHeight() / (double)IGameEngine.getInstance().getDisplayHeight() - 1.0) * ((BlockOutGuiData)context.getInstanceData()).getScaleFactor().getY());
        int delta = IMouse.getDWheel();
        if (delta != 0 && !((BlockOutGuiData)context.getInstanceData()).getRoot().getUiManager().getClientSideScrollManager().onMouseWheel(scaledMouseX, scaledMouseY, delta)) {
            ((BlockOutGuiData)context.getInstanceData()).getRoot().getUiManager().getScrollManager().onMouseWheel(scaledMouseX, scaledMouseY, delta);
        }
        context.callSuper();
    }

    private static void initContainerGui(VoidPipelineElementContext<InitGuiContext, IGuiContainer<BlockOutGuiData>, BlockOutGuiData> context) {
        ((BlockOutGuiData)context.getInstanceData()).getRoot().getUiManager().getUpdateManager().updateElement((IUIElement)((BlockOutGuiData)context.getInstanceData()).getRoot());
        ((BlockOutGuiData)context.getInstanceData()).setXSize((double)((int)((BlockOutGuiData)context.getInstanceData()).getRoot().getLocalBoundingBox().getSize().getX()));
        ((BlockOutGuiData)context.getInstanceData()).setYSize((double)((int)((BlockOutGuiData)context.getInstanceData()).getRoot().getLocalBoundingBox().getSize().getY()));
        ((BlockOutGuiData)context.getInstanceData()).setScaleFactor(new Vector2d(1.0, 1.0));
        if (((BlockOutGuiData)context.getInstanceData()).getXSize() > (double)((IGuiContainer)context.getInstance()).getWidth() || ((BlockOutGuiData)context.getInstanceData()).getYSize() > (double)((IGuiContainer)context.getInstance()).getHeight()) {
            double xScalingFactor = Math.ceil(((BlockOutGuiData)context.getInstanceData()).getRoot().getLocalBoundingBox().getSize().getX() / (double)((IGuiContainer)context.getInstance()).getWidth());
            double yScalingFactor = Math.ceil(((BlockOutGuiData)context.getInstanceData()).getRoot().getLocalBoundingBox().getSize().getY() / (double)((IGuiContainer)context.getInstance()).getHeight());
            yScalingFactor = xScalingFactor = Math.max(xScalingFactor, yScalingFactor);
            ((BlockOutGuiData)context.getInstanceData()).setScaleFactor(new Vector2d(xScalingFactor, yScalingFactor));
            ((BlockOutGuiData)context.getInstanceData()).setXSize((double)((int)(((BlockOutGuiData)context.getInstanceData()).getRoot().getLocalBoundingBox().getSize().getX() / xScalingFactor)));
            ((BlockOutGuiData)context.getInstanceData()).setYSize((double)((int)(((BlockOutGuiData)context.getInstanceData()).getRoot().getLocalBoundingBox().getSize().getY() / xScalingFactor)));
        }
        ((BlockOutGuiData)context.getInstanceData()).getRoot().getUiManager().getRenderManager().setRenderingScalingFactor(((BlockOutGuiData)context.getInstanceData()).getScaleFactor());
        ((IGuiContainer)context.getInstance()).setXSize((int)((BlockOutGuiData)context.getInstanceData()).getXSize());
        ((IGuiContainer)context.getInstance()).setYSize((int)((BlockOutGuiData)context.getInstanceData()).getYSize());
        context.callSuper();
        ((BlockOutGuiData)context.getInstanceData()).setGuiOffset((double)((IGuiContainer)context.getInstance()).getGuiTop(), (double)((IGuiContainer)context.getInstance()).getGuiLeft());
        int scaledGuiLeft = (int)(((BlockOutGuiData)context.getInstanceData()).getGuiLeft() * ((BlockOutGuiData)context.getInstanceData()).getScaleFactor().getX());
        int scaledGuiTop = (int)(((BlockOutGuiData)context.getInstanceData()).getGuiTop() * ((BlockOutGuiData)context.getInstanceData()).getScaleFactor().getY());
        ((BlockOutGuiData)context.getInstanceData()).getRoot().setMargin(new AxisDistance((Number)scaledGuiLeft, (Number)scaledGuiTop, (Number)scaledGuiLeft, (Number)scaledGuiTop));
        ((BlockOutGuiData)context.getInstanceData()).getRoot().getUiManager().getUpdateManager().updateElement((IUIElement)((BlockOutGuiData)context.getInstanceData()).getRoot());
    }

    private static void initScreenGui(VoidPipelineElementContext<InitGuiContext, IGuiScreen<BlockOutGuiData>, BlockOutGuiData> context) {
        ((BlockOutGuiData)context.getInstanceData()).getRoot().getUiManager().getUpdateManager().updateElement((IUIElement)((BlockOutGuiData)context.getInstanceData()).getRoot());
        ((BlockOutGuiData)context.getInstanceData()).setXSize((double)((int)((BlockOutGuiData)context.getInstanceData()).getRoot().getLocalBoundingBox().getSize().getX()));
        ((BlockOutGuiData)context.getInstanceData()).setYSize((double)((int)((BlockOutGuiData)context.getInstanceData()).getRoot().getLocalBoundingBox().getSize().getY()));
        ((BlockOutGuiData)context.getInstanceData()).setScaleFactor(new Vector2d(1.0, 1.0));
        if (((BlockOutGuiData)context.getInstanceData()).getXSize() > (double)((IGuiScreen)context.getInstance()).getWidth() || ((BlockOutGuiData)context.getInstanceData()).getYSize() > (double)((IGuiScreen)context.getInstance()).getHeight()) {
            double xScalingFactor = Math.ceil(((BlockOutGuiData)context.getInstanceData()).getRoot().getLocalBoundingBox().getSize().getX() / (double)((IGuiScreen)context.getInstance()).getWidth());
            double yScalingFactor = Math.ceil(((BlockOutGuiData)context.getInstanceData()).getRoot().getLocalBoundingBox().getSize().getY() / (double)((IGuiScreen)context.getInstance()).getHeight());
            yScalingFactor = xScalingFactor = Math.max(xScalingFactor, yScalingFactor);
            ((BlockOutGuiData)context.getInstanceData()).setScaleFactor(new Vector2d(xScalingFactor, yScalingFactor));
            ((BlockOutGuiData)context.getInstanceData()).setXSize((double)((int)(((BlockOutGuiData)context.getInstanceData()).getRoot().getLocalBoundingBox().getSize().getX() / xScalingFactor)));
            ((BlockOutGuiData)context.getInstanceData()).setYSize((double)((int)(((BlockOutGuiData)context.getInstanceData()).getRoot().getLocalBoundingBox().getSize().getY() / xScalingFactor)));
        }
        ((BlockOutGuiData)context.getInstanceData()).getRoot().getUiManager().getRenderManager().setRenderingScalingFactor(((BlockOutGuiData)context.getInstanceData()).getScaleFactor());
        context.callSuper();
        ((BlockOutGuiData)context.getInstanceData()).setGuiOffset(((double)((IGuiScreen)context.getInstance()).getHeight() - ((BlockOutGuiData)context.getInstanceData()).getYSize()) / 2.0, ((double)((IGuiScreen)context.getInstance()).getWidth() - ((BlockOutGuiData)context.getInstanceData()).getXSize()) / 2.0);
        int scaledGuiLeft = (int)(((BlockOutGuiData)context.getInstanceData()).getGuiLeft() * ((BlockOutGuiData)context.getInstanceData()).getScaleFactor().getX());
        int scaledGuiTop = (int)(((BlockOutGuiData)context.getInstanceData()).getGuiTop() * ((BlockOutGuiData)context.getInstanceData()).getScaleFactor().getY());
        ((BlockOutGuiData)context.getInstanceData()).getRoot().setMargin(new AxisDistance((Number)scaledGuiLeft, (Number)scaledGuiTop, (Number)scaledGuiLeft, (Number)scaledGuiTop));
        ((BlockOutGuiData)context.getInstanceData()).getRoot().getUiManager().getUpdateManager().updateElement((IUIElement)((BlockOutGuiData)context.getInstanceData()).getRoot());
    }

    private static void drawScreenContainer(VoidPipelineElementContext<DrawScreenContext, IGuiContainer<BlockOutGuiData>, BlockOutGuiData> context) {
        ((BlockOutGuiData)context.getInstanceData()).setDrawing(true);
        int scaledMouseX = (int)((double)((DrawScreenContext)context.getContext()).getMouseX() * ((BlockOutGuiData)context.getInstanceData()).getScaleFactor().getX());
        int scaledMouseY = (int)((double)((DrawScreenContext)context.getContext()).getMouseY() * ((BlockOutGuiData)context.getInstanceData()).getScaleFactor().getY());
        ((BlockOutGuiData)context.getInstanceData()).getRoot().getUiManager().getRenderManager().getRenderingController().setMousePosition(scaledMouseX, scaledMouseY);
        IOpenGl.pushMatrix();
        IOpenGl.scale((double)(1.0 / ((BlockOutGuiData)context.getInstanceData()).getScaleFactor().getX()), (double)(1.0 / ((BlockOutGuiData)context.getInstanceData()).getScaleFactor().getY()), (double)1.0);
        IOpenGl.pushMatrix();
        context.callSuper();
        IOpenGl.popMatrix();
        IOpenGl.popMatrix();
        ((BlockOutGuiData)context.getInstanceData()).setDrawing(false);
    }

    private static void drawScreenScreen(VoidPipelineElementContext<DrawScreenContext, IGuiScreen<BlockOutGuiData>, BlockOutGuiData> context) {
        ((BlockOutGuiData)context.getInstanceData()).setDrawing(true);
        int scaledMouseX = (int)((double)((DrawScreenContext)context.getContext()).getMouseX() * ((BlockOutGuiData)context.getInstanceData()).getScaleFactor().getX());
        int scaledMouseY = (int)((double)((DrawScreenContext)context.getContext()).getMouseY() * ((BlockOutGuiData)context.getInstanceData()).getScaleFactor().getY());
        ((BlockOutGuiData)context.getInstanceData()).getRoot().getUiManager().getRenderManager().getRenderingController().setMousePosition(scaledMouseX, scaledMouseY);
        IOpenGl.pushMatrix();
        IOpenGl.scale((double)(1.0 / ((BlockOutGuiData)context.getInstanceData()).getScaleFactor().getX()), (double)(1.0 / ((BlockOutGuiData)context.getInstanceData()).getScaleFactor().getY()), (double)1.0);
        IOpenGl.pushMatrix();
        BlockOutGuiLogic.doDrawGuiContainerBackgroundLayer(((BlockOutGuiData)context.getInstanceData()).getRoot());
        IOpenGl.disableRescaleNormal();
        IOpenGl.disableStandardItemLighting();
        IOpenGl.disableLighting();
        IOpenGl.disableDepth();
        context.callSuper();
        IOpenGl.enableStandardItemLighting();
        IOpenGl.pushMatrix();
        IOpenGl.translate((float)((float)((BlockOutGuiData)context.getInstanceData()).getGuiLeft()), (float)((float)((BlockOutGuiData)context.getInstanceData()).getGuiTop()), (float)0.0f);
        IOpenGl.color((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        IOpenGl.enableRescaleNormal();
        IOpenGl.disableStandardItemLighting();
        BlockOutGuiLogic.doDrawGuiContainerForegroundLayer(((BlockOutGuiData)context.getInstanceData()).getRoot());
        IOpenGl.popMatrix();
        IOpenGl.enableLighting();
        IOpenGl.enableDepth();
        IOpenGl.enableStandardItemLighting();
        IOpenGl.popMatrix();
        IOpenGl.popMatrix();
        ((BlockOutGuiData)context.getInstanceData()).setDrawing(false);
    }

    private static <G extends IGuiScreen<BlockOutGuiData>> void drawGuiContainerForegroundLayer(VoidPipelineElementContext<DrawGuiContainerForegroundLayerContext, G, BlockOutGuiData> context) {
        BlockOutGuiLogic.doDrawGuiContainerForegroundLayer(((BlockOutGuiData)context.getInstanceData()).getRoot());
    }

    private static void doDrawGuiContainerForegroundLayer(IUIElementHost root) {
        root.getUiManager().getRenderManager().drawForeground((IUIElement)root);
    }

    private static <G extends IGuiScreen<BlockOutGuiData>> void drawGuiContainerBackgroundLayer(VoidPipelineElementContext<DrawGuiContainerBackgroundLayerContext, G, BlockOutGuiData> context) {
        BlockOutGuiLogic.doDrawGuiContainerBackgroundLayer(((BlockOutGuiData)context.getInstanceData()).getRoot());
    }

    private static void doDrawGuiContainerBackgroundLayer(IUIElementHost root) {
        root.getUiManager().getRenderManager().drawBackground((IUIElement)root);
    }

    private static void drawSlot(VoidPipelineElementContext<DrawSlotContext, IGuiContainer<BlockOutGuiData>, BlockOutGuiData> context) {
        if (((BlockOutGuiData)context.getInstanceData()).isDrawing() && ((DrawSlotContext)context.getContext()).getSlot() instanceof BlockOutSlotData) {
            return;
        }
        context.callSuper();
    }

    private static void mouseClickedContainer(VoidPipelineElementContext<MouseClickedContext, IGuiContainer<BlockOutGuiData>, BlockOutGuiData> context) {
        int scaledMouseX = (int)((double)((MouseClickedContext)context.getContext()).getMouseX() * ((BlockOutGuiData)context.getInstanceData()).getScaleFactor().getX());
        int scaledMouseY = (int)((double)((MouseClickedContext)context.getContext()).getMouseY() * ((BlockOutGuiData)context.getInstanceData()).getScaleFactor().getY());
        ((MouseClickedContext)context.getContext()).setMouseX(scaledMouseX);
        ((MouseClickedContext)context.getContext()).setMouseY(scaledMouseY);
        context.callSuper();
        if (!((BlockOutGuiData)context.getInstanceData()).getRoot().getUiManager().getClientSideClickManager().onMouseClickBegin(scaledMouseX, scaledMouseY, MouseButton.getForCode((int)((MouseClickedContext)context.getContext()).getMouseButton()))) {
            ((BlockOutGuiData)context.getInstanceData()).getRoot().getUiManager().getNetworkManager().onMouseClickBegin((int)((double)scaledMouseX - ((BlockOutGuiData)context.getInstanceData()).getGuiLeft() * ((BlockOutGuiData)context.getInstanceData()).getScaleFactor().getX()), (int)((double)scaledMouseY - ((BlockOutGuiData)context.getInstanceData()).getGuiTop() * ((BlockOutGuiData)context.getInstanceData()).getScaleFactor().getY()), MouseButton.getForCode((int)((MouseClickedContext)context.getContext()).getMouseButton()));
        }
    }

    private static void mouseClickedScreen(VoidPipelineElementContext<MouseClickedContext, IGuiScreen<BlockOutGuiData>, BlockOutGuiData> context) {
        int scaledMouseX = (int)((double)((MouseClickedContext)context.getContext()).getMouseX() * ((BlockOutGuiData)context.getInstanceData()).getScaleFactor().getX());
        int scaledMouseY = (int)((double)((MouseClickedContext)context.getContext()).getMouseY() * ((BlockOutGuiData)context.getInstanceData()).getScaleFactor().getY());
        ((MouseClickedContext)context.getContext()).setMouseX(scaledMouseX);
        ((MouseClickedContext)context.getContext()).setMouseY(scaledMouseY);
        context.callSuper();
        if (!((BlockOutGuiData)context.getInstanceData()).getRoot().getUiManager().getClientSideClickManager().onMouseClickBegin(scaledMouseX, scaledMouseY, MouseButton.getForCode((int)((MouseClickedContext)context.getContext()).getMouseButton()))) {
            ((BlockOutGuiData)context.getInstanceData()).getRoot().getUiManager().getClickManager().onMouseClickBegin(scaledMouseX, scaledMouseY, MouseButton.getForCode((int)((MouseClickedContext)context.getContext()).getMouseButton()));
        }
    }

    private static void mouseClickMoveContainer(VoidPipelineElementContext<MouseClickMoveContext, IGuiContainer<BlockOutGuiData>, BlockOutGuiData> context) {
        int scaledMouseX = (int)((double)((MouseClickMoveContext)context.getContext()).getMouseX() * ((BlockOutGuiData)context.getInstanceData()).getScaleFactor().getX());
        int scaledMouseY = (int)((double)((MouseClickMoveContext)context.getContext()).getMouseY() * ((BlockOutGuiData)context.getInstanceData()).getScaleFactor().getY());
        ((MouseClickMoveContext)context.getContext()).setMouseX(scaledMouseX);
        ((MouseClickMoveContext)context.getContext()).setMouseY(scaledMouseY);
        context.callSuper();
        if (!((BlockOutGuiData)context.getInstanceData()).getRoot().getUiManager().getClientSideClickManager().onMouseClickMove(scaledMouseX, scaledMouseY, MouseButton.getForCode((int)((MouseClickMoveContext)context.getContext()).getClickedMouseButton()), (float)((MouseClickMoveContext)context.getContext()).getTimeSinceLastClick())) {
            ((BlockOutGuiData)context.getInstanceData()).getRoot().getUiManager().getNetworkManager().onMouseClickMove((int)((double)scaledMouseX - ((BlockOutGuiData)context.getInstanceData()).getGuiLeft() * ((BlockOutGuiData)context.getInstanceData()).getScaleFactor().getX()), (int)((double)scaledMouseY - ((BlockOutGuiData)context.getInstanceData()).getGuiTop() * ((BlockOutGuiData)context.getInstanceData()).getScaleFactor().getY()), MouseButton.getForCode((int)((MouseClickMoveContext)context.getContext()).getClickedMouseButton()), (float)((MouseClickMoveContext)context.getContext()).getTimeSinceLastClick());
        }
    }

    private static void mouseClickMoveScreen(VoidPipelineElementContext<MouseClickMoveContext, IGuiScreen<BlockOutGuiData>, BlockOutGuiData> context) {
        int scaledMouseX = (int)((double)((MouseClickMoveContext)context.getContext()).getMouseX() * ((BlockOutGuiData)context.getInstanceData()).getScaleFactor().getX());
        int scaledMouseY = (int)((double)((MouseClickMoveContext)context.getContext()).getMouseY() * ((BlockOutGuiData)context.getInstanceData()).getScaleFactor().getY());
        ((MouseClickMoveContext)context.getContext()).setMouseX(scaledMouseX);
        ((MouseClickMoveContext)context.getContext()).setMouseY(scaledMouseY);
        context.callSuper();
        if (!((BlockOutGuiData)context.getInstanceData()).getRoot().getUiManager().getClientSideClickManager().onMouseClickMove(scaledMouseX, scaledMouseY, MouseButton.getForCode((int)((MouseClickMoveContext)context.getContext()).getClickedMouseButton()), (float)((MouseClickMoveContext)context.getContext()).getTimeSinceLastClick())) {
            ((BlockOutGuiData)context.getInstanceData()).getRoot().getUiManager().getClickManager().onMouseClickMove(scaledMouseX, scaledMouseY, MouseButton.getForCode((int)((MouseClickMoveContext)context.getContext()).getClickedMouseButton()), (float)((MouseClickMoveContext)context.getContext()).getTimeSinceLastClick());
        }
    }

    private static void mouseReleasedContainer(VoidPipelineElementContext<MouseReleasedContext, IGuiContainer<BlockOutGuiData>, BlockOutGuiData> context) {
        int scaledMouseX = (int)((double)((MouseReleasedContext)context.getContext()).getMouseX() * ((BlockOutGuiData)context.getInstanceData()).getScaleFactor().getX());
        int scaledMouseY = (int)((double)((MouseReleasedContext)context.getContext()).getMouseY() * ((BlockOutGuiData)context.getInstanceData()).getScaleFactor().getY());
        ((MouseReleasedContext)context.getContext()).setMouseX(scaledMouseX);
        ((MouseReleasedContext)context.getContext()).setMouseY(scaledMouseY);
        context.callSuper();
        if (!((BlockOutGuiData)context.getInstanceData()).getRoot().getUiManager().getClientSideClickManager().onMouseClickEnd(scaledMouseX, scaledMouseY, MouseButton.getForCode((int)((MouseReleasedContext)context.getContext()).getState()))) {
            ((BlockOutGuiData)context.getInstanceData()).getRoot().getUiManager().getNetworkManager().onMouseClickEnd((int)((double)scaledMouseX - ((BlockOutGuiData)context.getInstanceData()).getGuiLeft() * ((BlockOutGuiData)context.getInstanceData()).getScaleFactor().getX()), (int)((double)scaledMouseY - ((BlockOutGuiData)context.getInstanceData()).getGuiTop() * ((BlockOutGuiData)context.getInstanceData()).getScaleFactor().getY()), MouseButton.getForCode((int)((MouseReleasedContext)context.getContext()).getState()));
        }
    }

    private static void mouseReleasedScreen(VoidPipelineElementContext<MouseReleasedContext, IGuiScreen<BlockOutGuiData>, BlockOutGuiData> context) {
        int scaledMouseX = (int)((double)((MouseReleasedContext)context.getContext()).getMouseX() * ((BlockOutGuiData)context.getInstanceData()).getScaleFactor().getX());
        int scaledMouseY = (int)((double)((MouseReleasedContext)context.getContext()).getMouseY() * ((BlockOutGuiData)context.getInstanceData()).getScaleFactor().getY());
        ((MouseReleasedContext)context.getContext()).setMouseX(scaledMouseX);
        ((MouseReleasedContext)context.getContext()).setMouseY(scaledMouseY);
        context.callSuper();
        if (!((BlockOutGuiData)context.getInstanceData()).getRoot().getUiManager().getClientSideClickManager().onMouseClickEnd(scaledMouseX, scaledMouseY, MouseButton.getForCode((int)((MouseReleasedContext)context.getContext()).getState()))) {
            ((BlockOutGuiData)context.getInstanceData()).getRoot().getUiManager().getClickManager().onMouseClickEnd(scaledMouseX, scaledMouseY, MouseButton.getForCode((int)((MouseReleasedContext)context.getContext()).getState()));
        }
    }

    private static boolean isMouseOverSlot(TypedPipelineElementContext<IsMouseOverSlotContext, Boolean, IGuiContainer<BlockOutGuiData>, BlockOutGuiData> context) {
        int scaledMouseX = (int)((double)((IsMouseOverSlotContext)context.getContext()).getMouseX() * ((BlockOutGuiData)context.getInstanceData()).getScaleFactor().getX());
        int scaledMouseY = (int)((double)((IsMouseOverSlotContext)context.getContext()).getMouseY() * ((BlockOutGuiData)context.getInstanceData()).getScaleFactor().getY());
        ((IsMouseOverSlotContext)context.getContext()).setMouseX(scaledMouseX);
        ((IsMouseOverSlotContext)context.getContext()).setMouseY(scaledMouseY);
        return (!((BlockOutGuiData)context.getInstanceData()).isDrawing() && (!(((IsMouseOverSlotContext)context.getContext()).getSlot() instanceof BlockOutSlotData) || ((BlockOutSlotData)((IsMouseOverSlotContext)context.getContext()).getSlot()).getUiSlotInstance().isEnabled()) || !(((IsMouseOverSlotContext)context.getContext()).getSlot() instanceof BlockOutSlotData)) && (Boolean)context.callSuper() != false;
    }

    private static void keyTypedContainer(VoidPipelineElementContext<KeyTypedContext, IGuiContainer<BlockOutGuiData>, BlockOutGuiData> context) {
        KeyboardKey key = KeyboardKey.getForCode((int)((KeyTypedContext)context.getContext()).getKeyCode());
        if (key == KeyboardKey.KEY_ESCAPE) {
            ProxyHolder.getInstance().getGuiController().closeUI((IPlayerEntity)IGameEngine.getInstance().getSinglePlayerPlayerEntity());
            return;
        }
        if (!((BlockOutGuiData)context.getInstanceData()).getRoot().getUiManager().getClientSideKeyManager().onKeyPressed((int)((KeyTypedContext)context.getContext()).getTypedChar(), key)) {
            ((BlockOutGuiData)context.getInstanceData()).getRoot().getUiManager().getNetworkManager().onKeyPressed((int)((KeyTypedContext)context.getContext()).getTypedChar(), key);
        }
    }

    private static void keyTypedScreen(VoidPipelineElementContext<KeyTypedContext, IGuiScreen<BlockOutGuiData>, BlockOutGuiData> context) {
        KeyboardKey key = KeyboardKey.getForCode((int)((KeyTypedContext)context.getContext()).getKeyCode());
        if (key == KeyboardKey.KEY_ESCAPE) {
            ProxyHolder.getInstance().getClientSideOnlyGuiController().closeUI((IPlayerEntity)IGameEngine.getInstance().getSinglePlayerPlayerEntity());
            return;
        }
        if (!((BlockOutGuiData)context.getInstanceData()).getRoot().getUiManager().getClientSideKeyManager().onKeyPressed((int)((KeyTypedContext)context.getContext()).getTypedChar(), key)) {
            ((BlockOutGuiData)context.getInstanceData()).getRoot().getUiManager().getKeyManager().onKeyPressed((int)((KeyTypedContext)context.getContext()).getTypedChar(), key);
        }
    }

    private static <G extends IGuiScreen<BlockOutGuiData>> void updateScreen(VoidPipelineElementContext<UpdateScreenContext, G, BlockOutGuiData> context) {
        if (context.getInstance() instanceof IGuiContainer) {
            ((BlockOutGuiData)context.getInstanceData()).setGuiOffset((double)((IGuiContainer)context.getInstance()).getGuiTop(), (double)((IGuiContainer)context.getInstance()).getGuiLeft());
            ((BlockOutGuiData)context.getInstanceData()).setGuiSize((double)((IGuiContainer)context.getInstance()).getXSize(), (double)((IGuiContainer)context.getInstance()).getYSize());
        }
    }
}

