/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.blockout.element.template;

import com.google.common.collect.Lists;
import com.ldtteam.blockout.binding.dependency.IDependencyObject;
import com.ldtteam.blockout.binding.dependency.IDependencyReceiver;
import com.ldtteam.blockout.binding.property.Property;
import com.ldtteam.blockout.element.IUIElement;
import com.ldtteam.blockout.element.IUIElementHost;
import com.ldtteam.blockout.factory.IUIElementFactory;
import com.ldtteam.blockout.loader.binding.core.IBindingEngine;
import com.ldtteam.blockout.loader.binding.engine.SimpleBindingEngine;
import com.ldtteam.blockout.loader.core.IUIElementData;
import com.ldtteam.blockout.loader.core.IUIElementDataBuilder;
import com.ldtteam.blockout.loader.core.IUIElementMetaData;
import com.ldtteam.blockout.loader.wrapped.WrappedUIElementData;
import com.ldtteam.blockout.proxy.ProxyHolder;
import com.ldtteam.blockout.util.Constants;
import com.ldtteam.blockout.utils.controlconstruction.element.core.AbstractChildrenContainingUIElement;
import com.ldtteam.jvoxelizer.util.identifier.IIdentifier;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Template
extends AbstractChildrenContainingUIElement {
    private final IUIElementData<?> ownData;

    public Template(@NotNull IDependencyObject<IIdentifier> style, @NotNull String id, @NotNull IUIElementData ownData) {
        super(Constants.Controls.Template.KEY_TEMPLATE, style, id, null);
        this.ownData = ownData;
        this.setParent((IUIElementHost)this);
    }

    public IUIElement generateInstance(final @NotNull IUIElementHost instanceParent, final @NotNull IDependencyObject<Object> boundContext, final @NotNull String controlId, @NotNull Function<IUIElementData, IUIElementData> dataOverrideCallback) {
        IDependencyObject childrenData = this.ownData.getFromRawDataWithDefault("children", (IBindingEngine)SimpleBindingEngine.getInstance(), (Object)Lists.newArrayList(), Constants.ConverterTypes.CHILDREN_LIST_TYPE, new Object[]{instanceParent});
        List childDatas = (List)childrenData.get((IDependencyReceiver)instanceParent);
        if (childDatas.size() != 1) {
            throw new IllegalStateException(String.format("Template: %s needs to have exactly one child.", this.getId()));
        }
        IUIElementData childData = (IUIElementData)childDatas.get(0);
        final IUIElementData convertedChildData = dataOverrideCallback.apply(childData);
        WrappedUIElementData wrappedUIElementData = new WrappedUIElementData(convertedChildData){

            @Override
            @NotNull
            public IUIElementMetaData getMetaData() {
                return new IUIElementMetaData(){

                    public String getType() {
                        return convertedChildData.getMetaData().getType();
                    }

                    public String getId() {
                        return controlId;
                    }

                    public Optional<IUIElementHost> getParent() {
                        return Optional.ofNullable(instanceParent);
                    }

                    public boolean hasChildren() {
                        return convertedChildData.getMetaData().hasChildren();
                    }
                };
            }

            public IDependencyObject getFromRawDataWithProperty(@NotNull String name, @NotNull IBindingEngine engine, @NotNull Property defaultProperty, @NotNull Object defaultValue, @NotNull Type targetType, Object ... params) {
                if (name.equals("context")) {
                    return boundContext;
                }
                return convertedChildData.getFromRawDataWithProperty(name, engine, defaultProperty, defaultValue, targetType, params);
            }

            public Object getRawWithoutBinding(@NotNull String name, @Nullable Object defaultValue, @NotNull Type targetType, Object ... params) {
                if (name.equals("context")) {
                    return boundContext;
                }
                return convertedChildData.getRawWithoutBinding(name, defaultValue, targetType, params);
            }
        };
        return ProxyHolder.getInstance().getFactoryController().getElementFromData((IUIElementData)wrappedUIElementData);
    }

    public static final class Factory
    implements IUIElementFactory<Template> {
        @NotNull
        public Class<Template> getProducedElementClass() {
            return Template.class;
        }

        @NotNull
        public String getTypeName() {
            return Constants.Controls.Template.KEY_TEMPLATE;
        }

        @NotNull
        public Template readFromElementData(@NotNull IUIElementData<?> elementData, @NotNull IBindingEngine engine) {
            IDependencyObject style = elementData.getFromRawDataWithDefault("style", engine, (Object)IIdentifier.create((String)"minecraft:missingno"), IIdentifier.class, new Object[0]);
            String templateId = elementData.getMetaData().getId();
            return new Template((IDependencyObject<IIdentifier>)style, templateId, elementData);
        }

        public void writeToElementData(@NotNull Template element, @NotNull IUIElementDataBuilder<?> builder) {
            builder.copyFrom(element.ownData);
        }
    }
}

