/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.blockout.element.simple;

import com.ldtteam.blockout.binding.dependency.DependencyObjectHelper;
import com.ldtteam.blockout.binding.dependency.IDependencyObject;
import com.ldtteam.blockout.binding.dependency.IDependencyReceiver;
import com.ldtteam.blockout.builder.core.builder.IBlockOutGuiConstructionDataBuilder;
import com.ldtteam.blockout.compat.ClientTickManager;
import com.ldtteam.blockout.element.IUIElement;
import com.ldtteam.blockout.element.IUIElementHost;
import com.ldtteam.blockout.element.drawable.IDrawableUIElement;
import com.ldtteam.blockout.element.input.IKeyAcceptingUIElement;
import com.ldtteam.blockout.element.input.client.IClientSideClickAcceptingUIElement;
import com.ldtteam.blockout.element.input.client.IClientSideKeyAcceptingUIElement;
import com.ldtteam.blockout.element.values.Alignment;
import com.ldtteam.blockout.element.values.AxisDistance;
import com.ldtteam.blockout.element.values.Dock;
import com.ldtteam.blockout.event.Event;
import com.ldtteam.blockout.event.IEventHandler;
import com.ldtteam.blockout.management.update.IUpdateManager;
import com.ldtteam.blockout.network.NetworkManager;
import com.ldtteam.blockout.network.message.TextFieldOnEnterPressed;
import com.ldtteam.blockout.network.message.TextFieldTabPressedMessage;
import com.ldtteam.blockout.network.message.TextFieldUpdateContentsMessage;
import com.ldtteam.blockout.network.message.TextFieldUpdateSelectionEndOrCursorPositionMessage;
import com.ldtteam.blockout.proxy.ProxyHolder;
import com.ldtteam.blockout.render.core.IRenderingController;
import com.ldtteam.blockout.util.Constants;
import com.ldtteam.blockout.util.color.ColorUtils;
import com.ldtteam.blockout.util.color.IColor;
import com.ldtteam.blockout.util.keyboard.KeyboardKey;
import com.ldtteam.blockout.util.math.Vector2d;
import com.ldtteam.blockout.util.mouse.MouseButton;
import com.ldtteam.blockout.utils.controlconstruction.element.core.AbstractSimpleUIElement;
import com.ldtteam.jvoxelizer.client.gui.IGuiScreen;
import com.ldtteam.jvoxelizer.client.renderer.bufferbuilder.IBufferBuilder;
import com.ldtteam.jvoxelizer.client.renderer.font.IFontRenderer;
import com.ldtteam.jvoxelizer.client.renderer.opengl.IOpenGl;
import com.ldtteam.jvoxelizer.client.renderer.opengl.util.DestinationFactor;
import com.ldtteam.jvoxelizer.client.renderer.opengl.util.LogicOp;
import com.ldtteam.jvoxelizer.client.renderer.opengl.util.SourceFactor;
import com.ldtteam.jvoxelizer.client.renderer.opengl.util.vertexformat.IVertexFormat;
import com.ldtteam.jvoxelizer.client.renderer.tessellator.ITessellator;
import com.ldtteam.jvoxelizer.util.identifier.IIdentifier;
import com.ldtteam.jvoxelizer.util.math.MathHelper;
import java.util.EnumSet;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TextField
extends AbstractSimpleUIElement
implements IDrawableUIElement,
IClientSideClickAcceptingUIElement,
IClientSideKeyAcceptingUIElement {
    private int cursorPosition = 0;
    @NotNull
    public IDependencyObject<String> contents;
    private int selectionEnd = 0;
    @NotNull
    public IDependencyObject<Integer> maxStringLength = DependencyObjectHelper.createFromValue((Object)Integer.MAX_VALUE);
    @NotNull
    public IDependencyObject<Boolean> doBackgroundDrawing = DependencyObjectHelper.createFromValue((Object)true);
    @NotNull
    public Event<TextField, TextFieldChangedEventArgs> onTyped = new Event(TextField.class, TextFieldChangedEventArgs.class);
    @NotNull
    public Event<TextField, TextFieldEnterEventArgs> onEnter = new Event(TextField.class, TextFieldEnterEventArgs.class);
    @NotNull
    public IDependencyObject<String> outerBackgroundColor = DependencyObjectHelper.createFromValue((Object)"-6250336");
    @NotNull
    public IDependencyObject<String> innerBackgroundColor = DependencyObjectHelper.createFromValue((Object)"-16777216");
    @NotNull
    public IDependencyObject<String> enabledColor = DependencyObjectHelper.createFromValue((Object)"14737632");
    @NotNull
    public IDependencyObject<String> disabledColor = DependencyObjectHelper.createFromValue((Object)"7368816");
    @NotNull
    public IDependencyObject<String> cursorColor = DependencyObjectHelper.createFromValue((Object)"-3092272");
    @NotNull
    public IDependencyObject<String> selectionColor = DependencyObjectHelper.createFromValue((Object)"Blue");
    private int scrollOffset = -1;

    private TextField(@NotNull String id, @Nullable IUIElementHost parent, @NotNull IDependencyObject<IIdentifier> styleId, @NotNull IDependencyObject<EnumSet<Alignment>> alignments, @NotNull IDependencyObject<Dock> dock, @NotNull IDependencyObject<AxisDistance> margin, @NotNull IDependencyObject<Vector2d> elementSize, @NotNull IDependencyObject<Object> dataContext, @NotNull IDependencyObject<Boolean> visible, @NotNull IDependencyObject<Boolean> enabled, @NotNull IDependencyObject<String> contents, @NotNull IDependencyObject<Boolean> doBackgroundDrawing, @NotNull IDependencyObject<Integer> maxStringLength, @NotNull IDependencyObject<String> outerBackgroundColor, @NotNull IDependencyObject<String> innerBackgroundColor, @NotNull IDependencyObject<String> enabledColor, @NotNull IDependencyObject<String> disabledColor, @NotNull IDependencyObject<String> cursorColor, @NotNull IDependencyObject<String> selectionColor, int cursorPosition, int scrollOffset, int selectionEnd) {
        super(Constants.Controls.TextField.KEY_TEXT_FIELD, styleId, id, parent, alignments, dock, margin, elementSize, dataContext, visible, enabled);
        this.contents = contents;
        this.cursorPosition = cursorPosition;
        this.scrollOffset = scrollOffset;
        this.selectionEnd = selectionEnd;
        this.doBackgroundDrawing = doBackgroundDrawing;
        this.maxStringLength = maxStringLength;
        this.outerBackgroundColor = outerBackgroundColor;
        this.innerBackgroundColor = innerBackgroundColor;
        this.enabledColor = enabledColor;
        this.disabledColor = disabledColor;
        this.cursorColor = cursorColor;
        this.selectionColor = selectionColor;
    }

    public void update(@NotNull IUpdateManager updateManager) {
        super.update(updateManager);
        if (this.contents.hasChanged(this.getDataContext())) {
            updateManager.markDirty();
        }
        if (this.scrollOffset == -1) {
            this.calcScrollOffset();
        }
    }

    private void calcScrollOffset() {
        if (ProxyHolder.getInstance().getFontRenderer() == null) {
            return;
        }
        int internalWidth = this.getInternalWidth();
        if (internalWidth > 0) {
            if (this.scrollOffset > this.getContents().length()) {
                this.scrollOffset = this.getContents().length();
            }
            String visibleString = ProxyHolder.getInstance().getFontRenderer().trimStringToWidth(this.getContents().substring(this.scrollOffset), internalWidth);
            int rightmostVisibleChar = visibleString.length() + this.scrollOffset;
            if (this.selectionEnd == this.scrollOffset) {
                this.scrollOffset -= ProxyHolder.getInstance().getFontRenderer().trimStringToWidth(this.getContents(), internalWidth, true).length();
            }
            if (this.selectionEnd > rightmostVisibleChar) {
                this.scrollOffset += this.selectionEnd - rightmostVisibleChar;
            } else if (this.selectionEnd <= this.scrollOffset) {
                this.scrollOffset -= this.scrollOffset - this.selectionEnd;
            }
            this.scrollOffset = MathHelper.clamp((int)this.scrollOffset, (int)0, (int)this.getContents().length());
        }
    }

    public void drawBackground(@NotNull IRenderingController controller) {
        controller.getScissoringController().focus((IUIElement)this);
        this.doDraw(controller);
        controller.getScissoringController().pop();
    }

    public void doDraw(@NotNull IRenderingController controller) {
        IOpenGl.pushMatrix();
        IOpenGl.disableStandardItemLighting();
        IOpenGl.enableAlpha();
        IOpenGl.enableBlend();
        IOpenGl.blendFunc((SourceFactor)SourceFactor.SRC_ALPHA, (DestinationFactor)DestinationFactor.ONE_MINUS_SRC_ALPHA);
        boolean x = false;
        boolean y = false;
        int width = (int)this.getLocalBoundingBox().getSize().getX();
        int height = (int)this.getLocalBoundingBox().getSize().getY();
        String contents = this.getContents();
        IColor outerBackgroundColor = ColorUtils.convertToColor((String)this.getOuterBackgroundColor());
        IColor innerBackgroundColor = ColorUtils.convertToColor((String)this.getInnerBackgroundColor());
        IColor enabledColor = ColorUtils.convertToColor((String)this.getEnabledColor());
        IColor disabledColor = ColorUtils.convertToColor((String)this.getDisabledColor());
        IColor cursorColor = ColorUtils.convertToColor((String)this.getCursorColor());
        IColor selectionColor = ColorUtils.convertToColor((String)this.getSelectionColor());
        if (this.shouldDrawBackground()) {
            controller.drawRect(0.0, 0.0, (double)(0 + width), (double)(0 + height), outerBackgroundColor);
            controller.drawRect(1.0, 1.0, (double)(0 + width - 1), (double)(0 + height - 1), innerBackgroundColor);
        }
        IColor fontColor = this.isEnabled() ? enabledColor : disabledColor;
        int cursorScrollOffset = this.cursorPosition - this.scrollOffset;
        int selectScrollOffset = this.selectionEnd - this.scrollOffset;
        String visibleString = this.getFontRenderer().trimStringToWidth(contents.substring(this.scrollOffset), width);
        boolean cursorVisible = cursorScrollOffset >= 0 && cursorScrollOffset <= visibleString.length();
        boolean doDrawCursor = this.isFocused() && this.getCursorCounter() / 6L % 2L == 0L && cursorVisible;
        int drawStartX = this.shouldDrawBackground() ? 4 : 0;
        int drawStartY = this.shouldDrawBackground() ? 0 + (height - 8) / 2 : 0;
        int drawCurrentX = drawStartX;
        if (selectScrollOffset > visibleString.length()) {
            selectScrollOffset = visibleString.length();
        }
        if (!visibleString.isEmpty()) {
            String s1 = cursorVisible ? visibleString.substring(0, cursorScrollOffset) : visibleString;
            drawCurrentX = this.getFontRenderer().drawStringWithShadow(s1, (float)drawStartX, (float)drawStartY, fontColor.getRGB());
        }
        boolean drawFullCursor = this.cursorPosition < contents.length() || contents.length() >= this.getMaxStringLength();
        int cursorDrawX = drawCurrentX;
        if (!cursorVisible) {
            cursorDrawX = cursorScrollOffset > 0 ? drawStartX + width : drawStartX;
        } else if (drawFullCursor) {
            cursorDrawX = drawCurrentX - 1;
            --drawCurrentX;
        }
        if (!visibleString.isEmpty() && cursorVisible && cursorScrollOffset < visibleString.length()) {
            this.getFontRenderer().drawStringWithShadow(visibleString.substring(cursorScrollOffset), (float)drawCurrentX, (float)drawStartY, fontColor.getRGB());
        }
        if (doDrawCursor) {
            if (drawFullCursor) {
                controller.drawRect((double)cursorDrawX, (double)(drawStartY - 1), (double)(cursorDrawX + 1), (double)(drawStartY + 1 + this.getFontRenderer().getFontHeight()), cursorColor);
            } else {
                this.getFontRenderer().drawStringWithShadow("_", (float)cursorDrawX, (float)drawStartY, cursorColor.getRGB());
            }
        }
        if (selectScrollOffset != cursorScrollOffset) {
            int selectionDrawEnd = drawStartX + this.getFontRenderer().getStringWidth(visibleString.substring(0, selectScrollOffset));
            this.drawSelectionBox(0, width, cursorDrawX, drawStartY - 1, selectionDrawEnd - 1, drawStartY + 1 + this.getFontRenderer().getFontHeight(), selectionColor);
        }
        IOpenGl.disableBlend();
        IOpenGl.disableAlpha();
        IOpenGl.popMatrix();
    }

    public boolean shouldDrawBackground() {
        return (Boolean)this.doBackgroundDrawing.get((IDependencyReceiver)this);
    }

    public void drawForeground(@NotNull IRenderingController controller) {
    }

    private IFontRenderer getFontRenderer() {
        return ProxyHolder.getInstance().getFontRenderer();
    }

    private long getCursorCounter() {
        return ClientTickManager.getInstance().getTickCount();
    }

    public String getContents() {
        return (String)this.contents.get((IDependencyReceiver)this);
    }

    public void setContents(@NotNull String contents) {
        this.contents.set((IDependencyReceiver)this, (Object)contents);
        this.getParent().getUiManager().getUpdateManager().markDirty();
    }

    private int getInternalWidth() {
        return (int)this.getLocalBoundingBox().getSize().getX();
    }

    public void setCursorPosition(int pos) {
        this.cursorPosition = MathHelper.clamp((int)pos, (int)0, (int)this.getContents().length());
        this.setSelectionEnd(this.cursorPosition);
        this.getParent().getUiManager().getUpdateManager().markDirty();
    }

    public int getMaxStringLength() {
        return (Integer)this.maxStringLength.get((IDependencyReceiver)this);
    }

    public void setMaxStringLength(int length) {
        this.maxStringLength.set((IDependencyReceiver)this, (Object)length);
    }

    public String getOuterBackgroundColor() {
        return (String)this.outerBackgroundColor.get((IDependencyReceiver)this);
    }

    public void setOuterBackgroundColor(String value) {
        this.outerBackgroundColor.set((IDependencyReceiver)this, (Object)value);
    }

    public String getInnerBackgroundColor() {
        return (String)this.innerBackgroundColor.get((IDependencyReceiver)this);
    }

    public void setInnerBackgroundColor(String value) {
        this.innerBackgroundColor.set((IDependencyReceiver)this, (Object)value);
    }

    public String getEnabledColor() {
        return (String)this.enabledColor.get((IDependencyReceiver)this);
    }

    public void setEnabledColor(String value) {
        this.enabledColor.set((IDependencyReceiver)this, (Object)value);
    }

    public String getDisabledColor() {
        return (String)this.disabledColor.get((IDependencyReceiver)this);
    }

    public void setDisabledColor(String value) {
        this.disabledColor.set((IDependencyReceiver)this, (Object)value);
    }

    public String getCursorColor() {
        return (String)this.cursorColor.get((IDependencyReceiver)this);
    }

    public void setCursorColor(String value) {
        this.cursorColor.set((IDependencyReceiver)this, (Object)value);
    }

    public String getSelectionColor() {
        return (String)this.selectionColor.get((IDependencyReceiver)this);
    }

    public void setSelectionColor(String value) {
        this.selectionColor.set((IDependencyReceiver)this, (Object)value);
    }

    private void drawSelectionBox(int x, int width, int startX, int startY, int endX, int endY, IColor selectionColor) {
        if (startX < endX) {
            int i = startX;
            startX = endX;
            endX = i;
        }
        if (startY < endY) {
            int j = startY;
            startY = endY;
            endY = j;
        }
        if (endX > x + width) {
            endX = x + width;
        }
        if (startX > x + width) {
            startX = x + width;
        }
        ITessellator tessellator = ITessellator.getInstance();
        IBufferBuilder bufferbuilder = tessellator.getBuffer();
        selectionColor.performOpenGLColoring();
        IOpenGl.disableTexture2D();
        IOpenGl.enableColorLogic();
        IOpenGl.colorLogicOp((LogicOp)LogicOp.OR_REVERSE);
        bufferbuilder.begin(7, IVertexFormat.position());
        bufferbuilder.pos((double)startX, (double)endY, 0.0).endVertex();
        bufferbuilder.pos((double)endX, (double)endY, 0.0).endVertex();
        bufferbuilder.pos((double)endX, (double)startY, 0.0).endVertex();
        bufferbuilder.pos((double)startX, (double)startY, 0.0).endVertex();
        tessellator.draw();
        IOpenGl.disableColorLogic();
        IOpenGl.enableTexture2D();
    }

    public void setShouldDrawBackground(boolean drawBackground) {
        this.doBackgroundDrawing.set((IDependencyReceiver)this, (Object)drawBackground);
    }

    private void writeText(String str) {
        int insertedLength;
        IFontRenderer fontRenderer = ProxyHolder.getInstance().getFontRenderer();
        int maxTextLength = (int)(this.getLocalBoundingBox().getSize().getX() * (double)((int)(this.getLocalBoundingBox().getSize().getY() / (double)ProxyHolder.getInstance().getFontRenderer().getFontHeight())));
        int insertAt = Math.min(this.cursorPosition, this.selectionEnd);
        int insertEnd = Math.max(this.cursorPosition, this.selectionEnd);
        int availableChars = maxTextLength - fontRenderer.getStringWidth(this.getContents()) + (insertEnd - insertAt);
        if (availableChars < 0) {
            return;
        }
        StringBuilder resultBuffer = new StringBuilder();
        if (this.getContents().length() > 0 && insertAt > 0) {
            resultBuffer.append(this.getContents(), 0, insertAt);
        }
        if (availableChars < str.length()) {
            resultBuffer.append(str, 0, availableChars);
            insertedLength = availableChars;
        } else {
            resultBuffer.append(str);
            insertedLength = str.length();
        }
        if (this.getContents().length() > 0 && insertEnd < this.getContents().length()) {
            resultBuffer.append(this.getContents().substring(insertEnd));
        }
        NetworkManager.sendToServer(new TextFieldUpdateContentsMessage(this.getId(), resultBuffer.toString()));
        int newCursorPos = this.selectionEnd + (insertAt - this.selectionEnd) + insertedLength;
        NetworkManager.sendToServer(new TextFieldUpdateSelectionEndOrCursorPositionMessage(this.getId(), newCursorPos, newCursorPos));
    }

    private void deleteWords(int count) {
        if (this.getContents().length() != 0) {
            if (this.selectionEnd != this.cursorPosition) {
                this.writeText("");
            } else {
                this.deleteFromCursor(this.getNthWordFromCursor(count) - this.cursorPosition);
            }
        }
    }

    private void deleteFromCursor(int count) {
        if (this.getContents().length() == 0) {
            return;
        }
        if (this.selectionEnd != this.cursorPosition) {
            this.writeText("");
        } else {
            boolean backwards = count < 0;
            int start = backwards ? this.cursorPosition + count : this.cursorPosition;
            int end = backwards ? this.cursorPosition : this.cursorPosition + count;
            String result = "";
            if (start > 0) {
                result = this.getContents().substring(0, start);
            }
            if (end < this.getContents().length()) {
                result = result + this.getContents().substring(end);
            }
            NetworkManager.sendToServer(new TextFieldUpdateContentsMessage(this.getId(), result));
            if (backwards) {
                NetworkManager.sendToServer(new TextFieldUpdateSelectionEndOrCursorPositionMessage(this.getId(), this.selectionEnd + count, this.selectionEnd + count));
            }
        }
    }

    private int getNthWordFromPos(int count, int pos) {
        boolean reverse = count < 0;
        int position = pos;
        for (int i1 = 0; i1 < Math.abs(count); ++i1) {
            if (reverse) {
                while (position > 0 && this.getContents().charAt(position - 1) == ' ') {
                    --position;
                }
                while (position > 0 && this.getContents().charAt(position - 1) != ' ') {
                    --position;
                }
                continue;
            }
            position = this.getContents().indexOf(32, position);
            if (position == -1) {
                position = this.getContents().length();
                continue;
            }
            while (position < this.getContents().length() && this.getContents().charAt(position) == ' ') {
                ++position;
            }
        }
        return position;
    }

    private int getNthWordFromCursor(int count) {
        return this.getNthWordFromPos(count, this.cursorPosition);
    }

    private int getSelectionEnd() {
        return this.selectionEnd;
    }

    public void setSelectionEnd(int pos) {
        this.selectionEnd = pos;
    }

    @NotNull
    private String getSelectedText() {
        int start = Math.min(this.cursorPosition, this.selectionEnd);
        int end = Math.max(this.cursorPosition, this.selectionEnd);
        return this.getContents().substring(start, end);
    }

    private void handleKey(char c, KeyboardKey key) {
        switch (key) {
            case KEY_LSHIFT: 
            case KEY_RSHIFT: 
            case KEY_LCONTROL: 
            case KEY_RCONTROL: {
                break;
            }
            case KEY_BACK: 
            case KEY_DELETE: {
                this.handleDelete(key);
                break;
            }
            case KEY_HOME: 
            case KEY_END: {
                this.handleHomeEnd(key);
                break;
            }
            case KEY_LEFT: 
            case KEY_RIGHT: {
                this.handleArrowKeys(key);
                break;
            }
            case KEY_TAB: {
                this.handleTab();
                break;
            }
            case KEY_RETURN: {
                NetworkManager.sendToServer(new TextFieldOnEnterPressed(this.getId()));
                break;
            }
            default: {
                this.writeText(Character.toString(c));
            }
        }
    }

    private void handleTab() {
        Optional optionalNextElement = this.getParent().getNextElement((IUIElement)this, iUiElement -> iUiElement instanceof IClientSideKeyAcceptingUIElement || iUiElement instanceof IKeyAcceptingUIElement);
        optionalNextElement.filter(element -> element != this).ifPresent(element -> NetworkManager.sendToServer(new TextFieldTabPressedMessage(element.getId())));
    }

    private void handleArrowKeys(KeyboardKey key) {
        int direction;
        int n = direction = key == KeyboardKey.KEY_LEFT ? -1 : 1;
        if (IGuiScreen.isShiftKeyDown()) {
            if (IGuiScreen.isCtrlKeyDown()) {
                NetworkManager.sendToServer(new TextFieldUpdateSelectionEndOrCursorPositionMessage(this.getId(), this.getNthWordFromCursor(direction), this.getSelectionEnd()));
            } else {
                NetworkManager.sendToServer(new TextFieldUpdateSelectionEndOrCursorPositionMessage(this.getId(), this.cursorPosition + direction, this.getSelectionEnd()));
            }
        } else if (IGuiScreen.isCtrlKeyDown()) {
            NetworkManager.sendToServer(new TextFieldUpdateSelectionEndOrCursorPositionMessage(this.getId(), this.getNthWordFromCursor(direction), this.getNthWordFromCursor(direction)));
        } else {
            NetworkManager.sendToServer(new TextFieldUpdateSelectionEndOrCursorPositionMessage(this.getId(), this.cursorPosition + direction, this.cursorPosition + direction));
        }
    }

    private void handleHomeEnd(KeyboardKey key) {
        int position;
        int n = position = key == KeyboardKey.KEY_HOME ? 0 : this.getContents().length();
        if (IGuiScreen.isShiftKeyDown()) {
            NetworkManager.sendToServer(new TextFieldUpdateSelectionEndOrCursorPositionMessage(this.getId(), position, this.getSelectionEnd()));
        } else {
            NetworkManager.sendToServer(new TextFieldUpdateSelectionEndOrCursorPositionMessage(this.getId(), position, position));
        }
    }

    private void handleDelete(KeyboardKey key) {
        int direction;
        int n = direction = key == KeyboardKey.KEY_BACK ? -1 : 1;
        if (IGuiScreen.isCtrlKeyDown()) {
            this.deleteWords(direction);
        } else {
            this.deleteFromCursor(direction);
        }
    }

    public boolean canAcceptMouseInputClient(int localX, int localY, MouseButton button) {
        return true;
    }

    public boolean onMouseClickBeginClient(int localX, int localY, MouseButton button) {
        if (localX < 0) {
            return true;
        }
        String visibleString = ProxyHolder.getInstance().getFontRenderer().trimStringToWidth(this.getContents().substring(this.scrollOffset), this.getInternalWidth());
        String trimmedString = ProxyHolder.getInstance().getFontRenderer().trimStringToWidth(visibleString, localX);
        NetworkManager.sendToServer(new TextFieldUpdateSelectionEndOrCursorPositionMessage(this.getId(), trimmedString.length() + this.scrollOffset, this.selectionEnd));
        return true;
    }

    public boolean onMouseClickMoveClient(int localX, int localY, MouseButton button, float timeElapsed) {
        String visibleString = ProxyHolder.getInstance().getFontRenderer().trimStringToWidth(this.getContents().substring(this.scrollOffset), this.getInternalWidth());
        String trimmedString = ProxyHolder.getInstance().getFontRenderer().trimStringToWidth(visibleString, localX);
        NetworkManager.sendToServer(new TextFieldUpdateSelectionEndOrCursorPositionMessage(this.getId(), this.cursorPosition, trimmedString.length() + this.scrollOffset));
        return true;
    }

    public boolean canAcceptKeyInputClient(int character, KeyboardKey key) {
        return true;
    }

    public boolean onKeyPressedClient(int character, KeyboardKey key) {
        switch (character) {
            case 1: {
                NetworkManager.sendToServer(new TextFieldUpdateSelectionEndOrCursorPositionMessage(this.getId(), this.getContents().length(), 0));
                break;
            }
            case 3: {
                IGuiScreen.setClipboardString((String)this.getSelectedText());
                break;
            }
            case 22: {
                this.writeText(IGuiScreen.getClipboardString());
                break;
            }
            case 24: {
                IGuiScreen.setClipboardString((String)this.getSelectedText());
                this.writeText("");
                break;
            }
            default: {
                this.handleKey((char)character, key);
            }
        }
        return true;
    }

    public void raiseOnContentChanged() {
        this.onTyped.raise((Object)this, (Object)new TextFieldChangedEventArgs(this.getContents()));
    }

    public void raiseOnEnterPressed() {
        this.onEnter.raise((Object)this, (Object)new TextFieldEnterEventArgs(this.getContents()));
    }

    public static class TextFieldEnterEventArgs {
        private final String newContent;

        public TextFieldEnterEventArgs(String newContent) {
            this.newContent = newContent;
        }

        public String getNewContent() {
            return this.newContent;
        }
    }

    public static class TextFieldChangedEventArgs {
        private final String newContent;

        public TextFieldChangedEventArgs(String newContent) {
            this.newContent = newContent;
        }

        public String getNewContent() {
            return this.newContent;
        }
    }

    public static class Factory
    extends AbstractSimpleUIElement.AbstractSimpleUIElementFactory<TextField> {
        public Factory() {
            super(TextField.class, Constants.Controls.TextField.KEY_TEXT_FIELD, (elementData, engine, id, parent, styleId, alignments, dock, margin, elementSize, dataContext, visible, enabled) -> {
                IDependencyObject contents = elementData.getFromRawDataWithDefault("content", engine, (Object)"", String.class, new Object[0]);
                IDependencyObject doBackgroundDraw = elementData.getFromRawDataWithDefault("doBackgroundDraw", engine, (Object)true, Boolean.class, new Object[0]);
                IDependencyObject maxContentLenght = elementData.getFromRawDataWithDefault("maxLength", engine, (Object)Integer.MAX_VALUE, Integer.class, new Object[0]);
                IDependencyObject outerBackgroundColor = elementData.getFromRawDataWithDefault("outerColor", engine, (Object)"-6250336", String.class, new Object[0]);
                IDependencyObject innerBackgroundColor = elementData.getFromRawDataWithDefault("innerColor", engine, (Object)"-16777216", String.class, new Object[0]);
                IDependencyObject enabledFontColor = elementData.getFromRawDataWithDefault("enabledFontColor", engine, (Object)"14737632", String.class, new Object[0]);
                IDependencyObject disabledFontColor = elementData.getFromRawDataWithDefault("disabledFontColor", engine, (Object)"7368816", String.class, new Object[0]);
                IDependencyObject cursorColor = elementData.getFromRawDataWithDefault("cursorColor", engine, (Object)"-3092272", String.class, new Object[0]);
                IDependencyObject selectionColor = elementData.getFromRawDataWithDefault("selectionColor", engine, (Object)"Blue", String.class, new Object[0]);
                int cursorPosition = (Integer)elementData.getRawWithoutBinding("cursorCounter", (Object)0, Integer.class, new Object[0]);
                int scrollOffset = (Integer)elementData.getRawWithoutBinding("cursorScroll", (Object)0, Integer.class, new Object[0]);
                int selectionEnd = (Integer)elementData.getRawWithoutBinding("cursor_SEL", (Object)0, Integer.class, new Object[0]);
                TextField element = new TextField(id, parent, styleId, alignments, dock, margin, elementSize, dataContext, visible, enabled, contents, doBackgroundDraw, maxContentLenght, outerBackgroundColor, innerBackgroundColor, enabledFontColor, disabledFontColor, cursorColor, selectionColor, cursorPosition, scrollOffset, selectionEnd);
                return element;
            }, (element, builder) -> builder.addComponent("content", (Object)element.getContents(), String.class).addComponent("cursorCounter", (Object)((TextField)element).cursorPosition, Integer.class).addComponent("cursorScroll", (Object)((TextField)element).scrollOffset, Integer.class).addComponent("cursor_SEL", (Object)((TextField)element).selectionEnd, Integer.class).addComponent("doBackgroundDraw", (Object)element.shouldDrawBackground(), Boolean.class).addComponent("maxLength", (Object)element.getMaxStringLength(), Integer.class).addComponent("outerColor", (Object)element.getOuterBackgroundColor(), String.class).addComponent("innerColor", (Object)element.getInnerBackgroundColor(), String.class).addComponent("enabledFontColor", (Object)element.getEnabledColor(), String.class).addComponent("disabledFontColor", (Object)element.getDisabledColor(), String.class).addComponent("cursorColor", (Object)element.getCursorColor(), String.class).addComponent("selectionColor", (Object)element.getSelectionColor(), String.class));
        }
    }

    public static class TextFieldConstructionDataBuilder
    extends AbstractSimpleUIElement.SimpleControlConstructionDataBuilder<TextFieldConstructionDataBuilder, TextField> {
        public TextFieldConstructionDataBuilder(String controlId, IBlockOutGuiConstructionDataBuilder data) {
            super(controlId, data, TextField.class);
        }

        @NotNull
        public TextFieldConstructionDataBuilder withDependentContents(@NotNull IDependencyObject<String> contents) {
            return (TextFieldConstructionDataBuilder)this.withDependency("contents", contents);
        }

        @NotNull
        public TextFieldConstructionDataBuilder withChangedEventHandler(@NotNull IEventHandler<TextField, TextFieldChangedEventArgs> eventHandler) {
            return (TextFieldConstructionDataBuilder)this.withEventHandler("onChanged", TextFieldChangedEventArgs.class, eventHandler);
        }

        @NotNull
        public TextFieldConstructionDataBuilder withEnterEventHandler(@NotNull IEventHandler<TextField, TextFieldEnterEventArgs> eventHandler) {
            return (TextFieldConstructionDataBuilder)this.withEventHandler("onEnter", TextFieldEnterEventArgs.class, eventHandler);
        }
    }
}

