/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.blockout.element.simple;

import com.ldtteam.blockout.binding.dependency.DependencyObjectHelper;
import com.ldtteam.blockout.binding.dependency.IDependencyObject;
import com.ldtteam.blockout.binding.dependency.IDependencyReceiver;
import com.ldtteam.blockout.builder.core.builder.IBlockOutGuiConstructionDataBuilder;
import com.ldtteam.blockout.element.IUIElement;
import com.ldtteam.blockout.element.IUIElementHost;
import com.ldtteam.blockout.element.drawable.IDrawableUIElement;
import com.ldtteam.blockout.element.values.Alignment;
import com.ldtteam.blockout.element.values.AxisDistance;
import com.ldtteam.blockout.element.values.Dock;
import com.ldtteam.blockout.management.update.IUpdateManager;
import com.ldtteam.blockout.render.core.IRenderingController;
import com.ldtteam.blockout.style.resources.ImageResource;
import com.ldtteam.blockout.util.Constants;
import com.ldtteam.blockout.util.math.Vector2d;
import com.ldtteam.blockout.utils.controlconstruction.element.core.AbstractSimpleUIElement;
import com.ldtteam.jvoxelizer.client.renderer.opengl.IOpenGl;
import com.ldtteam.jvoxelizer.util.identifier.IIdentifier;
import java.util.EnumSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Slot
extends AbstractSimpleUIElement
implements IDrawableUIElement {
    @NotNull
    public IDependencyObject<IIdentifier> inventoryId;
    @NotNull
    public IDependencyObject<Integer> inventoryIndex;
    @NotNull
    public IDependencyObject<IIdentifier> backgroundImageResource;
    @NotNull
    private int slotIndex;

    public Slot(@NotNull String id, @Nullable IUIElementHost parent, @NotNull IDependencyObject<IIdentifier> styleId, @NotNull IDependencyObject<EnumSet<Alignment>> alignments, @NotNull IDependencyObject<Dock> dock, @NotNull IDependencyObject<AxisDistance> margin, @NotNull IDependencyObject<Vector2d> elementSize, @NotNull IDependencyObject<Object> dataContext, @NotNull IDependencyObject<Boolean> visible, @NotNull IDependencyObject<Boolean> enabled, @NotNull IDependencyObject<IIdentifier> inventoryId, @NotNull IDependencyObject<Integer> inventoryIndex, @NotNull IDependencyObject<IIdentifier> backgroundImageResource) {
        super(Constants.Controls.Slot.KEY_SLOT, styleId, id, parent, alignments, dock, margin, elementSize, dataContext, visible, enabled);
        this.inventoryId = inventoryId;
        this.inventoryIndex = inventoryIndex;
        this.backgroundImageResource = backgroundImageResource;
    }

    public void update(@NotNull IUpdateManager updateManager) {
        super.update(updateManager);
        if (this.inventoryId.hasChanged(this.getDataContext())) {
            updateManager.markDirty();
        }
        if (this.inventoryIndex.hasChanged(this.getDataContext())) {
            updateManager.markDirty();
        }
        if (this.backgroundImageResource.hasChanged(this.getDataContext())) {
            updateManager.markDirty();
        }
    }

    public void drawBackground(@NotNull IRenderingController controller) {
        Vector2d size = this.getLocalBoundingBox().getSize();
        ImageResource resource = this.getBackgroundImage();
        Vector2d scalingFactor = resource.getScalingFactor(size);
        IOpenGl.pushMatrix();
        IOpenGl.scale((double)scalingFactor.getX(), (double)scalingFactor.getY(), (double)1.0);
        IOpenGl.disableLighting();
        IOpenGl.disableDepth();
        IOpenGl.disableAlpha();
        IOpenGl.enableBlend();
        controller.bindTexture(resource.getDiskLocation());
        controller.drawTexturedModalRect(new Vector2d(), size, resource.getOffset(), resource.getSize(), resource.getFileSize());
        IOpenGl.disableBlend();
        IOpenGl.enableAlpha();
        IOpenGl.enableLighting();
        IOpenGl.enableDepth();
        IOpenGl.popMatrix();
        controller.drawSlotContent((IUIElement)this);
        controller.drawSlotMouseOverlay((IUIElement)this);
    }

    public void drawForeground(@NotNull IRenderingController controller) {
    }

    @NotNull
    public ImageResource getBackgroundImage() {
        return (ImageResource)this.getResource(this.getBackgroundImageResource());
    }

    @NotNull
    public IIdentifier getBackgroundImageResource() {
        return (IIdentifier)this.backgroundImageResource.get((IDependencyReceiver)this);
    }

    void setBackgroundImageResource(@NotNull IIdentifier location) {
        this.backgroundImageResource.set((IDependencyReceiver)this, (Object)location);
    }

    @NotNull
    public IIdentifier getInventoryId() {
        return (IIdentifier)this.inventoryId.get((IDependencyReceiver)this);
    }

    void setInventoryId(@NotNull IIdentifier inventoryId) {
        this.inventoryId.set((IDependencyReceiver)this, (Object)inventoryId);
    }

    @NotNull
    public Integer getInventoryIndex() {
        return (Integer)this.inventoryIndex.get((IDependencyReceiver)this);
    }

    void setInventoryIndex(@NotNull Integer index) {
        this.inventoryIndex.set((IDependencyReceiver)this, (Object)index);
    }

    @NotNull
    public int getSlotIndex() {
        return this.slotIndex;
    }

    public void setSlotIndex(@NotNull int slotIndex) {
        this.slotIndex = slotIndex;
    }

    public static class Factory
    extends AbstractSimpleUIElement.AbstractSimpleUIElementFactory<Slot> {
        public Factory() {
            super(Slot.class, Constants.Controls.Slot.KEY_SLOT, (elementData, engine, id, parent, styleId, alignments, dock, margin, elementSize, dataContext, visible, enabled) -> {
                IDependencyObject inventoryId = elementData.getFromRawDataWithDefault("inventory", engine, (Object)IIdentifier.create((String)"minecraft:missingno"), IIdentifier.class, new Object[0]);
                IDependencyObject inventoryIndex = elementData.getFromRawDataWithDefault("index", engine, (Object)-1, Integer.class, new Object[0]);
                IDependencyObject icon = elementData.getFromRawDataWithDefault("background", engine, (Object)IIdentifier.create((String)"minecraft:missingno"), IIdentifier.class, new Object[0]);
                Slot element = new Slot(id, parent, (IDependencyObject<IIdentifier>)styleId, (IDependencyObject<EnumSet<Alignment>>)alignments, (IDependencyObject<Dock>)dock, (IDependencyObject<AxisDistance>)margin, (IDependencyObject<Vector2d>)elementSize, (IDependencyObject<Object>)dataContext, (IDependencyObject<Boolean>)visible, (IDependencyObject<Boolean>)enabled, (IDependencyObject<IIdentifier>)inventoryId, (IDependencyObject<Integer>)inventoryIndex, (IDependencyObject<IIdentifier>)icon);
                return element;
            }, (element, builder) -> builder.addComponent("background", (Object)element.getBackgroundImageResource(), IIdentifier.class).addComponent("inventory", (Object)element.getInventoryId(), IIdentifier.class).addComponent("index", (Object)element.getInventoryIndex(), Integer.class));
        }
    }

    public static final class SlotConstructionDataBuilder
    extends AbstractSimpleUIElement.SimpleControlConstructionDataBuilder<SlotConstructionDataBuilder, Slot> {
        public SlotConstructionDataBuilder(String controlId, IBlockOutGuiConstructionDataBuilder data, Class<Slot> controlClass) {
            super(controlId, data, controlClass);
        }

        public SlotConstructionDataBuilder withDependentInventoryId(@NotNull IDependencyObject<IIdentifier> inventoryId) {
            return (SlotConstructionDataBuilder)this.withDependency("inventoryId", inventoryId);
        }

        public SlotConstructionDataBuilder withInventoryId(@NotNull IIdentifier inventoryId) {
            return (SlotConstructionDataBuilder)this.withDependency("inventoryId", DependencyObjectHelper.createFromValue((Object)inventoryId));
        }

        public SlotConstructionDataBuilder withDependentInventoryIndex(@NotNull IDependencyObject<Integer> inventoryIndex) {
            return (SlotConstructionDataBuilder)this.withDependency("inventoryIndex", inventoryIndex);
        }

        public SlotConstructionDataBuilder withInventoryIndex(@NotNull Integer inventoryIndex) {
            return (SlotConstructionDataBuilder)this.withDependency("inventoryIndex", DependencyObjectHelper.createFromValue((Object)inventoryIndex));
        }

        public SlotConstructionDataBuilder withDependentBackgroundImageResource(@NotNull IDependencyObject<IIdentifier> backgroundImageResource) {
            return (SlotConstructionDataBuilder)this.withDependency("backgroundImageResource", backgroundImageResource);
        }

        public SlotConstructionDataBuilder withBackgroundImageResource(@NotNull IIdentifier backgroundImageResource) {
            return (SlotConstructionDataBuilder)this.withDependency("backgroundImageResource", DependencyObjectHelper.createFromValue((Object)backgroundImageResource));
        }
    }
}

