/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.blockout.element.simple;

import com.ldtteam.blockout.binding.dependency.IDependencyObject;
import com.ldtteam.blockout.binding.dependency.IDependencyReceiver;
import com.ldtteam.blockout.element.IUIElementHost;
import com.ldtteam.blockout.element.drawable.IDrawableUIElement;
import com.ldtteam.blockout.element.input.IClickAcceptingUIElement;
import com.ldtteam.blockout.element.values.Alignment;
import com.ldtteam.blockout.element.values.AxisDistance;
import com.ldtteam.blockout.element.values.Dock;
import com.ldtteam.blockout.event.Event;
import com.ldtteam.blockout.management.update.IUpdateManager;
import com.ldtteam.blockout.render.core.IRenderingController;
import com.ldtteam.blockout.style.resources.ImageResource;
import com.ldtteam.blockout.util.Constants;
import com.ldtteam.blockout.util.math.Vector2d;
import com.ldtteam.blockout.util.mouse.MouseButton;
import com.ldtteam.blockout.utils.controlconstruction.element.core.AbstractSimpleUIElement;
import com.ldtteam.jvoxelizer.client.renderer.opengl.IOpenGl;
import com.ldtteam.jvoxelizer.client.renderer.opengl.util.DestinationFactor;
import com.ldtteam.jvoxelizer.client.renderer.opengl.util.SourceFactor;
import com.ldtteam.jvoxelizer.util.identifier.IIdentifier;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import org.jetbrains.annotations.NotNull;

public class RangeSelector
extends AbstractSimpleUIElement
implements IClickAcceptingUIElement,
IDrawableUIElement {
    private static final int CONST_SELECTOR_SIZE = 5;
    @NotNull
    public IDependencyObject<Float> leftValue;
    @NotNull
    public IDependencyObject<Float> rightValue;
    @NotNull
    public IDependencyObject<IIdentifier> leftBackgroundTexture;
    @NotNull
    public IDependencyObject<IIdentifier> selectedRegionBackgroundTexture;
    @NotNull
    public IDependencyObject<IIdentifier> rightBackgroundTexture;
    @NotNull
    public IDependencyObject<IIdentifier> leftSelectorTexture;
    @NotNull
    public IDependencyObject<IIdentifier> rightSelectorTexture;
    @NotNull
    public Event<RangeSelector, RangeChangedEventArgs> onValuesChanged = new Event(RangeSelector.class, RangeChangedEventArgs.class);
    @NotNull
    private Optional<MovementType> currentMovementType = Optional.empty();
    @NotNull
    private int lastClickX = -1;

    public RangeSelector(@NotNull String id, @NotNull IUIElementHost parent, @NotNull IDependencyObject<IIdentifier> style, @NotNull IDependencyObject<EnumSet<Alignment>> alignments, @NotNull IDependencyObject<Dock> dock, @NotNull IDependencyObject<AxisDistance> margin, @NotNull IDependencyObject<Vector2d> elementSize, @NotNull IDependencyObject<Object> dataContext, @NotNull IDependencyObject<Boolean> visible, @NotNull IDependencyObject<Boolean> enabled, @NotNull IDependencyObject<Float> leftValue, @NotNull IDependencyObject<Float> rightValue, @NotNull IDependencyObject<IIdentifier> leftBackgroundTexture, @NotNull IDependencyObject<IIdentifier> selectedRegionBackgroundTexture, @NotNull IDependencyObject<IIdentifier> rightBackgroundTexture, @NotNull IDependencyObject<IIdentifier> leftSelectorTexture, @NotNull IDependencyObject<IIdentifier> rightSelectorTexture) {
        super(Constants.Controls.RangeSelector.KEY_RANGE_SELECTOR, style, id, parent, alignments, dock, margin, elementSize, dataContext, visible, enabled);
        this.leftValue = leftValue;
        this.rightValue = rightValue;
        this.leftBackgroundTexture = leftBackgroundTexture;
        this.selectedRegionBackgroundTexture = selectedRegionBackgroundTexture;
        this.rightBackgroundTexture = rightBackgroundTexture;
        this.leftSelectorTexture = leftSelectorTexture;
        this.rightSelectorTexture = rightSelectorTexture;
    }

    public void update(@NotNull IUpdateManager updateManager) {
        super.update(updateManager);
        if (this.leftValue.hasChanged((IDependencyReceiver)this)) {
            updateManager.markDirty();
        }
        if (this.rightValue.hasChanged((IDependencyReceiver)this)) {
            updateManager.markDirty();
        }
        if (this.leftBackgroundTexture.hasChanged((IDependencyReceiver)this)) {
            updateManager.markDirty();
        }
        if (this.selectedRegionBackgroundTexture.hasChanged((IDependencyReceiver)this)) {
            updateManager.markDirty();
        }
        if (this.rightBackgroundTexture.hasChanged((IDependencyReceiver)this)) {
            updateManager.markDirty();
        }
        if (this.leftSelectorTexture.hasChanged((IDependencyReceiver)this)) {
            updateManager.markDirty();
        }
        if (this.rightSelectorTexture.hasChanged((IDependencyReceiver)this)) {
            updateManager.markDirty();
        }
    }

    public boolean canAcceptMouseInput(int localX, int localY, MouseButton button) {
        return true;
    }

    public void onMouseClickEnd(int localX, int localY, MouseButton button) {
        this.onMouseLeave();
    }

    public void onMouseClickMove(int localX, int localY, MouseButton button, float timeElapsed) {
        MovementType movementType = this.currentMovementType.orElseGet(() -> Arrays.stream(MovementType.values()).filter(t -> t.ShouldSelect(this, localX)).findFirst().orElseThrow(() -> new IllegalStateException("MovementType did not find any possible candidate")));
        this.currentMovementType = Optional.of(movementType);
        float value = this.convertXPositionToValue(localX);
        if (!movementType.IsValid(this, value)) {
            this.lastClickX = localX;
            return;
        }
        movementType.set(this, value);
        this.lastClickX = localX;
        this.getParent().getUiManager().getUpdateManager().markDirty();
    }

    public void onMouseLeave() {
        this.currentMovementType = Optional.empty();
        this.lastClickX = -1;
    }

    public float convertXPositionToValue(int x) {
        double width = this.getLocalBoundingBox().getSize().getX();
        if (x < 5) {
            return 0.0f;
        }
        if ((double)x > width - 5.0) {
            return 1.0f;
        }
        double v = (double)(x - 5) / (width - 10.0);
        return (float)v;
    }

    public void drawBackground(@NotNull IRenderingController controller) {
        IOpenGl.pushMatrix();
        IOpenGl.disableStandardItemLighting();
        IOpenGl.enableAlpha();
        IOpenGl.enableBlend();
        IOpenGl.blendFunc((SourceFactor)SourceFactor.ONE_MINUS_SRC_ALPHA, (DestinationFactor)DestinationFactor.DST_ALPHA);
        ImageResource leftBackgroundResource = this.getLeftBackgroundTextureResource();
        ImageResource selectorRegionBackgroundResource = this.getSelectedRegionBackgroundTextureResource();
        ImageResource rightBackgroundResource = this.getRightBackgroundTextureResource();
        ImageResource leftSelectorResource = this.getLeftSelectorTextureResource();
        ImageResource rightSelectorResource = this.getRightSelectorTextureResource();
        double height = this.getLocalBoundingBox().getSize().getY();
        Vector2d leftBackgroundOffset = new Vector2d();
        Vector2d leftBackgroundSize = new Vector2d((double)(this.getLeftSelectorOffset() - 5.0f), height).nullifyNegatives();
        this.drawImageResource(controller, leftBackgroundResource, leftBackgroundOffset, leftBackgroundSize);
        Vector2d leftSelectorOffset = leftBackgroundOffset.move(leftBackgroundSize.getX(), 0.0);
        Vector2d leftSelectorSize = new Vector2d(5.0, height).nullifyNegatives();
        this.drawImageResource(controller, leftSelectorResource, leftSelectorOffset, leftSelectorSize);
        Vector2d selectedRegionOffset = leftSelectorOffset.move(leftSelectorSize.getX(), 0.0);
        Vector2d selectedRegionSize = new Vector2d((double)(this.getRightSelectorOffset() - this.getLeftSelectorOffset()), height).nullifyNegatives();
        this.drawImageResource(controller, selectorRegionBackgroundResource, selectedRegionOffset, selectedRegionSize);
        Vector2d rightSelectorOffset = selectedRegionOffset.move(selectedRegionSize.getX(), 0.0);
        Vector2d rightSelectorSize = new Vector2d(5.0, height).nullifyNegatives();
        this.drawImageResource(controller, rightSelectorResource, rightSelectorOffset, rightSelectorSize);
        Vector2d rightBackgroundOffset = rightSelectorOffset.move(rightSelectorSize.getX(), 0.0);
        Vector2d rightBackgroundSize = new Vector2d(this.getLocalBoundingBox().getSize().getX() - rightBackgroundOffset.getX(), height).nullifyNegatives();
        this.drawImageResource(controller, rightBackgroundResource, rightBackgroundOffset, rightBackgroundSize);
        IOpenGl.popMatrix();
    }

    public ImageResource getLeftBackgroundTextureResource() {
        return (ImageResource)this.getResource(this.getLeftBackgroundTexture());
    }

    public float getLeftValue() {
        return ((Float)this.leftValue.get((IDependencyReceiver)this)).floatValue();
    }

    public ImageResource getSelectedRegionBackgroundTextureResource() {
        return (ImageResource)this.getResource(this.getSelectedRegionBackgroundTexture());
    }

    public void setLeftValue(float value) {
        float previous = this.getLeftValue();
        if (previous == value) {
            return;
        }
        this.leftValue.set((IDependencyReceiver)this, (Object)Float.valueOf(value));
        this.onValuesChanged.raise((Object)this, (Object)new RangeChangedEventArgs(previous, this.getRightValue(), value, this.getRightValue()));
    }

    public ImageResource getRightBackgroundTextureResource() {
        return (ImageResource)this.getResource(this.getRightBackgroundTexture());
    }

    public float getRightValue() {
        return ((Float)this.rightValue.get((IDependencyReceiver)this)).floatValue();
    }

    public ImageResource getLeftSelectorTextureResource() {
        return (ImageResource)this.getResource(this.getLeftSelectorTexture());
    }

    public void setRightValue(float value) {
        float previous = this.getRightValue();
        if (previous == value) {
            return;
        }
        this.rightValue.set((IDependencyReceiver)this, (Object)Float.valueOf(value));
        this.onValuesChanged.raise((Object)this, (Object)new RangeChangedEventArgs(this.getLeftValue(), previous, this.getLeftValue(), value));
    }

    public ImageResource getRightSelectorTextureResource() {
        return (ImageResource)this.getResource(this.getRightSelectorTexture());
    }

    public float getLeftSelectorOffset() {
        return 5.0f + (float)(this.getLocalBoundingBox().getSize().getX() - 10.0) * this.getLeftValue();
    }

    private void drawImageResource(@NotNull IRenderingController controller, @NotNull ImageResource resource, @NotNull Vector2d offset, @NotNull Vector2d size) {
        controller.bindTexture(resource.getDiskLocation());
        controller.drawTexturedModalRect(offset, size, resource.getOffset(), resource.getSize(), resource.getFileSize());
    }

    public float getRightSelectorOffset() {
        return 5.0f + (float)(this.getLocalBoundingBox().getSize().getX() - 10.0) * this.getRightValue();
    }

    public IIdentifier getLeftBackgroundTexture() {
        return (IIdentifier)this.leftBackgroundTexture.get((IDependencyReceiver)this);
    }

    public void setLeftBackgroundTexture(@NotNull IIdentifier leftBackgroundTexture) {
        this.leftBackgroundTexture.set((IDependencyReceiver)this, (Object)leftBackgroundTexture);
    }

    public IIdentifier getSelectedRegionBackgroundTexture() {
        return (IIdentifier)this.selectedRegionBackgroundTexture.get((IDependencyReceiver)this);
    }

    public void setSelectedRegionBackgroundTexture(@NotNull IIdentifier selectedRegionBackgroundTexture) {
        this.selectedRegionBackgroundTexture.set((IDependencyReceiver)this, (Object)selectedRegionBackgroundTexture);
    }

    public IIdentifier getRightBackgroundTexture() {
        return (IIdentifier)this.rightBackgroundTexture.get((IDependencyReceiver)this);
    }

    public void setRightBackgroundTexture(@NotNull IIdentifier rightBackgroundTexture) {
        this.rightBackgroundTexture.set((IDependencyReceiver)this, (Object)rightBackgroundTexture);
    }

    public IIdentifier getLeftSelectorTexture() {
        return (IIdentifier)this.leftSelectorTexture.get((IDependencyReceiver)this);
    }

    public void setLeftSelectorTexture(@NotNull IIdentifier leftSelectorTexture) {
        this.leftSelectorTexture.set((IDependencyReceiver)this, (Object)leftSelectorTexture);
    }

    public IIdentifier getRightSelectorTexture() {
        return (IIdentifier)this.rightSelectorTexture.get((IDependencyReceiver)this);
    }

    public void setRightSelectorTexture(@NotNull IIdentifier rightSelectorTexture) {
        this.rightSelectorTexture.set((IDependencyReceiver)this, (Object)rightSelectorTexture);
    }

    public void drawForeground(@NotNull IRenderingController controller) {
    }

    private static class RangeChangedEventArgs {
        private final float previousLeftValue;
        private final float previousRightValue;
        private final float currentLeftValue;
        private final float currentRightValue;

        private RangeChangedEventArgs(float previousLeftValue, float previousRightValue, float currentLeftValue, float currentRightValue) {
            this.previousLeftValue = previousLeftValue;
            this.previousRightValue = previousRightValue;
            this.currentLeftValue = currentLeftValue;
            this.currentRightValue = currentRightValue;
        }

        public float getPreviousLeftValue() {
            return this.previousLeftValue;
        }

        public float getPreviousRightValue() {
            return this.previousRightValue;
        }

        public float getCurrentLeftValue() {
            return this.currentLeftValue;
        }

        public float getCurrentRightValue() {
            return this.currentRightValue;
        }
    }

    private static enum MovementType {
        LEFT_ONLY((s, x) -> {
            float currentLeftSelectorOffset = s.getLeftSelectorOffset();
            float currentRightSelectorOffset = s.getRightSelectorOffset();
            float selectorWidth = currentRightSelectorOffset - currentLeftSelectorOffset;
            if (Math.abs(selectorWidth) <= 1.0E-8f) {
                selectorWidth = 0.0f;
            }
            return (float)x.intValue() <= currentLeftSelectorOffset + selectorWidth / 3.0f;
        }, (s, v) -> v.floatValue() <= s.getRightValue(), RangeSelector::setLeftValue),
        RIGHT_ONLY((s, x) -> {
            float currentLeftSelectorOffset = s.getLeftSelectorOffset();
            float currentRightSelectorOffset = s.getRightSelectorOffset();
            float selectorWidth = currentRightSelectorOffset - currentLeftSelectorOffset;
            if (Math.abs(selectorWidth) <= 1.0E-8f) {
                selectorWidth = 0.0f;
            }
            return (float)x.intValue() >= currentRightSelectorOffset - selectorWidth / 3.0f;
        }, (s, v) -> v.floatValue() >= s.getLeftValue(), RangeSelector::setRightValue),
        BOTH((s, x) -> !LEFT_ONLY.ShouldSelect((RangeSelector)((Object)s), (int)x) && !RIGHT_ONLY.ShouldSelect((RangeSelector)((Object)s), (int)x), (s, v) -> {
            float lastValue = s.convertXPositionToValue(((RangeSelector)s).lastClickX);
            float delta = v.floatValue() - lastValue;
            return s.getLeftValue() + delta >= 0.0f && s.getRightValue() + delta <= 1.0f;
        }, (s, v) -> {
            float lastValue = s.convertXPositionToValue(((RangeSelector)s).lastClickX);
            float delta = v.floatValue() - lastValue;
            s.setLeftValue(s.getLeftValue() + delta);
            s.setRightValue(s.getRightValue() + delta);
        });

        private final BiFunction<RangeSelector, Integer, Boolean> shouldSelectCallback;
        private final BiFunction<RangeSelector, Float, Boolean> isValidCallback;
        private final BiConsumer<RangeSelector, Float> setterCallback;

        private MovementType(BiFunction<RangeSelector, Integer, Boolean> shouldSelectCallback, BiFunction<RangeSelector, Float, Boolean> isValidCallback, BiConsumer<RangeSelector, Float> setterCallback) {
            this.shouldSelectCallback = shouldSelectCallback;
            this.isValidCallback = isValidCallback;
            this.setterCallback = setterCallback;
        }

        public boolean ShouldSelect(RangeSelector s, int x) {
            return this.shouldSelectCallback.apply(s, x);
        }

        public boolean IsValid(RangeSelector s, float v) {
            return this.isValidCallback.apply(s, Float.valueOf(v));
        }

        public void set(RangeSelector s, float v) {
            this.setterCallback.accept(s, Float.valueOf(v));
        }
    }

    public static final class Factory
    extends AbstractSimpleUIElement.AbstractSimpleUIElementFactory<RangeSelector> {
        public Factory() {
            super(RangeSelector.class, Constants.Controls.RangeSelector.KEY_RANGE_SELECTOR, (elementData, engine, id, parent, styleId, alignments, dock, margin, elementSize, dataContext, visible, enabled) -> {
                IDependencyObject leftValue = elementData.getFromRawDataWithDefault("leftValue", engine, (Object)Float.valueOf(0.0f), Float.class, new Object[0]);
                IDependencyObject rightValue = elementData.getFromRawDataWithDefault("rightValue", engine, (Object)Float.valueOf(1.0f), Float.class, new Object[0]);
                IDependencyObject leftBackgroundTexture = elementData.getFromRawDataWithDefault("leftBackground", engine, (Object)IIdentifier.create((String)"minecraft:missingno"), IIdentifier.class, new Object[0]);
                IDependencyObject selectedRegionBackgroundTexture = elementData.getFromRawDataWithDefault("selectedBackground", engine, (Object)IIdentifier.create((String)"minecraft:missingno"), IIdentifier.class, new Object[0]);
                IDependencyObject rightBackgroundTexture = elementData.getFromRawDataWithDefault("rightBackground", engine, (Object)IIdentifier.create((String)"minecraft:missingno"), IIdentifier.class, new Object[0]);
                IDependencyObject leftSelectorTexture = elementData.getFromRawDataWithDefault("leftSelectorBackground", engine, (Object)IIdentifier.create((String)"minecraft:missingno"), IIdentifier.class, new Object[0]);
                IDependencyObject rightSelectorTexture = elementData.getFromRawDataWithDefault("rightSelectorBackground", engine, (Object)IIdentifier.create((String)"minecraft:missingno"), IIdentifier.class, new Object[0]);
                return new RangeSelector(id, parent, (IDependencyObject<IIdentifier>)styleId, (IDependencyObject<EnumSet<Alignment>>)alignments, (IDependencyObject<Dock>)dock, (IDependencyObject<AxisDistance>)margin, (IDependencyObject<Vector2d>)elementSize, (IDependencyObject<Object>)dataContext, (IDependencyObject<Boolean>)visible, (IDependencyObject<Boolean>)enabled, (IDependencyObject<Float>)leftValue, (IDependencyObject<Float>)rightValue, (IDependencyObject<IIdentifier>)leftBackgroundTexture, (IDependencyObject<IIdentifier>)selectedRegionBackgroundTexture, (IDependencyObject<IIdentifier>)rightBackgroundTexture, (IDependencyObject<IIdentifier>)leftSelectorTexture, (IDependencyObject<IIdentifier>)rightSelectorTexture);
            }, (element, builder) -> builder.addComponent("leftValue", (Object)Float.valueOf(element.getLeftValue()), Float.class).addComponent("rightValue", (Object)Float.valueOf(element.getRightValue()), Float.class).addComponent("leftBackground", (Object)element.getLeftBackgroundTexture(), IIdentifier.class).addComponent("selectedBackground", (Object)element.getSelectedRegionBackgroundTexture(), IIdentifier.class).addComponent("rightBackground", (Object)element.getRightBackgroundTexture(), IIdentifier.class).addComponent("leftSelectorBackground", (Object)element.getLeftSelectorTexture(), IIdentifier.class).addComponent("rightSelectorBackground", (Object)element.getRightSelectorTexture(), IIdentifier.class));
        }
    }
}

