/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.blockout.element.simple;

import com.ldtteam.blockout.binding.dependency.DependencyObjectHelper;
import com.ldtteam.blockout.binding.dependency.IDependencyObject;
import com.ldtteam.blockout.binding.dependency.IDependencyReceiver;
import com.ldtteam.blockout.builder.core.builder.IBlockOutGuiConstructionDataBuilder;
import com.ldtteam.blockout.element.IUIElement;
import com.ldtteam.blockout.element.IUIElementHost;
import com.ldtteam.blockout.element.drawable.IDrawableUIElement;
import com.ldtteam.blockout.element.values.Alignment;
import com.ldtteam.blockout.element.values.AxisDistance;
import com.ldtteam.blockout.element.values.Dock;
import com.ldtteam.blockout.element.values.Orientation;
import com.ldtteam.blockout.management.update.IUpdateManager;
import com.ldtteam.blockout.render.core.IRenderingController;
import com.ldtteam.blockout.style.resources.ImageResource;
import com.ldtteam.blockout.util.Constants;
import com.ldtteam.blockout.util.math.BoundingBox;
import com.ldtteam.blockout.util.math.Vector2d;
import com.ldtteam.blockout.utils.controlconstruction.element.core.AbstractSimpleUIElement;
import com.ldtteam.jvoxelizer.client.renderer.opengl.IOpenGl;
import com.ldtteam.jvoxelizer.util.identifier.IIdentifier;
import java.util.EnumSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ProgressBar
extends AbstractSimpleUIElement
implements IDrawableUIElement {
    @NotNull
    public IDependencyObject<IIdentifier> backGroundResource;
    @NotNull
    public IDependencyObject<IIdentifier> foreGroundResource;
    @NotNull
    public IDependencyObject<Double> value;
    @NotNull
    public IDependencyObject<Double> min;
    @NotNull
    public IDependencyObject<Double> max;
    @NotNull
    public IDependencyObject<Orientation> orientation;

    public ProgressBar(@NotNull String id, @Nullable IUIElementHost parent, @NotNull IDependencyObject<IIdentifier> styleId, @NotNull IDependencyObject<EnumSet<Alignment>> alignments, @NotNull IDependencyObject<Dock> dock, @NotNull IDependencyObject<AxisDistance> margin, @NotNull IDependencyObject<Vector2d> elementSize, @NotNull IDependencyObject<Object> dataContext, @NotNull IDependencyObject<Boolean> visible, @NotNull IDependencyObject<Boolean> enabled, @NotNull IDependencyObject<IIdentifier> backGroundResource, @NotNull IDependencyObject<IIdentifier> foreGroundResource, @NotNull IDependencyObject<Double> value, @NotNull IDependencyObject<Double> min, @NotNull IDependencyObject<Double> max, @NotNull IDependencyObject<Orientation> orientation) {
        super(Constants.Controls.ProgressBar.KEY_PROGRESS_BAR, styleId, id, parent, alignments, dock, margin, elementSize, dataContext, visible, enabled);
        this.backGroundResource = backGroundResource;
        this.foreGroundResource = foreGroundResource;
        this.value = value;
        this.min = min;
        this.max = max;
        this.orientation = orientation;
    }

    public void update(@NotNull IUpdateManager updateManager) {
        super.update(updateManager);
        if (this.backGroundResource.hasChanged(this.getDataContext())) {
            updateManager.markDirty();
        }
        if (this.foreGroundResource.hasChanged(this.getDataContext())) {
            updateManager.markDirty();
        }
        if (this.value.hasChanged(this.getDataContext())) {
            updateManager.markDirty();
        }
        if (this.min.hasChanged(this.getDataContext())) {
            updateManager.markDirty();
        }
        if (this.max.hasChanged(this.getDataContext())) {
            updateManager.markDirty();
        }
        if (this.orientation.hasChanged(this.getDataContext())) {
            updateManager.markDirty();
        }
    }

    public void drawBackground(@NotNull IRenderingController controller) {
        controller.getScissoringController().focus((IUIElement)this);
        IOpenGl.pushMatrix();
        ImageResource backGround = this.getBackGround();
        ImageResource foreGround = this.getForeGround();
        BoundingBox localBox = this.getLocalBoundingBox();
        BoundingBox absoluteBox = this.getAbsoluteBoundingBox();
        BoundingBox scissoredForeground = this.getForegroundRenderingBox(absoluteBox);
        Vector2d backgroundScalingFactor = backGround.getScalingFactor(absoluteBox.getSize());
        IOpenGl.scale((double)backgroundScalingFactor.getX(), (double)backgroundScalingFactor.getY(), (double)1.0);
        controller.bindTexture(backGround.getDiskLocation());
        controller.drawTexturedModalRect(new Vector2d(), localBox.getSize(), backGround.getOffset(), backGround.getSize(), backGround.getFileSize());
        IOpenGl.popMatrix();
        controller.getScissoringController().pop();
        controller.getScissoringController().push(scissoredForeground);
        IOpenGl.pushMatrix();
        Vector2d foregroundScalingFactor = foreGround.getScalingFactor(scissoredForeground.getSize());
        IOpenGl.scale((double)foregroundScalingFactor.getX(), (double)foregroundScalingFactor.getY(), (double)1.0);
        controller.bindTexture(foreGround.getDiskLocation());
        controller.drawTexturedModalRect(new Vector2d(), localBox.getSize(), foreGround.getOffset(), foreGround.getSize(), foreGround.getFileSize());
        IOpenGl.popMatrix();
        controller.getScissoringController().pop();
    }

    public void drawForeground(@NotNull IRenderingController controller) {
    }

    @NotNull
    public ImageResource getBackGround() {
        return (ImageResource)this.getResource(this.getBackGroundResource());
    }

    @NotNull
    public ImageResource getForeGround() {
        return (ImageResource)this.getResource(this.getForeGroundResource());
    }

    public BoundingBox getForegroundRenderingBox(@NotNull BoundingBox inputBox) {
        Vector2d size = inputBox.getSize();
        double relativeProgression = (this.getValue() - this.getMin()) / (this.getMax() - this.getMin());
        switch (this.getOrientation()) {
            case LEFT_RIGHT: {
                double width = size.getX() * relativeProgression;
                return new BoundingBox(inputBox.getLocalOrigin(), new Vector2d(width, size.getY()));
            }
            case RIGHT_LEFT: {
                double width = size.getX() * relativeProgression;
                Vector2d translatedOrigin = inputBox.getLocalOrigin().move(size.getX() - width, 0.0).nullifyNegatives();
                return new BoundingBox(translatedOrigin, new Vector2d(width, size.getY()));
            }
            case TOP_BOTTOM: {
                double height = size.getY() * relativeProgression;
                Vector2d translatedOrigin = inputBox.getLocalOrigin().move(0.0, size.getY() - height).nullifyNegatives();
                return new BoundingBox(translatedOrigin, new Vector2d(size.getX(), height));
            }
            case BOTTOM_TOP: {
                double height = size.getY() * relativeProgression;
                return new BoundingBox(inputBox.getLocalOrigin(), new Vector2d(size.getX(), height));
            }
        }
        throw new IllegalStateException(String.format("Unsupported orientation for ProgressBar: %s", this.getOrientation()));
    }

    @NotNull
    public IIdentifier getBackGroundResource() {
        return (IIdentifier)this.backGroundResource.get((IDependencyReceiver)this);
    }

    public void setBackGroundResource(@NotNull IIdentifier backGroundResource) {
        this.backGroundResource.set((IDependencyReceiver)this, (Object)backGroundResource);
    }

    @NotNull
    public IIdentifier getForeGroundResource() {
        return (IIdentifier)this.foreGroundResource.get((IDependencyReceiver)this);
    }

    public void setForeGroundResource(@NotNull IIdentifier foreGroundResource) {
        this.foreGroundResource.set((IDependencyReceiver)this, (Object)foreGroundResource);
    }

    @NotNull
    public Double getValue() {
        return (Double)this.value.get((IDependencyReceiver)this);
    }

    public void setValue(@NotNull Double value) {
        this.value.set((IDependencyReceiver)this, (Object)value);
    }

    @NotNull
    public Double getMin() {
        return (Double)this.min.get((IDependencyReceiver)this);
    }

    public void setMin(@NotNull Double min) {
        this.min.set((IDependencyReceiver)this, (Object)min);
    }

    @NotNull
    public Double getMax() {
        return (Double)this.max.get((IDependencyReceiver)this);
    }

    public void setMax(@NotNull Double max) {
        this.max.set((IDependencyReceiver)this, (Object)max);
    }

    @NotNull
    public Orientation getOrientation() {
        return (Orientation)this.orientation.get((IDependencyReceiver)this);
    }

    public void setOrientation(@NotNull Orientation orientation) {
        this.orientation.set((IDependencyReceiver)this, (Object)orientation);
    }

    public static class Factory
    extends AbstractSimpleUIElement.AbstractSimpleUIElementFactory<ProgressBar> {
        protected Factory() {
            super(ProgressBar.class, Constants.Controls.ProgressBar.KEY_PROGRESS_BAR, (elementData, engine, id, parent, styleId, alignments, dock, margin, elementSize, dataContext, visible, enabled) -> {
                IDependencyObject background = elementData.getFromRawDataWithDefault("backgroundImage", engine, (Object)IIdentifier.create((String)"minecraft:missingno"), IIdentifier.class, new Object[0]);
                IDependencyObject foreground = elementData.getFromRawDataWithDefault("foregroundImage", engine, (Object)IIdentifier.create((String)"minecraft:missingno"), IIdentifier.class, new Object[0]);
                IDependencyObject min = elementData.getFromRawDataWithDefault("min", engine, (Object)0.0, Double.class, new Object[0]);
                IDependencyObject max = elementData.getFromRawDataWithDefault("max", engine, (Object)100.0, Double.class, new Object[0]);
                IDependencyObject value = elementData.getFromRawDataWithDefault("value", engine, (Object)50.0, Double.class, new Object[0]);
                IDependencyObject orientation = elementData.getFromRawDataWithDefault("orientation", engine, (Object)Orientation.LEFT_RIGHT, Orientation.class, new Object[0]);
                ProgressBar element = new ProgressBar(id, parent, (IDependencyObject<IIdentifier>)styleId, (IDependencyObject<EnumSet<Alignment>>)alignments, (IDependencyObject<Dock>)dock, (IDependencyObject<AxisDistance>)margin, (IDependencyObject<Vector2d>)elementSize, (IDependencyObject<Object>)dataContext, (IDependencyObject<Boolean>)visible, (IDependencyObject<Boolean>)enabled, (IDependencyObject<IIdentifier>)background, (IDependencyObject<IIdentifier>)foreground, (IDependencyObject<Double>)min, (IDependencyObject<Double>)max, (IDependencyObject<Double>)value, (IDependencyObject<Orientation>)orientation);
                return element;
            }, (element, builder) -> builder.addComponent("backgroundImage", (Object)element.getBackGroundResource(), IIdentifier.class).addComponent("foregroundImage", (Object)element.getForeGroundResource(), IIdentifier.class).addComponent("min", (Object)element.getMin(), Double.class).addComponent("max", (Object)element.getMax(), Double.class).addComponent("value", (Object)element.getValue(), Double.class).addComponent("orientation", (Object)element.getOrientation(), Orientation.class));
        }
    }

    public static class ProgressBarConstructionDataBuilder
    extends AbstractSimpleUIElement.SimpleControlConstructionDataBuilder<ProgressBarConstructionDataBuilder, ProgressBar> {
        protected ProgressBarConstructionDataBuilder(String controlId, IBlockOutGuiConstructionDataBuilder data) {
            super(controlId, data, ProgressBar.class);
        }

        @NotNull
        public ProgressBarConstructionDataBuilder withDependentBackgroundImageResource(@NotNull IDependencyObject<IIdentifier> backgroundImageResource) {
            return (ProgressBarConstructionDataBuilder)this.withDependency("backGroundResource", backgroundImageResource);
        }

        @NotNull
        public ProgressBarConstructionDataBuilder withBackgroundImageResource(@NotNull IIdentifier backgroundImageResource) {
            return (ProgressBarConstructionDataBuilder)this.withDependency("backGroundResource", DependencyObjectHelper.createFromValue((Object)backgroundImageResource));
        }

        @NotNull
        public ProgressBarConstructionDataBuilder withDependentForegroundImageResource(@NotNull IDependencyObject<IIdentifier> foregroundImageResource) {
            return (ProgressBarConstructionDataBuilder)this.withDependency("foreGroundResource", foregroundImageResource);
        }

        @NotNull
        public ProgressBarConstructionDataBuilder withForegroundImageResource(@NotNull IIdentifier foregroundImageResource) {
            return (ProgressBarConstructionDataBuilder)this.withDependency("foreGroundResource", DependencyObjectHelper.createFromValue((Object)foregroundImageResource));
        }

        @NotNull
        public ProgressBarConstructionDataBuilder withDependentMinValue(@NotNull IDependencyObject<Double> min) {
            return (ProgressBarConstructionDataBuilder)this.withDependency("min", min);
        }

        public ProgressBarConstructionDataBuilder withMinValue(@NotNull Double min) {
            return (ProgressBarConstructionDataBuilder)this.withDependency("min", DependencyObjectHelper.createFromValue((Object)min));
        }

        @NotNull
        public ProgressBarConstructionDataBuilder withDependentMaxValue(@NotNull IDependencyObject<Double> max) {
            return (ProgressBarConstructionDataBuilder)this.withDependency("max", max);
        }

        public ProgressBarConstructionDataBuilder withMaxValue(@NotNull Double max) {
            return (ProgressBarConstructionDataBuilder)this.withDependency("max", DependencyObjectHelper.createFromValue((Object)max));
        }

        @NotNull
        public ProgressBarConstructionDataBuilder withDependentValue(@NotNull IDependencyObject<Double> value) {
            return (ProgressBarConstructionDataBuilder)this.withDependency("value", value);
        }

        public ProgressBarConstructionDataBuilder withValue(@NotNull Double value) {
            return (ProgressBarConstructionDataBuilder)this.withDependency("value", DependencyObjectHelper.createFromValue((Object)value));
        }

        @NotNull
        public ProgressBarConstructionDataBuilder withDependentOrientation(@NotNull IDependencyObject<Orientation> orientation) {
            return (ProgressBarConstructionDataBuilder)this.withDependency("orientation", orientation);
        }

        public ProgressBarConstructionDataBuilder withOrientation(@NotNull Orientation orientation) {
            return (ProgressBarConstructionDataBuilder)this.withDependency("orientation", DependencyObjectHelper.createFromValue((Object)orientation));
        }
    }
}

