/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.blockout.element.simple;

import com.ldtteam.blockout.binding.dependency.IDependencyObject;
import com.ldtteam.blockout.binding.dependency.IDependencyReceiver;
import com.ldtteam.blockout.builder.core.builder.IBlockOutGuiConstructionDataBuilder;
import com.ldtteam.blockout.element.IUIElement;
import com.ldtteam.blockout.element.IUIElementHost;
import com.ldtteam.blockout.element.drawable.IDrawableUIElement;
import com.ldtteam.blockout.element.values.Alignment;
import com.ldtteam.blockout.element.values.AxisDistance;
import com.ldtteam.blockout.element.values.Dock;
import com.ldtteam.blockout.management.update.IUpdateManager;
import com.ldtteam.blockout.proxy.ProxyHolder;
import com.ldtteam.blockout.render.core.IRenderingController;
import com.ldtteam.blockout.util.Constants;
import com.ldtteam.blockout.util.math.Vector2d;
import com.ldtteam.blockout.utils.controlconstruction.element.core.AbstractSimpleUIElement;
import com.ldtteam.jvoxelizer.client.renderer.opengl.IOpenGl;
import com.ldtteam.jvoxelizer.client.renderer.opengl.util.DestinationFactor;
import com.ldtteam.jvoxelizer.client.renderer.opengl.util.SourceFactor;
import com.ldtteam.jvoxelizer.translation.ITranslator;
import com.ldtteam.jvoxelizer.util.identifier.IIdentifier;
import com.ldtteam.jvoxelizer.util.textformatting.ITextFormatting;
import java.util.EnumSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Label
extends AbstractSimpleUIElement
implements IDrawableUIElement {
    private final Pattern TRANSLATION_RAW_PATTERN = Pattern.compile("(?<key>(\\$\\{(?<keydata>.*?)\\}))|(?<value>(.*?))");
    @NotNull
    public IDependencyObject<String> contents;
    @NotNull
    public IDependencyObject<String> fontColor;

    public Label(@NotNull String id, @Nullable IUIElementHost parent, @NotNull IDependencyObject<IIdentifier> styleId, @NotNull IDependencyObject<EnumSet<Alignment>> alignments, @NotNull IDependencyObject<Dock> dock, @NotNull IDependencyObject<AxisDistance> margin, @NotNull IDependencyObject<Vector2d> elementSize, @NotNull IDependencyObject<Object> dataContext, @NotNull IDependencyObject<Boolean> visible, @NotNull IDependencyObject<Boolean> enabled, @NotNull IDependencyObject<String> contents, @NotNull IDependencyObject<String> fontColor) {
        super(Constants.Controls.Label.KEY_LABEL, styleId, id, parent, alignments, dock, margin, elementSize, dataContext, visible, enabled);
        this.contents = contents;
        this.fontColor = fontColor;
    }

    public void update(@NotNull IUpdateManager updateManager) {
        super.update(updateManager);
        if (this.contents.hasChanged(this.getDataContext())) {
            updateManager.markDirty();
        }
    }

    public void drawBackground(@NotNull IRenderingController controller) {
        controller.getScissoringController().focus((IUIElement)this);
        IOpenGl.pushMatrix();
        IOpenGl.disableStandardItemLighting();
        IOpenGl.enableAlpha();
        IOpenGl.enableBlend();
        IOpenGl.blendFunc((SourceFactor)SourceFactor.SRC_ALPHA, (DestinationFactor)DestinationFactor.ONE_MINUS_SRC_ALPHA);
        ProxyHolder.getInstance().getFontRenderer().drawSplitString(this.getTranslatedContents(), 0, 0, (int)this.getLocalBoundingBox().getSize().getX(), 0);
        IOpenGl.disableBlend();
        IOpenGl.disableAlpha();
        IOpenGl.popMatrix();
        controller.getScissoringController().pop();
    }

    public void drawForeground(@NotNull IRenderingController controller) {
    }

    public String getTranslatedContents() {
        String keyGroupMatching;
        String rawContents = this.getContents();
        Matcher contentMatcher = this.TRANSLATION_RAW_PATTERN.matcher(rawContents);
        while (contentMatcher.find() && (keyGroupMatching = contentMatcher.group("keydata")) != null) {
            rawContents = rawContents.replace("${" + keyGroupMatching + "}", ITranslator.format((String)keyGroupMatching, (Object[])new Object[0]));
            contentMatcher = this.TRANSLATION_RAW_PATTERN.matcher(rawContents);
        }
        return ProxyHolder.getInstance().convertToColorCode(this.getFontColor()) + rawContents + ITextFormatting.reset();
    }

    public String getContents() {
        return (String)this.contents.get((IDependencyReceiver)this);
    }

    public void setContents(String contents) {
        this.contents.set((IDependencyReceiver)this, (Object)contents);
    }

    public String getFontColor() {
        return (String)this.fontColor.get((IDependencyReceiver)this);
    }

    public void setFontColor(String color) {
        this.fontColor.set((IDependencyReceiver)this, (Object)color);
    }

    public static class Factory
    extends AbstractSimpleUIElement.AbstractSimpleUIElementFactory<Label> {
        public Factory() {
            super(Label.class, Constants.Controls.Label.KEY_LABEL, (elementData, engine, id, parent, styleId, alignments, dock, margin, elementSize, dataContext, visible, enabled) -> {
                IDependencyObject contents = elementData.getFromRawDataWithDefault("content", engine, (Object)"<UNKNOWN>", String.class, new Object[0]);
                IDependencyObject fontColor = elementData.getFromRawDataWithDefault("font-color", engine, (Object)ITextFormatting.reset().toString(), String.class, new Object[0]);
                Label element = new Label(id, parent, (IDependencyObject<IIdentifier>)styleId, (IDependencyObject<EnumSet<Alignment>>)alignments, (IDependencyObject<Dock>)dock, (IDependencyObject<AxisDistance>)margin, (IDependencyObject<Vector2d>)elementSize, (IDependencyObject<Object>)dataContext, (IDependencyObject<Boolean>)visible, (IDependencyObject<Boolean>)enabled, (IDependencyObject<String>)contents, (IDependencyObject<String>)fontColor);
                return element;
            }, (element, builder) -> builder.addComponent("content", (Object)element.getContents(), String.class).addComponent("font-color", (Object)element.getFontColor(), String.class));
        }
    }

    public static class LabelConstructionDataBuilder
    extends AbstractSimpleUIElement.SimpleControlConstructionDataBuilder<LabelConstructionDataBuilder, Label> {
        public LabelConstructionDataBuilder(String controlId, IBlockOutGuiConstructionDataBuilder data) {
            super(controlId, data, Label.class);
        }

        @NotNull
        public LabelConstructionDataBuilder withDependentContents(@NotNull IDependencyObject<String> contents) {
            return (LabelConstructionDataBuilder)this.withDependency("contents", contents);
        }
    }
}

