/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.blockout.element.simple;

import com.ldtteam.blockout.binding.dependency.DependencyObjectHelper;
import com.ldtteam.blockout.binding.dependency.IDependencyObject;
import com.ldtteam.blockout.binding.dependency.IDependencyReceiver;
import com.ldtteam.blockout.builder.core.builder.IBlockOutGuiConstructionDataBuilder;
import com.ldtteam.blockout.element.IUIElementHost;
import com.ldtteam.blockout.element.drawable.IDrawableUIElement;
import com.ldtteam.blockout.element.values.Alignment;
import com.ldtteam.blockout.element.values.AxisDistance;
import com.ldtteam.blockout.element.values.Dock;
import com.ldtteam.blockout.management.update.IUpdateManager;
import com.ldtteam.blockout.render.core.IRenderingController;
import com.ldtteam.blockout.style.resources.ItemStackResource;
import com.ldtteam.blockout.util.Constants;
import com.ldtteam.blockout.util.math.Vector2d;
import com.ldtteam.blockout.utils.controlconstruction.element.core.AbstractSimpleUIElement;
import com.ldtteam.jvoxelizer.client.renderer.opengl.IOpenGl;
import com.ldtteam.jvoxelizer.item.IItemStack;
import com.ldtteam.jvoxelizer.util.identifier.IIdentifier;
import java.util.EnumSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ItemIcon
extends AbstractSimpleUIElement
implements IDrawableUIElement {
    @NotNull
    public IDependencyObject<IIdentifier> iconResource;

    public ItemIcon(@NotNull String id, @Nullable IUIElementHost parent, @NotNull IDependencyObject<IIdentifier> styleId, @NotNull IDependencyObject<EnumSet<Alignment>> alignments, @NotNull IDependencyObject<Dock> dock, @NotNull IDependencyObject<AxisDistance> margin, @NotNull IDependencyObject<Vector2d> elementSize, @NotNull IDependencyObject<Object> dataContext, @NotNull IDependencyObject<Boolean> visible, @NotNull IDependencyObject<Boolean> enabled, @NotNull IDependencyObject<IIdentifier> iconResource) {
        super(Constants.Controls.ItemIcon.KEY_ITEM, styleId, id, parent, alignments, dock, margin, elementSize, dataContext, visible, enabled);
        this.iconResource = iconResource;
    }

    public void update(@NotNull IUpdateManager updateManager) {
        super.update(updateManager);
        if (this.iconResource.hasChanged(this.getDataContext())) {
            updateManager.markDirty();
        }
    }

    public void drawBackground(@NotNull IRenderingController controller) {
        ItemStackResource resource = this.getIcon();
        IItemStack stack = resource.getStack();
        if (stack != null && !stack.isEmpty()) {
            IOpenGl.pushMatrix();
            Vector2d scalingFactor = resource.getScalingFactor(this.getLocalBoundingBox().getSize());
            IOpenGl.scale((double)scalingFactor.getX(), (double)scalingFactor.getY(), (double)1.0);
            controller.drawItemStack(stack, 0, 0);
            IOpenGl.popMatrix();
        }
    }

    @NotNull
    public ItemStackResource getIcon() {
        return (ItemStackResource)this.getResource(this.getIconResource());
    }

    @NotNull
    public IIdentifier getIconResource() {
        return (IIdentifier)this.iconResource.get((IDependencyReceiver)this);
    }

    public void setIconResource(@NotNull IIdentifier icon) {
        this.iconResource.set((IDependencyReceiver)this, (Object)icon);
    }

    public void drawForeground(@NotNull IRenderingController controller) {
    }

    public static class Factory
    extends AbstractSimpleUIElement.AbstractSimpleUIElementFactory<ItemIcon> {
        public Factory() {
            super(ItemIcon.class, Constants.Controls.ItemIcon.KEY_ITEM, (elementData, engine, id, parent, styleId, alignments, dock, margin, elementSize, dataContext, visible, enabled) -> {
                IDependencyObject icon = elementData.getFromRawDataWithDefault("icon", engine, (Object)IIdentifier.create((String)"minecraft:missingno"), IIdentifier.class, new Object[0]);
                ItemIcon element = new ItemIcon(id, parent, (IDependencyObject<IIdentifier>)styleId, (IDependencyObject<EnumSet<Alignment>>)alignments, (IDependencyObject<Dock>)dock, (IDependencyObject<AxisDistance>)margin, (IDependencyObject<Vector2d>)elementSize, (IDependencyObject<Object>)dataContext, (IDependencyObject<Boolean>)visible, (IDependencyObject<Boolean>)enabled, (IDependencyObject<IIdentifier>)icon);
                return element;
            }, (element, builder) -> builder.addComponent("icon", (Object)element.getIconResource(), IIdentifier.class));
        }
    }

    public static class ItemIconConstructionDataBuilder
    extends AbstractSimpleUIElement.SimpleControlConstructionDataBuilder<ItemIconConstructionDataBuilder, ItemIcon> {
        protected ItemIconConstructionDataBuilder(String controlId, IBlockOutGuiConstructionDataBuilder data) {
            super(controlId, data, ItemIcon.class);
        }

        @NotNull
        public ItemIconConstructionDataBuilder withDependentIconResource(@NotNull IDependencyObject<ItemStackResource> iconResource) {
            return (ItemIconConstructionDataBuilder)this.withDependency("iconResource", iconResource);
        }

        @NotNull
        public ItemIconConstructionDataBuilder withIconResource(@NotNull ItemStackResource iconResource) {
            return (ItemIconConstructionDataBuilder)this.withDependency("iconResource", DependencyObjectHelper.createFromValue((Object)iconResource));
        }
    }
}

