/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.blockout.element.simple;

import com.ldtteam.blockout.binding.dependency.DependencyObjectHelper;
import com.ldtteam.blockout.binding.dependency.IDependencyObject;
import com.ldtteam.blockout.binding.dependency.IDependencyReceiver;
import com.ldtteam.blockout.builder.core.builder.IBlockOutGuiConstructionDataBuilder;
import com.ldtteam.blockout.element.IUIElementHost;
import com.ldtteam.blockout.element.drawable.IDrawableUIElement;
import com.ldtteam.blockout.element.values.Alignment;
import com.ldtteam.blockout.element.values.AxisDistance;
import com.ldtteam.blockout.element.values.Dock;
import com.ldtteam.blockout.management.update.IUpdateManager;
import com.ldtteam.blockout.render.core.IRenderingController;
import com.ldtteam.blockout.style.resources.ImageResource;
import com.ldtteam.blockout.util.Constants;
import com.ldtteam.blockout.util.math.Vector2d;
import com.ldtteam.blockout.utils.controlconstruction.element.core.AbstractSimpleUIElement;
import com.ldtteam.jvoxelizer.client.renderer.opengl.IOpenGl;
import com.ldtteam.jvoxelizer.client.renderer.opengl.util.DestinationFactor;
import com.ldtteam.jvoxelizer.client.renderer.opengl.util.SourceFactor;
import com.ldtteam.jvoxelizer.util.identifier.IIdentifier;
import java.util.EnumSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Image
extends AbstractSimpleUIElement
implements IDrawableUIElement {
    @NotNull
    public IDependencyObject<IIdentifier> iconResource;

    public Image(@NotNull String id, @Nullable IUIElementHost parent, @NotNull IDependencyObject<IIdentifier> styleId, @NotNull IDependencyObject<EnumSet<Alignment>> alignments, @NotNull IDependencyObject<Dock> dock, @NotNull IDependencyObject<AxisDistance> margin, @NotNull IDependencyObject<Vector2d> elementSize, @NotNull IDependencyObject<Object> dataContext, @NotNull IDependencyObject<Boolean> visible, @NotNull IDependencyObject<Boolean> enabled, @NotNull IDependencyObject<IIdentifier> iconResource) {
        super(Constants.Controls.Image.KEY_IMAGE, styleId, id, parent, alignments, dock, margin, elementSize, dataContext, visible, enabled);
        this.iconResource = iconResource;
    }

    public void update(@NotNull IUpdateManager updateManager) {
        super.update(updateManager);
        if (this.iconResource.hasChanged(this.getDataContext())) {
            updateManager.markDirty();
        }
    }

    public void drawBackground(@NotNull IRenderingController controller) {
        ImageResource resource = this.getIcon();
        IOpenGl.pushMatrix();
        IOpenGl.enableAlpha();
        IOpenGl.enableBlend();
        IOpenGl.blendFunc((SourceFactor)SourceFactor.SRC_ALPHA, (DestinationFactor)DestinationFactor.ONE_MINUS_SRC_ALPHA);
        IOpenGl.color((float)1.0f, (float)1.0f, (float)1.0f);
        controller.bindTexture(resource.getDiskLocation());
        controller.drawTexturedModalRect(new Vector2d(), this.getLocalBoundingBox().getSize(), resource.getOffset(), resource.getSize(), resource.getFileSize());
        IOpenGl.disableBlend();
        IOpenGl.disableAlpha();
        IOpenGl.popMatrix();
    }

    public void drawForeground(@NotNull IRenderingController controller) {
    }

    @NotNull
    public ImageResource getIcon() {
        return (ImageResource)this.getResource(this.getIconResource());
    }

    @NotNull
    public IIdentifier getIconResource() {
        return (IIdentifier)this.iconResource.get((IDependencyReceiver)this);
    }

    public void setIconResource(@NotNull IIdentifier icon) {
        this.iconResource.set((IDependencyReceiver)this, (Object)icon);
    }

    public static class Factory
    extends AbstractSimpleUIElement.AbstractSimpleUIElementFactory<Image> {
        public Factory() {
            super(Image.class, Constants.Controls.Image.KEY_IMAGE, (elementData, engine, id, parent, styleId, alignments, dock, margin, elementSize, dataContext, visible, enabled) -> {
                IDependencyObject icon = elementData.getFromRawDataWithDefault("icon", engine, (Object)IIdentifier.create((String)"minecraft:missingno"), IIdentifier.class, new Object[0]);
                Image element = new Image(id, parent, (IDependencyObject<IIdentifier>)styleId, (IDependencyObject<EnumSet<Alignment>>)alignments, (IDependencyObject<Dock>)dock, (IDependencyObject<AxisDistance>)margin, (IDependencyObject<Vector2d>)elementSize, (IDependencyObject<Object>)dataContext, (IDependencyObject<Boolean>)visible, (IDependencyObject<Boolean>)enabled, (IDependencyObject<IIdentifier>)icon);
                return element;
            }, (element, builder) -> builder.addComponent("icon", (Object)element.getIconResource(), IIdentifier.class));
        }
    }

    public static class ImageConstructionDataBuilder
    extends AbstractSimpleUIElement.SimpleControlConstructionDataBuilder<ImageConstructionDataBuilder, Image> {
        protected ImageConstructionDataBuilder(String controlId, IBlockOutGuiConstructionDataBuilder data) {
            super(controlId, data, Image.class);
        }

        @NotNull
        public ImageConstructionDataBuilder withDependentIconResource(@NotNull IDependencyObject<IIdentifier> iconResource) {
            return (ImageConstructionDataBuilder)this.withDependency("iconResource", iconResource);
        }

        @NotNull
        public ImageConstructionDataBuilder withIconResource(@NotNull IIdentifier iconResource) {
            return (ImageConstructionDataBuilder)this.withDependency("iconResource", DependencyObjectHelper.createFromValue((Object)iconResource));
        }
    }
}

