/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.blockout.element.simple;

import com.ldtteam.blockout.binding.dependency.DependencyObjectHelper;
import com.ldtteam.blockout.binding.dependency.IDependencyObject;
import com.ldtteam.blockout.binding.dependency.IDependencyReceiver;
import com.ldtteam.blockout.builder.core.builder.IBlockOutGuiConstructionDataBuilder;
import com.ldtteam.blockout.element.IUIElementHost;
import com.ldtteam.blockout.element.drawable.IDrawableUIElement;
import com.ldtteam.blockout.element.input.IClickAcceptingUIElement;
import com.ldtteam.blockout.element.values.Alignment;
import com.ldtteam.blockout.element.values.AxisDistance;
import com.ldtteam.blockout.element.values.Dock;
import com.ldtteam.blockout.event.Event;
import com.ldtteam.blockout.event.IEventHandler;
import com.ldtteam.blockout.management.update.IUpdateManager;
import com.ldtteam.blockout.render.core.IRenderingController;
import com.ldtteam.blockout.style.resources.ImageResource;
import com.ldtteam.blockout.util.Constants;
import com.ldtteam.blockout.util.math.Vector2d;
import com.ldtteam.blockout.util.mouse.MouseButton;
import com.ldtteam.blockout.utils.controlconstruction.element.core.AbstractSimpleUIElement;
import com.ldtteam.jvoxelizer.client.renderer.opengl.IOpenGl;
import com.ldtteam.jvoxelizer.util.identifier.IIdentifier;
import java.util.EnumSet;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CheckBox
extends AbstractSimpleUIElement
implements IDrawableUIElement,
IClickAcceptingUIElement {
    @NotNull
    public IDependencyObject<IIdentifier> normalBackgroundImageResource;
    @NotNull
    public IDependencyObject<IIdentifier> checkedBackgroundImageResource;
    @NotNull
    public IDependencyObject<IIdentifier> disabledBackgroundImageResource;
    @NotNull
    public IDependencyObject<Boolean> checked;
    @NotNull
    public Event<CheckBox, CheckBoxCheckChangedEventArgs> onCheckedChanged = new Event(CheckBox.class, CheckBoxCheckChangedEventArgs.class);

    public CheckBox(@NotNull String id, @Nullable IUIElementHost parent, @NotNull IDependencyObject<IIdentifier> styleId, @NotNull IDependencyObject<EnumSet<Alignment>> alignments, @NotNull IDependencyObject<Dock> dock, @NotNull IDependencyObject<AxisDistance> margin, @NotNull IDependencyObject<Vector2d> elementSize, @NotNull IDependencyObject<Object> dataContext, @NotNull IDependencyObject<Boolean> visible, @NotNull IDependencyObject<Boolean> enabled, @NotNull IDependencyObject<IIdentifier> normalBackgroundImageResource, @NotNull IDependencyObject<IIdentifier> checkedBackgroundImageResource, @NotNull IDependencyObject<IIdentifier> disabledBackgroundImageResource, @NotNull IDependencyObject<Boolean> checked) {
        super(Constants.Controls.CheckBox.KEY_CHECKBOX, styleId, id, parent, alignments, dock, margin, elementSize, dataContext, visible, enabled);
        this.normalBackgroundImageResource = normalBackgroundImageResource;
        this.checkedBackgroundImageResource = checkedBackgroundImageResource;
        this.disabledBackgroundImageResource = disabledBackgroundImageResource;
        this.checked = checked;
    }

    public void update(@NotNull IUpdateManager updateManager) {
        super.update(updateManager);
        if (this.normalBackgroundImageResource.hasChanged(this.getDataContext())) {
            updateManager.markDirty();
        }
        if (this.checkedBackgroundImageResource.hasChanged(this.getDataContext())) {
            updateManager.markDirty();
        }
        if (this.disabledBackgroundImageResource.hasChanged(this.getDataContext())) {
            updateManager.markDirty();
        }
        if (this.checked.hasChanged(this.getDataContext())) {
            updateManager.markDirty();
        }
    }

    public void drawBackground(@NotNull IRenderingController controller) {
        if (!this.isVisible()) {
            return;
        }
        if (!this.isEnabled()) {
            this.drawBackground(controller, this::getDisabledBackgroundImage);
        } else if (this.isChecked()) {
            this.drawBackground(controller, this::getCheckedBackgroundImage);
        } else {
            this.drawBackground(controller, this::getNormalBackgroundImage);
        }
    }

    private void drawBackground(@NotNull IRenderingController controller, Supplier<ImageResource> resourceSupplier) {
        ImageResource resource = resourceSupplier.get();
        Vector2d size = this.getLocalBoundingBox().getSize();
        IOpenGl.pushMatrix();
        controller.bindTexture(resource.getDiskLocation());
        controller.drawTexturedModalRect(new Vector2d(), size, resource.getOffset(), resource.getSize(), resource.getFileSize());
        IOpenGl.popMatrix();
    }

    @NotNull
    public ImageResource getDisabledBackgroundImage() {
        return (ImageResource)this.getResource(this.getDisabledBackgroundImageResource());
    }

    public boolean isChecked() {
        return (Boolean)this.checked.get((IDependencyReceiver)this);
    }

    public void setChecked(@NotNull boolean checked) {
        boolean currentClickState = this.isChecked();
        this.checked.set((IDependencyReceiver)this, (Object)checked);
        if (currentClickState != checked) {
            this.getParent().getUiManager().getUpdateManager().markDirty();
        }
    }

    @NotNull
    public ImageResource getCheckedBackgroundImage() {
        return (ImageResource)this.getResource(this.getCheckedBackgroundImageResource());
    }

    @NotNull
    public ImageResource getNormalBackgroundImage() {
        return (ImageResource)this.getResource(this.getNormalBackgroundImageResource());
    }

    @NotNull
    public IIdentifier getDisabledBackgroundImageResource() {
        return (IIdentifier)this.disabledBackgroundImageResource.get((IDependencyReceiver)this);
    }

    @NotNull
    public IIdentifier getCheckedBackgroundImageResource() {
        return (IIdentifier)this.checkedBackgroundImageResource.get((IDependencyReceiver)this);
    }

    @NotNull
    public IIdentifier getNormalBackgroundImageResource() {
        return (IIdentifier)this.normalBackgroundImageResource.get((IDependencyReceiver)this);
    }

    public void setNormalBackgroundImageResource(@NotNull IIdentifier normalBackgroundImage) {
        this.normalBackgroundImageResource.set((IDependencyReceiver)this, (Object)normalBackgroundImage);
    }

    public void setCheckedBackgroundImageResource(@NotNull IIdentifier checkedBackgroundImage) {
        this.checkedBackgroundImageResource.set((IDependencyReceiver)this, (Object)checkedBackgroundImage);
    }

    public void setDisabledBackgroundImageResource(@NotNull IIdentifier disabledBackgroundImage) {
        this.disabledBackgroundImageResource.set((IDependencyReceiver)this, (Object)disabledBackgroundImage);
    }

    public void drawForeground(@NotNull IRenderingController controller) {
    }

    public boolean canAcceptMouseInput(int localX, int localY, MouseButton button) {
        return this.isEnabled() && this.isVisible();
    }

    public void onMouseClickBegin(int localX, int localY, MouseButton button) {
        this.setChecked(!this.isChecked());
        this.onCheckedChanged.raise((Object)this, (Object)new CheckBoxCheckChangedEventArgs(this.isChecked(), localX, localY, button));
    }

    public static class CheckBoxCheckChangedEventArgs {
        private final boolean isChecked;
        private final int localX;
        private final int localY;
        private final MouseButton button;
        private final float timeDelta;

        public CheckBoxCheckChangedEventArgs(boolean isChecked, int localX, int localY, MouseButton button) {
            this.isChecked = isChecked;
            this.localX = localX;
            this.localY = localY;
            this.button = button;
            this.timeDelta = 0.0f;
        }

        public CheckBoxCheckChangedEventArgs(boolean isChecked, int localX, int localY, MouseButton button, float timeDelta) {
            this.isChecked = isChecked;
            this.localX = localX;
            this.localY = localY;
            this.button = button;
            this.timeDelta = timeDelta;
        }

        public boolean isChecked() {
            return this.isChecked;
        }

        public int getLocalX() {
            return this.localX;
        }

        public int getLocalY() {
            return this.localY;
        }

        public MouseButton getButton() {
            return this.button;
        }

        public float getTimeDelta() {
            return this.timeDelta;
        }
    }

    public static class Factory
    extends AbstractSimpleUIElement.AbstractSimpleUIElementFactory<CheckBox> {
        public Factory() {
            super(CheckBox.class, Constants.Controls.CheckBox.KEY_CHECKBOX, (elementData, engine, id, parent, styleId, alignments, dock, margin, elementSize, dataContext, visible, enabled) -> {
                IDependencyObject defaultBackgroundImage = elementData.getFromRawDataWithDefault("defaultBackgroundImage", engine, (Object)IIdentifier.create((String)"minecraft:missingno"), IIdentifier.class, new Object[0]);
                IDependencyObject checkedBackgroundImage = elementData.getFromRawDataWithDefault("checkedBackgroundImage", engine, (Object)IIdentifier.create((String)"minecraft:missingno"), IIdentifier.class, new Object[0]);
                IDependencyObject disabledBackgroundImage = elementData.getFromRawDataWithDefault("disabledBackgroundImage", engine, (Object)IIdentifier.create((String)"minecraft:missingno"), IIdentifier.class, new Object[0]);
                IDependencyObject checked = elementData.getFromRawDataWithDefault("checked", engine, (Object)false, Boolean.class, new Object[0]);
                CheckBox element = new CheckBox(id, parent, (IDependencyObject<IIdentifier>)styleId, (IDependencyObject<EnumSet<Alignment>>)alignments, (IDependencyObject<Dock>)dock, (IDependencyObject<AxisDistance>)margin, (IDependencyObject<Vector2d>)elementSize, (IDependencyObject<Object>)dataContext, (IDependencyObject<Boolean>)visible, (IDependencyObject<Boolean>)enabled, (IDependencyObject<IIdentifier>)defaultBackgroundImage, (IDependencyObject<IIdentifier>)checkedBackgroundImage, (IDependencyObject<IIdentifier>)disabledBackgroundImage, (IDependencyObject<Boolean>)checked);
                return element;
            }, (element, builder) -> builder.addComponent("defaultBackgroundImage", (Object)element.getNormalBackgroundImageResource(), IIdentifier.class).addComponent("disabledBackgroundImage", (Object)element.getDisabledBackgroundImageResource(), IIdentifier.class).addComponent("checkedBackgroundImage", (Object)element.getCheckedBackgroundImageResource(), IIdentifier.class).addComponent("checked", (Object)element.isChecked(), Boolean.class));
        }
    }

    public static class ButtonConstructionDataBuilder
    extends AbstractSimpleUIElement.SimpleControlConstructionDataBuilder<ButtonConstructionDataBuilder, CheckBox> {
        public ButtonConstructionDataBuilder(String controlId, IBlockOutGuiConstructionDataBuilder data) {
            super(controlId, data, CheckBox.class);
        }

        @NotNull
        public ButtonConstructionDataBuilder withNormalBackgroundImageResource(@NotNull IDependencyObject<IIdentifier> normalBackgroundImageResource) {
            return (ButtonConstructionDataBuilder)this.withDependency("normalBackgroundImageResource", normalBackgroundImageResource);
        }

        @NotNull
        public ButtonConstructionDataBuilder withNormalBackgroundImageResource(@NotNull IIdentifier normalBackgroundImageResource) {
            return (ButtonConstructionDataBuilder)this.withDependency("normalBackgroundImageResource", DependencyObjectHelper.createFromValue((Object)normalBackgroundImageResource));
        }

        @NotNull
        public ButtonConstructionDataBuilder withCheckedBackgroundImageResource(@NotNull IDependencyObject<IIdentifier> checkedBackgroundImageResource) {
            return (ButtonConstructionDataBuilder)this.withDependency("checkedBackgroundImageResource", checkedBackgroundImageResource);
        }

        @NotNull
        public ButtonConstructionDataBuilder withCheckedBackgroundImageResource(@NotNull IIdentifier checkedBackgroundImageResource) {
            return (ButtonConstructionDataBuilder)this.withDependency("checkedBackgroundImageResource", DependencyObjectHelper.createFromValue((Object)checkedBackgroundImageResource));
        }

        @NotNull
        public ButtonConstructionDataBuilder withDisabledBackgroundImageResource(@NotNull IDependencyObject<IIdentifier> disabledBackgroundImageResource) {
            return (ButtonConstructionDataBuilder)this.withDependency("disabledBackgroundImageResource", disabledBackgroundImageResource);
        }

        @NotNull
        public ButtonConstructionDataBuilder withDisabledBackgroundImageResource(@NotNull IIdentifier disabledBackgroundImageResource) {
            return (ButtonConstructionDataBuilder)this.withDependency("disabledBackgroundImageResource", DependencyObjectHelper.createFromValue((Object)disabledBackgroundImageResource));
        }

        @NotNull
        public ButtonConstructionDataBuilder withCheckedChangedEventHandler(@NotNull IEventHandler<CheckBox, CheckBoxCheckChangedEventArgs> eventHandler) {
            return (ButtonConstructionDataBuilder)this.withEventHandler("onCheckedChanged", CheckBoxCheckChangedEventArgs.class, eventHandler);
        }
    }
}

