/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.blockout.element.simple;

import com.ldtteam.blockout.binding.dependency.DependencyObjectHelper;
import com.ldtteam.blockout.binding.dependency.IDependencyObject;
import com.ldtteam.blockout.binding.dependency.IDependencyReceiver;
import com.ldtteam.blockout.builder.core.builder.IBlockOutGuiConstructionDataBuilder;
import com.ldtteam.blockout.element.IUIElement;
import com.ldtteam.blockout.element.IUIElementHost;
import com.ldtteam.blockout.element.drawable.IDrawableUIElement;
import com.ldtteam.blockout.element.input.IClickAcceptingUIElement;
import com.ldtteam.blockout.element.values.Alignment;
import com.ldtteam.blockout.element.values.AxisDistance;
import com.ldtteam.blockout.element.values.Dock;
import com.ldtteam.blockout.event.Event;
import com.ldtteam.blockout.event.IEventHandler;
import com.ldtteam.blockout.management.update.IUpdateManager;
import com.ldtteam.blockout.render.core.IRenderingController;
import com.ldtteam.blockout.style.resources.ImageResource;
import com.ldtteam.blockout.util.Constants;
import com.ldtteam.blockout.util.math.Vector2d;
import com.ldtteam.blockout.util.mouse.MouseButton;
import com.ldtteam.blockout.utils.controlconstruction.element.core.AbstractChildrenContainingUIElement;
import com.ldtteam.blockout.utils.controlconstruction.element.core.AbstractFilteringChildrenContainingUIElement;
import com.ldtteam.jvoxelizer.client.renderer.opengl.IOpenGl;
import com.ldtteam.jvoxelizer.util.identifier.IIdentifier;
import java.util.EnumSet;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Button
extends AbstractFilteringChildrenContainingUIElement
implements IDrawableUIElement,
IClickAcceptingUIElement {
    @NotNull
    public IDependencyObject<IIdentifier> normalBackgroundImageResource;
    @NotNull
    public IDependencyObject<IIdentifier> clickedBackgroundImageResource;
    @NotNull
    public IDependencyObject<IIdentifier> disabledBackgroundImageResource;
    @NotNull
    public IDependencyObject<Boolean> clicked;
    @NotNull
    public Event<Button, ButtonClickedEventArgs> onClicked = new Event(Button.class, ButtonClickedEventArgs.class);

    public Button(@NotNull String id, @Nullable IUIElementHost parent, @NotNull IDependencyObject<IIdentifier> styleId, @NotNull IDependencyObject<EnumSet<Alignment>> alignments, @NotNull IDependencyObject<Dock> dock, @NotNull IDependencyObject<AxisDistance> margin, @NotNull IDependencyObject<AxisDistance> padding, @NotNull IDependencyObject<Vector2d> elementSize, @NotNull IDependencyObject<Object> dataContext, @NotNull IDependencyObject<Boolean> visible, @NotNull IDependencyObject<Boolean> enabled, @NotNull IDependencyObject<IIdentifier> normalBackgroundImageResource, @NotNull IDependencyObject<IIdentifier> clickedBackgroundImageResource, @NotNull IDependencyObject<IIdentifier> disabledBackgroundImageResource, @NotNull IDependencyObject<Boolean> clicked) {
        super(Constants.Controls.Button.KEY_BUTTON, styleId, id, parent, alignments, dock, margin, elementSize, padding, dataContext, visible, enabled);
        this.normalBackgroundImageResource = normalBackgroundImageResource;
        this.clickedBackgroundImageResource = clickedBackgroundImageResource;
        this.disabledBackgroundImageResource = disabledBackgroundImageResource;
        this.clicked = clicked;
    }

    public void update(@NotNull IUpdateManager updateManager) {
        super.update(updateManager);
        if (this.normalBackgroundImageResource.hasChanged(this.getDataContext())) {
            updateManager.markDirty();
        }
        if (this.clickedBackgroundImageResource.hasChanged(this.getDataContext())) {
            updateManager.markDirty();
        }
        if (this.disabledBackgroundImageResource.hasChanged(this.getDataContext())) {
            updateManager.markDirty();
        }
        if (this.clicked.hasChanged(this.getDataContext())) {
            updateManager.markDirty();
        }
    }

    public void drawBackground(@NotNull IRenderingController controller) {
        if (!this.isVisible()) {
            return;
        }
        if (!this.isEnabled()) {
            this.drawBackground(controller, this::getDisabledBackgroundImage);
        } else if (this.isClicked()) {
            this.drawBackground(controller, this::getClickedBackgroundImage);
        } else {
            this.drawBackground(controller, this::getNormalBackgroundImage);
        }
    }

    private void drawBackground(@NotNull IRenderingController controller, Supplier<ImageResource> resourceSupplier) {
        ImageResource resource = resourceSupplier.get();
        Vector2d size = this.getLocalBoundingBox().getSize();
        IOpenGl.pushMatrix();
        controller.bindTexture(resource.getDiskLocation());
        controller.drawTexturedModalRect(new Vector2d(), size, resource.getOffset(), resource.getSize(), resource.getFileSize());
        IOpenGl.popMatrix();
    }

    @NotNull
    public ImageResource getDisabledBackgroundImage() {
        return (ImageResource)this.getResource(this.getDisabledBackgroundImageResource());
    }

    public boolean isClicked() {
        return (Boolean)this.clicked.get((IDependencyReceiver)this);
    }

    public void setClicked(@NotNull boolean clicked) {
        boolean currentClickState = this.isClicked();
        this.clicked.set((IDependencyReceiver)this, (Object)clicked);
        if (currentClickState != clicked) {
            this.getUiManager().getUpdateManager().markDirty();
        }
    }

    @NotNull
    public ImageResource getClickedBackgroundImage() {
        return (ImageResource)this.getResource(this.getClickedBackgroundImageResource());
    }

    @NotNull
    public ImageResource getNormalBackgroundImage() {
        return (ImageResource)this.getResource(this.getNormalBackgroundImageResource());
    }

    @NotNull
    public IIdentifier getDisabledBackgroundImageResource() {
        return (IIdentifier)this.disabledBackgroundImageResource.get((IDependencyReceiver)this);
    }

    @NotNull
    public IIdentifier getClickedBackgroundImageResource() {
        return (IIdentifier)this.clickedBackgroundImageResource.get((IDependencyReceiver)this);
    }

    @NotNull
    public IIdentifier getNormalBackgroundImageResource() {
        return (IIdentifier)this.normalBackgroundImageResource.get((IDependencyReceiver)this);
    }

    public void setNormalBackgroundImageResource(@NotNull IIdentifier normalBackgroundImage) {
        this.normalBackgroundImageResource.set((IDependencyReceiver)this, (Object)normalBackgroundImage);
    }

    public void setClickedBackgroundImageResource(@NotNull IIdentifier clickedBackgroundImage) {
        this.clickedBackgroundImageResource.set((IDependencyReceiver)this, (Object)clickedBackgroundImage);
    }

    public void setDisabledBackgroundImageResource(@NotNull IIdentifier disabledBackgroundImage) {
        this.disabledBackgroundImageResource.set((IDependencyReceiver)this, (Object)disabledBackgroundImage);
    }

    public void drawForeground(@NotNull IRenderingController controller) {
    }

    public boolean canAcceptMouseInput(int localX, int localY, MouseButton button) {
        return this.isEnabled() && this.isVisible();
    }

    public void onMouseClickBegin(int localX, int localY, MouseButton button) {
        this.setClicked(true);
        this.onClicked.raise((Object)this, (Object)new ButtonClickedEventArgs(true, localX, localY, button));
    }

    public void onMouseClickEnd(int localX, int localY, MouseButton button) {
        this.setClicked(false);
        this.onClicked.raise((Object)this, (Object)new ButtonClickedEventArgs(false, localX, localY, button));
    }

    public void onMouseClickMove(int localX, int localY, MouseButton button, float timeElapsed) {
        this.setClicked(true);
        this.onClicked.raise((Object)this, (Object)new ButtonClickedEventArgs(true, localX, localY, button, timeElapsed));
    }

    public Predicate<IUIElement> IsValidChildPredicate() {
        return iuiElement -> !(iuiElement instanceof IClickAcceptingUIElement);
    }

    public static class ButtonClickedEventArgs {
        private final boolean start;
        private final int localX;
        private final int localY;
        private final MouseButton button;
        private final float timeDelta;

        public ButtonClickedEventArgs(boolean start, int localX, int localY, MouseButton button) {
            this.start = start;
            this.localX = localX;
            this.localY = localY;
            this.button = button;
            this.timeDelta = 0.0f;
        }

        public ButtonClickedEventArgs(boolean start, int localX, int localY, MouseButton button, float timeDelta) {
            this.start = start;
            this.localX = localX;
            this.localY = localY;
            this.button = button;
            this.timeDelta = timeDelta;
        }

        public boolean isStart() {
            return this.start;
        }

        public int getLocalX() {
            return this.localX;
        }

        public int getLocalY() {
            return this.localY;
        }

        public MouseButton getButton() {
            return this.button;
        }

        public float getTimeDelta() {
            return this.timeDelta;
        }
    }

    public static class Factory
    extends AbstractChildrenContainingUIElement.AbstractChildrenContainingUIElementFactory<Button> {
        public Factory() {
            super(Button.class, Constants.Controls.Button.KEY_BUTTON, (elementData, engine, id, parent, styleId, alignments, dock, margin, padding, elementSize, dataContext, visible, enabled) -> {
                IDependencyObject defaultBackgroundImage = elementData.getFromRawDataWithDefault("defaultBackgroundImage", engine, (Object)IIdentifier.create((String)"minecraft:missingno"), IIdentifier.class, new Object[0]);
                IDependencyObject clickedBackgroundImage = elementData.getFromRawDataWithDefault("clickedBackgroundImage", engine, (Object)IIdentifier.create((String)"minecraft:missingno"), IIdentifier.class, new Object[0]);
                IDependencyObject disabledBackgroundImage = elementData.getFromRawDataWithDefault("disabledBackgroundImage", engine, (Object)IIdentifier.create((String)"minecraft:missingno"), IIdentifier.class, new Object[0]);
                IDependencyObject clicked = elementData.getFromRawDataWithDefault("clicked", engine, (Object)false, Boolean.class, new Object[0]);
                Button element = new Button(id, parent, (IDependencyObject<IIdentifier>)styleId, (IDependencyObject<EnumSet<Alignment>>)alignments, (IDependencyObject<Dock>)dock, (IDependencyObject<AxisDistance>)margin, (IDependencyObject<AxisDistance>)padding, (IDependencyObject<Vector2d>)elementSize, (IDependencyObject<Object>)dataContext, (IDependencyObject<Boolean>)visible, (IDependencyObject<Boolean>)enabled, (IDependencyObject<IIdentifier>)defaultBackgroundImage, (IDependencyObject<IIdentifier>)clickedBackgroundImage, (IDependencyObject<IIdentifier>)disabledBackgroundImage, (IDependencyObject<Boolean>)clicked);
                return element;
            }, (element, builder) -> builder.addComponent("defaultBackgroundImage", (Object)element.getNormalBackgroundImageResource(), IIdentifier.class).addComponent("disabledBackgroundImage", (Object)element.getDisabledBackgroundImageResource(), IIdentifier.class).addComponent("clickedBackgroundImage", (Object)element.getClickedBackgroundImageResource(), IIdentifier.class).addComponent("clicked", (Object)element.isClicked(), Boolean.class));
        }
    }

    public static class ButtonConstructionDataBuilder
    extends AbstractChildrenContainingUIElement.SimpleControlConstructionDataBuilder<ButtonConstructionDataBuilder, Button> {
        public ButtonConstructionDataBuilder(String controlId, IBlockOutGuiConstructionDataBuilder data) {
            super(controlId, data, Button.class);
        }

        @NotNull
        public ButtonConstructionDataBuilder withNormalBackgroundImageResource(@NotNull IDependencyObject<IIdentifier> normalBackgroundImageResource) {
            return (ButtonConstructionDataBuilder)this.withDependency("normalBackgroundImageResource", normalBackgroundImageResource);
        }

        @NotNull
        public ButtonConstructionDataBuilder withNormalBackgroundImageResource(@NotNull IIdentifier normalBackgroundImageResource) {
            return (ButtonConstructionDataBuilder)this.withDependency("normalBackgroundImageResource", DependencyObjectHelper.createFromValue((Object)normalBackgroundImageResource));
        }

        @NotNull
        public ButtonConstructionDataBuilder withClickedBackgroundImageResource(@NotNull IDependencyObject<IIdentifier> clickedBackgroundImageResource) {
            return (ButtonConstructionDataBuilder)this.withDependency("clickedBackgroundImageResource", clickedBackgroundImageResource);
        }

        @NotNull
        public ButtonConstructionDataBuilder withClickedBackgroundImageResource(@NotNull IIdentifier clickedBackgroundImageResource) {
            return (ButtonConstructionDataBuilder)this.withDependency("clickedBackgroundImageResource", DependencyObjectHelper.createFromValue((Object)clickedBackgroundImageResource));
        }

        @NotNull
        public ButtonConstructionDataBuilder withDisabledBackgroundImageResource(@NotNull IDependencyObject<IIdentifier> disabledBackgroundImageResource) {
            return (ButtonConstructionDataBuilder)this.withDependency("disabledBackgroundImageResource", disabledBackgroundImageResource);
        }

        @NotNull
        public ButtonConstructionDataBuilder withDisabledBackgroundImageResource(@NotNull IIdentifier disabledBackgroundImageResource) {
            return (ButtonConstructionDataBuilder)this.withDependency("disabledBackgroundImageResource", DependencyObjectHelper.createFromValue((Object)disabledBackgroundImageResource));
        }

        @NotNull
        public ButtonConstructionDataBuilder withClickedEventHandler(@NotNull IEventHandler<Button, ButtonClickedEventArgs> eventHandler) {
            return (ButtonConstructionDataBuilder)this.withEventHandler("onClicked", ButtonClickedEventArgs.class, eventHandler);
        }
    }
}

