/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.blockout.element.simple;

import com.ldtteam.blockout.binding.dependency.DependencyObjectHelper;
import com.ldtteam.blockout.binding.dependency.IDependencyObject;
import com.ldtteam.blockout.binding.dependency.IDependencyReceiver;
import com.ldtteam.blockout.builder.core.builder.IBlockOutGuiConstructionDataBuilder;
import com.ldtteam.blockout.element.IUIElementHost;
import com.ldtteam.blockout.element.drawable.IDrawableUIElement;
import com.ldtteam.blockout.element.values.Alignment;
import com.ldtteam.blockout.element.values.AxisDistance;
import com.ldtteam.blockout.element.values.Dock;
import com.ldtteam.blockout.management.update.IUpdateManager;
import com.ldtteam.blockout.render.core.IRenderingController;
import com.ldtteam.blockout.util.Constants;
import com.ldtteam.blockout.util.math.Vector2d;
import com.ldtteam.blockout.utils.controlconstruction.element.core.AbstractSimpleUIElement;
import com.ldtteam.jvoxelizer.block.state.IBlockState;
import com.ldtteam.jvoxelizer.client.renderer.opengl.IOpenGl;
import com.ldtteam.jvoxelizer.util.identifier.IIdentifier;
import java.util.EnumSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BlockStateIcon
extends AbstractSimpleUIElement
implements IDrawableUIElement {
    @NotNull
    public IDependencyObject<IBlockState> blockState;

    public BlockStateIcon(@NotNull String id, @Nullable IUIElementHost parent, @NotNull IDependencyObject<IIdentifier> styleId, @NotNull IDependencyObject<EnumSet<Alignment>> alignments, @NotNull IDependencyObject<Dock> dock, @NotNull IDependencyObject<AxisDistance> margin, @NotNull IDependencyObject<Vector2d> elementSize, @NotNull IDependencyObject<Object> dataContext, @NotNull IDependencyObject<Boolean> visible, @NotNull IDependencyObject<Boolean> enabled, @NotNull IDependencyObject<IBlockState> blockState) {
        super(Constants.Controls.BlockStateIcon.KEY_BLOCKSTATE, styleId, id, parent, alignments, dock, margin, elementSize, dataContext, visible, enabled);
        this.blockState = blockState;
    }

    public void update(@NotNull IUpdateManager updateManager) {
        super.update(updateManager);
        if (this.blockState.hasChanged(this.getDataContext())) {
            updateManager.markDirty();
        }
    }

    public void drawBackground(@NotNull IRenderingController controller) {
        IOpenGl.pushMatrix();
        controller.drawBlockState(this.getBlockState(), 0, 0);
        IOpenGl.popMatrix();
    }

    @NotNull
    public IBlockState getBlockState() {
        return (IBlockState)this.blockState.get((IDependencyReceiver)this);
    }

    public void setBlockState(@NotNull IBlockState icon) {
        this.blockState.set((IDependencyReceiver)this, (Object)icon);
    }

    public void drawForeground(@NotNull IRenderingController controller) {
    }

    public static class Factory
    extends AbstractSimpleUIElement.AbstractSimpleUIElementFactory<BlockStateIcon> {
        public Factory() {
            super(BlockStateIcon.class, Constants.Controls.BlockStateIcon.KEY_BLOCKSTATE, (elementData, engine, id, parent, styleId, alignments, dock, margin, elementSize, dataContext, visible, enabled) -> {
                IDependencyObject blockState = elementData.getFromRawDataWithDefault("blockState", engine, (Object)IBlockState.defaultState(), IBlockState.class, new Object[0]);
                BlockStateIcon element = new BlockStateIcon(id, parent, (IDependencyObject<IIdentifier>)styleId, (IDependencyObject<EnumSet<Alignment>>)alignments, (IDependencyObject<Dock>)dock, (IDependencyObject<AxisDistance>)margin, (IDependencyObject<Vector2d>)elementSize, (IDependencyObject<Object>)dataContext, (IDependencyObject<Boolean>)visible, (IDependencyObject<Boolean>)enabled, (IDependencyObject<IBlockState>)blockState);
                return element;
            }, (element, builder) -> builder.addComponent("blockState", (Object)element.getBlockState(), IBlockState.class));
        }
    }

    public static class BlockStateIconConstructionDataBuilder
    extends AbstractSimpleUIElement.SimpleControlConstructionDataBuilder<BlockStateIconConstructionDataBuilder, BlockStateIcon> {
        public BlockStateIconConstructionDataBuilder(String controlId, IBlockOutGuiConstructionDataBuilder data) {
            super(controlId, data, BlockStateIcon.class);
        }

        @NotNull
        public BlockStateIconConstructionDataBuilder withDependentBlockState(@NotNull IDependencyObject<IBlockState> blockState) {
            return (BlockStateIconConstructionDataBuilder)this.withDependency("blockState", blockState);
        }

        @NotNull
        public BlockStateIconConstructionDataBuilder withBlockState(@NotNull IBlockState blockState) {
            return (BlockStateIconConstructionDataBuilder)this.withDependency("blockState", DependencyObjectHelper.createFromValue((Object)blockState));
        }
    }
}

