/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.blockout.element.advanced.list;

import com.ldtteam.blockout.binding.dependency.IDependencyObject;
import com.ldtteam.blockout.binding.dependency.IDependencyReceiver;
import com.ldtteam.blockout.element.IUIElementHost;
import com.ldtteam.blockout.element.advanced.AbstractChildInstantiatingAndLayoutControllableUIElement;
import com.ldtteam.blockout.element.drawable.IDrawableUIElement;
import com.ldtteam.blockout.element.input.IClickAcceptingUIElement;
import com.ldtteam.blockout.element.input.IScrollAcceptingUIElement;
import com.ldtteam.blockout.element.values.Alignment;
import com.ldtteam.blockout.element.values.AxisDistance;
import com.ldtteam.blockout.element.values.Dock;
import com.ldtteam.blockout.element.values.Orientation;
import com.ldtteam.blockout.render.core.IRenderingController;
import com.ldtteam.blockout.style.resources.ImageResource;
import com.ldtteam.blockout.util.Constants;
import com.ldtteam.blockout.util.math.BoundingBox;
import com.ldtteam.blockout.util.math.Vector2d;
import com.ldtteam.blockout.util.mouse.MouseButton;
import com.ldtteam.jvoxelizer.client.renderer.opengl.IOpenGl;
import com.ldtteam.jvoxelizer.client.renderer.opengl.util.DestinationFactor;
import com.ldtteam.jvoxelizer.client.renderer.opengl.util.SourceFactor;
import com.ldtteam.jvoxelizer.util.identifier.IIdentifier;
import java.util.EnumSet;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class List
extends AbstractChildInstantiatingAndLayoutControllableUIElement
implements IScrollAcceptingUIElement,
IClickAcceptingUIElement,
IDrawableUIElement {
    private static final int CONST_SCROLLBAR_SIZE = 5;
    private static final int CONST_SCROLLBAR_PADDING = 8;
    public IDependencyObject<IIdentifier> scrollBarBackgroundResource;
    public IDependencyObject<IIdentifier> scrollBarForegroundResource;
    public IDependencyObject<Boolean> showScrollbar;

    public List(@NotNull String id, @Nullable IUIElementHost parent, @NotNull IDependencyObject<IIdentifier> styleId, @NotNull IDependencyObject<EnumSet<Alignment>> alignments, @NotNull IDependencyObject<Dock> dock, @NotNull IDependencyObject<AxisDistance> margin, @NotNull IDependencyObject<AxisDistance> padding, @NotNull IDependencyObject<Vector2d> elementSize, @NotNull IDependencyObject<Object> dataContext, @NotNull IDependencyObject<Boolean> visible, @NotNull IDependencyObject<Boolean> enabled, @NotNull boolean dataBoundMode, @NotNull IDependencyObject<IIdentifier> templateResource, @NotNull IDependencyObject<IIdentifier> scrollBarBackgroundResource, @NotNull IDependencyObject<IIdentifier> scrollBarForegroundResource, @NotNull double scrollOffset, @NotNull IDependencyObject<Orientation> orientation, @NotNull IDependencyObject<Boolean> showScrollbar, @NotNull IDependencyObject<Object> source) {
        super(Constants.Controls.List.KEY_LIST, styleId, id, parent, alignments, dock, margin, elementSize, padding, dataContext, visible, enabled, scrollOffset, templateResource, source, dataBoundMode, orientation);
        this.scrollBarBackgroundResource = scrollBarBackgroundResource;
        this.scrollBarForegroundResource = scrollBarForegroundResource;
        this.showScrollbar = showScrollbar;
    }

    public AxisDistance getPadding() {
        double barLength;
        AxisDistance parentDistance = super.getPadding();
        if (this.getLocalBoundingBox() == null || this.values().stream().anyMatch(u -> u.getLocalBoundingBox() == null)) {
            return parentDistance;
        }
        if (this.getOrientation() == Orientation.TOP_BOTTOM) {
            double barLength2;
            double localHeight = this.getLocalBoundingBox().getSize().getY();
            double maxOffset = localHeight - (barLength2 = (double)this.getScrollBarLength());
            if (maxOffset < 1.0) {
                return parentDistance;
            }
            if (parentDistance.getRight().orElse(0.0) < 8.0) {
                return new AxisDistance(parentDistance.getLeft(), parentDistance.getTop(), Optional.of(8.0), parentDistance.getBottom());
            }
            return parentDistance;
        }
        double localWidth = this.getLocalBoundingBox().getSize().getX();
        double maxOffset = localWidth - (barLength = (double)this.getScrollBarLength());
        if (maxOffset < 1.0) {
            return parentDistance;
        }
        if (parentDistance.getBottom().orElse(0.0) < 8.0) {
            return new AxisDistance(parentDistance.getLeft(), parentDistance.getTop(), parentDistance.getRight(), Optional.of(8.0));
        }
        return parentDistance;
    }

    public boolean canAcceptMouseInput(int localX, int localY, MouseButton button) {
        BoundingBox localBox = this.getLocalBoundingBox();
        if (this.getOrientation() == Orientation.TOP_BOTTOM) {
            double offset = localBox.getSize().getX() - (double)localX;
            return offset <= 5.0;
        }
        double offset = localBox.getSize().getY() - (double)localY;
        return offset <= 5.0;
    }

    public void onMouseClickBegin(int localX, int localY, MouseButton button) {
        this.onScrollBarClick(localX, localY);
    }

    public void onMouseClickEnd(int localX, int localY, MouseButton button) {
        this.onScrollBarClick(localX, localY);
    }

    public void onMouseClickMove(int localX, int localY, MouseButton button, float timeElapsed) {
        this.onScrollBarClick(localX, localY);
    }

    private void onScrollBarClick(int localX, int localY) {
        if (this.getOrientation() == Orientation.TOP_BOTTOM) {
            double localHeight = this.getLocalBoundingBox().getSize().getY();
            double barHeight = this.getScrollBarLength();
            double maxOffset = localHeight - barHeight;
            this.scrollTo((double)localY / maxOffset);
        } else {
            double localWidth = this.getLocalBoundingBox().getSize().getX();
            double barWidth = this.getScrollBarLength();
            double maxOffset = localWidth - barWidth;
            this.scrollTo((double)localX / maxOffset);
        }
    }

    public void drawBackground(@NotNull IRenderingController controller) {
        if (!this.getShowScrollBar().booleanValue()) {
            return;
        }
        IOpenGl.pushMatrix();
        if (this.getOrientation() == Orientation.TOP_BOTTOM) {
            double barLength;
            double localHeight = this.getLocalBoundingBox().getSize().getY();
            double maxOffset = localHeight - (barLength = (double)this.getScrollBarLength());
            if (maxOffset < 1.0) {
                IOpenGl.popMatrix();
                return;
            }
            Vector2d scrollBoxOrigin = new Vector2d(this.getLocalBoundingBox().getSize().getX() - 5.0, 0.0).nullifyNegatives();
            Vector2d scrollBoxSize = new Vector2d(5.0, this.getLocalBoundingBox().getSize().getY());
            BoundingBox scrollBox = new BoundingBox(scrollBoxOrigin, scrollBoxSize);
            Vector2d scrollBarOrigin = new Vector2d(this.getLocalBoundingBox().getSize().getX() - 5.0, this.scrollOffset * maxOffset).nullifyNegatives();
            Vector2d scrollBarSize = new Vector2d(5.0, barLength);
            BoundingBox scrollBarBox = new BoundingBox(scrollBarOrigin, scrollBarSize);
            this.drawSrollbarBackground(controller, scrollBox);
            this.drawSrollbarForeground(controller, scrollBarBox);
        } else {
            double barLength;
            double localWidth = this.getLocalBoundingBox().getSize().getX();
            double maxOffset = localWidth - (barLength = (double)this.getScrollBarLength());
            if (maxOffset < 1.0) {
                IOpenGl.popMatrix();
                return;
            }
            Vector2d scrollBoxOrigin = new Vector2d(0.0, this.getLocalBoundingBox().getSize().getY() - 5.0).nullifyNegatives();
            Vector2d scrollBoxSize = new Vector2d(this.getLocalBoundingBox().getSize().getX(), 5.0);
            BoundingBox scrollBox = new BoundingBox(scrollBoxOrigin, scrollBoxSize);
            Vector2d scrollBarOrigin = new Vector2d(this.scrollOffset * maxOffset, this.getLocalBoundingBox().getSize().getY() - 5.0).nullifyNegatives();
            Vector2d scrollBarSize = new Vector2d(barLength, 5.0);
            BoundingBox scrollBarBox = new BoundingBox(scrollBarOrigin, scrollBarSize);
            this.drawSrollbarBackground(controller, scrollBox);
            this.drawSrollbarForeground(controller, scrollBarBox);
        }
        IOpenGl.popMatrix();
    }

    public void drawForeground(@NotNull IRenderingController controller) {
    }

    @NotNull
    public Boolean getShowScrollBar() {
        return (Boolean)this.showScrollbar.get((IDependencyReceiver)this);
    }

    private void drawSrollbarBackground(@NotNull IRenderingController controller, @NotNull BoundingBox scrollBox) {
        ImageResource resource = this.getScrollBarBackground();
        IOpenGl.pushMatrix();
        IOpenGl.enableAlpha();
        IOpenGl.enableBlend();
        IOpenGl.blendFunc((SourceFactor)SourceFactor.SRC_ALPHA, (DestinationFactor)DestinationFactor.ONE_MINUS_SRC_ALPHA);
        IOpenGl.color((float)1.0f, (float)1.0f, (float)1.0f);
        controller.bindTexture(resource.getDiskLocation());
        controller.drawTexturedModalRect(scrollBox.getLocalOrigin(), scrollBox.getSize(), resource.getOffset(), resource.getSize(), resource.getFileSize());
        IOpenGl.disableBlend();
        IOpenGl.disableAlpha();
        IOpenGl.popMatrix();
    }

    private void drawSrollbarForeground(@NotNull IRenderingController controller, @NotNull BoundingBox scrollBarBox) {
        ImageResource resource = this.getScrollBarForeground();
        IOpenGl.pushMatrix();
        IOpenGl.enableAlpha();
        IOpenGl.enableBlend();
        IOpenGl.blendFunc((SourceFactor)SourceFactor.SRC_ALPHA, (DestinationFactor)DestinationFactor.ONE_MINUS_SRC_ALPHA);
        IOpenGl.color((float)1.0f, (float)1.0f, (float)1.0f);
        controller.bindTexture(resource.getDiskLocation());
        controller.drawTexturedModalRect(scrollBarBox.getLocalOrigin(), scrollBarBox.getSize(), resource.getOffset(), resource.getSize(), resource.getFileSize());
        IOpenGl.disableBlend();
        IOpenGl.disableAlpha();
        IOpenGl.popMatrix();
    }

    @NotNull
    public ImageResource getScrollBarBackground() {
        return (ImageResource)this.getResource(this.getScrollBarBackgroundResource());
    }

    @NotNull
    public ImageResource getScrollBarForeground() {
        return (ImageResource)this.getResource(this.getScrollBarForegroundResource());
    }

    @NotNull
    public IIdentifier getScrollBarBackgroundResource() {
        return (IIdentifier)this.scrollBarBackgroundResource.get((IDependencyReceiver)this);
    }

    public void setScrollBarBackgroundResource(@NotNull IIdentifier scrollBarBackground) {
        this.scrollBarBackgroundResource.set((IDependencyReceiver)this, (Object)scrollBarBackground);
    }

    @NotNull
    public IIdentifier getScrollBarForegroundResource() {
        return (IIdentifier)this.scrollBarForegroundResource.get((IDependencyReceiver)this);
    }

    public void setScrollBarForegroundResource(@NotNull IIdentifier scrollBarForeground) {
        this.scrollBarForegroundResource.set((IDependencyReceiver)this, (Object)scrollBarForeground);
    }

    public void setShowScrollbar(@NotNull Boolean showScrollbar) {
        this.showScrollbar.set((IDependencyReceiver)this, (Object)showScrollbar);
    }

    public boolean canAcceptScrollInput(int localX, int localY, int deltaWheel) {
        double barLength;
        if (this.getLocalBoundingBox() == null || this.values().stream().anyMatch(u -> u.getLocalBoundingBox() == null)) {
            return false;
        }
        if (this.getOrientation() == Orientation.TOP_BOTTOM) {
            double barLength2;
            double localHeight = this.getLocalBoundingBox().getSize().getY();
            double maxOffset = localHeight - (barLength2 = (double)this.getScrollBarLength());
            return !(maxOffset < 1.0);
        }
        double localWidth = this.getLocalBoundingBox().getSize().getX();
        double maxOffset = localWidth - (barLength = (double)this.getScrollBarLength());
        return !(maxOffset < 1.0);
    }

    public void onMouseScroll(int localX, int localY, int deltaWheel) {
        this.scroll((double)deltaWheel / this.getTotalContentLength() / -10.0);
    }
}

