/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.blockout.element.advanced;

import com.ldtteam.blockout.binding.dependency.DependencyObjectHelper;
import com.ldtteam.blockout.binding.dependency.IDependencyObject;
import com.ldtteam.blockout.binding.dependency.IDependencyReceiver;
import com.ldtteam.blockout.binding.dependency.injection.DependencyObjectInjector;
import com.ldtteam.blockout.binding.dependency.injection.IDependencyDataProvider;
import com.ldtteam.blockout.builder.core.IBlockOutGuiConstructionData;
import com.ldtteam.blockout.builder.core.builder.IBlockOutGuiConstructionDataBuilder;
import com.ldtteam.blockout.builder.data.BlockOutGuiConstructionData;
import com.ldtteam.blockout.element.IUIElement;
import com.ldtteam.blockout.element.IUIElementHost;
import com.ldtteam.blockout.element.values.Alignment;
import com.ldtteam.blockout.element.values.AxisDistance;
import com.ldtteam.blockout.element.values.Dock;
import com.ldtteam.blockout.event.injector.EventHandlerInjector;
import com.ldtteam.blockout.event.injector.IEventHandlerProvider;
import com.ldtteam.blockout.management.update.IUpdateManager;
import com.ldtteam.blockout.proxy.ProxyHolder;
import com.ldtteam.blockout.util.Constants;
import com.ldtteam.blockout.util.math.Vector2d;
import com.ldtteam.blockout.utils.controlconstruction.element.core.AbstractChildrenContainingUIElement;
import com.ldtteam.jvoxelizer.util.identifier.IIdentifier;
import java.util.EnumSet;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TemplateInstance
extends AbstractChildrenContainingUIElement {
    public IDependencyObject<IIdentifier> templateResource;
    public IDependencyObject<IBlockOutGuiConstructionData> templateConstructionData;

    public TemplateInstance(@NotNull String id, @Nullable IUIElementHost parent, @NotNull IDependencyObject<IIdentifier> styleId, @NotNull IDependencyObject<EnumSet<Alignment>> alignments, @NotNull IDependencyObject<Dock> dock, @NotNull IDependencyObject<AxisDistance> margin, @NotNull IDependencyObject<AxisDistance> padding, @NotNull IDependencyObject<Vector2d> elementSize, @NotNull IDependencyObject<Object> dataContext, @NotNull IDependencyObject<Boolean> visible, @NotNull IDependencyObject<Boolean> enabled, @NotNull IDependencyObject<IIdentifier> templateResource) {
        super(Constants.Controls.TemplateInstance.KEY_TEMPLATE_INSTANCE, styleId, id, parent, alignments, dock, margin, elementSize, padding, dataContext, visible, enabled);
        this.templateResource = templateResource;
        this.templateConstructionData = DependencyObjectHelper.createFromValue((Object)new BlockOutGuiConstructionData());
    }

    public TemplateInstance(@NotNull IDependencyObject<IIdentifier> style, @NotNull String id, @Nullable IUIElementHost parent, @NotNull IDependencyObject<IBlockOutGuiConstructionData> templateConstructionData) {
        super(Constants.Controls.TemplateInstance.KEY_TEMPLATE_INSTANCE, style, id, parent);
        this.templateResource = DependencyObjectHelper.createFromValue((Object)IIdentifier.create((String)"minecraft:missingno"));
        this.templateConstructionData = DependencyObjectHelper.createFromValue((Object)new BlockOutGuiConstructionData());
    }

    public Vector2d getMinimalContentSize() {
        this.getParent().getUiManager().getProfiler().startSection("Template minimal content size: " + this.getId());
        Vector2d currentElementSize = this.getElementSize();
        if (currentElementSize.getX() != 0.0 && currentElementSize.getY() != 0.0) {
            this.getParent().getUiManager().getProfiler().endSection();
            return currentElementSize;
        }
        this.getParent().getUiManager().getProfiler().startSection("Template instantiation for content size.");
        this.update(this.getParent().getUiManager().getUpdateManager());
        this.getParent().getUiManager().getProfiler().endSection();
        this.getParent().getUiManager().getProfiler().endSection();
        return super.getMinimalContentSize();
    }

    public void update(@NotNull IUpdateManager updateManager) {
        super.update(updateManager);
        this.getParent().getUiManager().getProfiler().startSection("Template instantiation");
        if (this.templateResource.hasChanged(this.getDataContext())) {
            this.getParent().getUiManager().getProfiler().startSection("Template instance creation.");
            updateManager.markDirty();
            this.clear();
            IIdentifier resolvedTemplateResource = this.getTemplateResource();
            IUIElement element = ProxyHolder.getInstance().getTemplateEngine().generateFromTemplate((IUIElementHost)this, DependencyObjectHelper.createFromGetterOnly(Function.identity(), (Object)new Object()), resolvedTemplateResource, this.getId() + "_instance");
            if (this.getTemplateConstructionData() != null) {
                IBlockOutGuiConstructionData data = this.getTemplateConstructionData();
                DependencyObjectInjector.inject((IDependencyReceiver)element, (IDependencyDataProvider)data);
                EventHandlerInjector.inject((IUIElement)element, (IEventHandlerProvider)data);
                if (element instanceof IUIElementHost) {
                    IUIElementHost iuiElementHost = (IUIElementHost)element;
                    iuiElementHost.getAllCombinedChildElements().values().forEach(c -> {
                        DependencyObjectInjector.inject((IDependencyReceiver)c, (IDependencyDataProvider)data);
                        EventHandlerInjector.inject((IUIElement)c, (IEventHandlerProvider)data);
                    });
                }
            }
            this.put(element.getId(), element);
            this.getParent().getUiManager().getProfiler().endSection();
        }
        this.getParent().getUiManager().getProfiler().endSection();
    }

    public IBlockOutGuiConstructionData getTemplateConstructionData() {
        return (IBlockOutGuiConstructionData)this.templateConstructionData.get((IDependencyReceiver)this);
    }

    public void setTemplateConstructionData(@NotNull IBlockOutGuiConstructionData templateConstructionData) {
        this.templateConstructionData.set((IDependencyReceiver)this, (Object)templateConstructionData);
    }

    public IIdentifier getTemplateResource() {
        return (IIdentifier)this.templateResource.get((IDependencyReceiver)this);
    }

    public void setTemplateResource(@NotNull IIdentifier templateResource) {
        this.templateResource.set((IDependencyReceiver)this, (Object)templateResource);
    }

    public static final class Factory
    extends AbstractChildrenContainingUIElement.AbstractChildrenContainingUIElementFactory<TemplateInstance> {
        public Factory() {
            super(TemplateInstance.class, Constants.Controls.TemplateInstance.KEY_TEMPLATE_INSTANCE, (elementData, engine, id, parent, styleId, alignments, dock, margin, padding, elementSize, dataContext, visible, enabled) -> {
                IDependencyObject templateResource = elementData.getFromRawDataWithDefault("template", engine, (Object)IIdentifier.create((String)"minecraft:missingno"), IIdentifier.class, new Object[0]);
                TemplateInstance element = new TemplateInstance(id, parent, (IDependencyObject<IIdentifier>)styleId, (IDependencyObject<EnumSet<Alignment>>)alignments, (IDependencyObject<Dock>)dock, (IDependencyObject<AxisDistance>)margin, (IDependencyObject<AxisDistance>)padding, (IDependencyObject<Vector2d>)elementSize, (IDependencyObject<Object>)dataContext, (IDependencyObject<Boolean>)visible, (IDependencyObject<Boolean>)enabled, (IDependencyObject<IIdentifier>)templateResource);
                if (elementData.getMetaData().hasChildren()) {
                    templateResource.get((IDependencyReceiver)element);
                }
                return element;
            }, (element, builder) -> builder.addComponent("template", (Object)element.getTemplateResource(), IIdentifier.class));
        }
    }

    public static final class TemplateInstanceConstructionDataBuilder
    extends AbstractChildrenContainingUIElement.SimpleControlConstructionDataBuilder<TemplateInstanceConstructionDataBuilder, TemplateInstance> {
        public TemplateInstanceConstructionDataBuilder(String controlId, IBlockOutGuiConstructionDataBuilder data) {
            super(controlId, data, TemplateInstance.class);
        }

        @NotNull
        public TemplateInstanceConstructionDataBuilder withDependentTemplateResource(@NotNull IDependencyObject<IIdentifier> iconResource) {
            return (TemplateInstanceConstructionDataBuilder)this.withDependency("templateResource", iconResource);
        }

        @NotNull
        public TemplateInstanceConstructionDataBuilder withTemplateResource(@NotNull IIdentifier iconResource) {
            return (TemplateInstanceConstructionDataBuilder)this.withDependency("templateResource", DependencyObjectHelper.createFromValue((Object)iconResource));
        }
    }
}

