/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.blockout.element.advanced;

import com.google.common.collect.Lists;
import com.ldtteam.blockout.binding.dependency.DependencyObjectHelper;
import com.ldtteam.blockout.binding.dependency.IDependencyObject;
import com.ldtteam.blockout.binding.dependency.IDependencyReceiver;
import com.ldtteam.blockout.binding.dependency.injection.DependencyObjectInjector;
import com.ldtteam.blockout.binding.dependency.injection.IDependencyDataProvider;
import com.ldtteam.blockout.binding.property.Property;
import com.ldtteam.blockout.binding.property.PropertyCreationHelper;
import com.ldtteam.blockout.builder.core.IBlockOutGuiConstructionData;
import com.ldtteam.blockout.builder.data.BlockOutGuiConstructionData;
import com.ldtteam.blockout.element.IUIElement;
import com.ldtteam.blockout.element.IUIElementHost;
import com.ldtteam.blockout.element.drawable.IChildDrawableUIElement;
import com.ldtteam.blockout.element.simple.Region;
import com.ldtteam.blockout.element.values.Alignment;
import com.ldtteam.blockout.element.values.AxisDistance;
import com.ldtteam.blockout.element.values.AxisDistanceBuilder;
import com.ldtteam.blockout.element.values.Dock;
import com.ldtteam.blockout.element.values.Orientation;
import com.ldtteam.blockout.event.injector.EventHandlerInjector;
import com.ldtteam.blockout.event.injector.IEventHandlerProvider;
import com.ldtteam.blockout.loader.binding.core.IBindingEngine;
import com.ldtteam.blockout.loader.core.IUIElementData;
import com.ldtteam.blockout.management.render.IRenderManager;
import com.ldtteam.blockout.management.update.IUpdateManager;
import com.ldtteam.blockout.proxy.ProxyHolder;
import com.ldtteam.blockout.util.Log;
import com.ldtteam.blockout.util.math.BoundingBox;
import com.ldtteam.blockout.util.math.Clamp;
import com.ldtteam.blockout.util.math.Vector2d;
import com.ldtteam.blockout.utils.controlconstruction.element.core.AbstractChildrenContainingUIElement;
import com.ldtteam.blockout.utils.controlconstruction.element.core.AbstractSimpleUIElement;
import com.ldtteam.jvoxelizer.util.identifier.IIdentifier;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractChildInstantiatingAndLayoutControllableUIElement
extends AbstractChildrenContainingUIElement
implements IChildDrawableUIElement {
    public IDependencyObject<IIdentifier> templateResource;
    public IDependencyObject<IBlockOutGuiConstructionData> templateConstructionData;
    public IDependencyObject<Object> source;
    public IDependencyObject<Orientation> orientation;
    protected double scrollOffset;
    protected boolean dataBoundMode;

    public AbstractChildInstantiatingAndLayoutControllableUIElement(String type, IDependencyObject<IIdentifier> style, String id, IUIElementHost parent, IDependencyObject<EnumSet<Alignment>> alignments, IDependencyObject<Dock> dock, IDependencyObject<AxisDistance> margin, IDependencyObject<Vector2d> elementSize, IDependencyObject<AxisDistance> padding, IDependencyObject<Object> dataContext, IDependencyObject<Boolean> visible, IDependencyObject<Boolean> enabled, @NotNull double scrollOffset, @NotNull IDependencyObject<IIdentifier> templateResource, @NotNull IDependencyObject<Object> source, @NotNull boolean dataBoundMode, @NotNull IDependencyObject<Orientation> orientation) {
        super(type, style, id, parent, alignments, dock, margin, elementSize, padding, dataContext, visible, enabled);
        this.scrollOffset = scrollOffset;
        this.templateResource = templateResource;
        this.templateConstructionData = DependencyObjectHelper.createFromValue((Object)new BlockOutGuiConstructionData());
        this.source = source;
        this.dataBoundMode = dataBoundMode;
        this.orientation = orientation;
    }

    public void update(@NotNull IUpdateManager updateManager) {
        super.update(updateManager);
        if (!this.dataBoundMode) {
            return;
        }
        this.updateChildrenInDataBoundMode(updateManager);
    }

    public void preBackgroundDrawOfChildren(@NotNull IRenderManager manager) {
        manager.getRenderingController().getScissoringController().push(this.getAbsoluteInternalBoundingBox());
    }

    public void postBackgroundDrawOfChildren(@NotNull IRenderManager manager) {
        manager.getRenderingController().getScissoringController().pop();
    }

    public void preForegroundDrawOfChildren(@NotNull IRenderManager manager) {
        manager.getRenderingController().getScissoringController().push(this.getAbsoluteInternalBoundingBox());
    }

    public void postForegroundDrawOfChildren(@NotNull IRenderManager manager) {
        manager.getRenderingController().getScissoringController().pop();
    }

    public IBlockOutGuiConstructionData getTemplateConstructionData() {
        return (IBlockOutGuiConstructionData)this.templateConstructionData.get((IDependencyReceiver)this);
    }

    public void setTemplateConstructionData(@NotNull IBlockOutGuiConstructionData templateConstructionData) {
        this.templateConstructionData.set((IDependencyReceiver)this, (Object)templateConstructionData);
    }

    private void updateChildrenInDataBoundMode(@NotNull IUpdateManager updateManager) {
        if (!(this.source.hasChanged(this.getDataContext()) || this.templateResource.hasChanged(this.getDataContext()) || this.templateConstructionData.hasChanged(this.getDataContext()))) {
            return;
        }
        Object newDataContext = this.source.get((IDependencyReceiver)this);
        Collection newData = newDataContext instanceof Collection ? (Collection)newDataContext : Lists.newArrayList();
        updateManager.markDirty();
        this.clear();
        int index = 0;
        for (Object context : newData) {
            IUIElement element = ProxyHolder.getInstance().getTemplateEngine().generateFromTemplate((IUIElementHost)this, DependencyObjectHelper.createFromValue(context), this.getTemplateResource(), String.format("%s_%d", this.getId(), index++));
            if (this.getTemplateConstructionData() != null) {
                IBlockOutGuiConstructionData data = this.getTemplateConstructionData();
                DependencyObjectInjector.inject((IDependencyReceiver)element, (IDependencyDataProvider)data);
                EventHandlerInjector.inject((IUIElement)element, (IEventHandlerProvider)data);
                if (element instanceof IUIElementHost) {
                    IUIElementHost iuiElementHost = (IUIElementHost)element;
                    iuiElementHost.getAllCombinedChildElements().values().forEach(c -> {
                        DependencyObjectInjector.inject((IDependencyReceiver)c, (IDependencyDataProvider)data);
                        EventHandlerInjector.inject((IUIElement)c, (IEventHandlerProvider)data);
                    });
                }
            }
            this.wrapNewElementAndRegister(element);
        }
        this.updateScrollOffset();
    }

    public IIdentifier getTemplateResource() {
        return (IIdentifier)this.templateResource.get((IDependencyReceiver)this);
    }

    public void setTemplateResource(@NotNull IIdentifier templateResource) {
        this.templateResource.set((IDependencyReceiver)this, (Object)templateResource);
        this.dataBoundMode = true;
        this.updateChildrenInDataBoundMode(this.getUiManager().getUpdateManager());
    }

    public boolean isDataBoundMode() {
        return this.dataBoundMode;
    }

    public void setDataBoundMode(boolean dataBoundMode) {
        this.dataBoundMode = dataBoundMode;
    }

    public void scroll(double delta) {
        double newScrollOffset = this.scrollOffset + delta;
        this.scrollTo(newScrollOffset);
    }

    public void scrollTo(double target) {
        this.scrollOffset = Clamp.Clamp((double)0.0, (double)target, (double)1.0);
        this.updateScrollOffset();
        this.getParent().getUiManager().getUpdateManager().markDirty();
    }

    protected boolean updateScrollOffset() {
        double maxOffset;
        Orientation currentOrientation = this.getOrientation();
        boolean requiresUpdate = false;
        double d = maxOffset = currentOrientation == Orientation.TOP_BOTTOM ? (this.getTotalContentLength() - this.getLocalInternalBoundingBox().getSize().getY()) * this.scrollOffset : (this.getTotalContentLength() - this.getLocalInternalBoundingBox().getSize().getX()) * this.scrollOffset;
        if (maxOffset <= 0.0) {
            maxOffset = 0.0;
        }
        double currentUsedOffset = 0.0;
        Iterator iterator = this.values().iterator();
        while (iterator.hasNext()) {
            IUIElement wrapper;
            AxisDistance newMargin = currentOrientation == Orientation.TOP_BOTTOM ? new AxisDistanceBuilder().setLeft(Optional.of(0.0)).setRight(Optional.of(0.0)).setTop(Optional.of(-maxOffset + currentUsedOffset)).build() : new AxisDistanceBuilder().setLeft(Optional.of(-maxOffset + currentUsedOffset)).setTop(Optional.of(0.0)).setBottom(Optional.of(0.0)).build();
            if (!newMargin.equals((Object)(wrapper = (IUIElement)iterator.next()).getMargin())) {
                requiresUpdate = true;
            }
            wrapper.setMargin(newMargin);
            wrapper.update(this.getParent().getUiManager().getUpdateManager());
            currentUsedOffset += currentOrientation == Orientation.TOP_BOTTOM ? wrapper.getElementSize().getY() : wrapper.getElementSize().getX();
        }
        if (requiresUpdate && this.isVisible()) {
            this.values().stream().forEach(e -> e.setVisible(this.getAbsoluteInternalBoundingBox().intersects(e.getAbsoluteBoundingBox())));
        }
        return requiresUpdate;
    }

    @NotNull
    public Orientation getOrientation() {
        Orientation orientation = (Orientation)this.orientation.get((IDependencyReceiver)this);
        if (orientation != Orientation.TOP_BOTTOM && orientation != Orientation.LEFT_RIGHT) {
            Log.getLogger().error("Failed to get valid Orientation for list: " + this.getId() + " current: " + orientation + " Valid are: TOP_BOTTOM, LEFT_RIGHT.");
            this.setOrientation(Orientation.TOP_BOTTOM);
            return Orientation.TOP_BOTTOM;
        }
        return orientation;
    }

    public void setOrientation(@NotNull Orientation orientation) {
        this.orientation.set((IDependencyReceiver)this, (Object)orientation);
    }

    protected double getTotalContentLength() {
        if (this.getOrientation() == Orientation.TOP_BOTTOM) {
            return this.values().stream().mapToDouble(u -> u.getLocalBoundingBox().getSize().getY()).sum();
        }
        return this.values().stream().mapToDouble(u -> u.getLocalBoundingBox().getSize().getX()).sum();
    }

    protected int getScrollBarLength() {
        BoundingBox localBox = this.getLocalBoundingBox();
        double contentLength = this.getTotalContentLength();
        if (this.getOrientation() == Orientation.TOP_BOTTOM) {
            return (int)Math.min(localBox.getSize().getY(), localBox.getSize().getY() / contentLength * localBox.getSize().getY());
        }
        return (int)Math.min(localBox.getSize().getX(), localBox.getSize().getX() / contentLength * localBox.getSize().getX());
    }

    protected boolean stretchElementDuringWrapping() {
        return true;
    }

    protected void wrapNewElementAndRegister(final @NotNull IUIElement element) {
        Region wrappingRegion = new Region((IDependencyObject<IIdentifier>)DependencyObjectHelper.createFromValue((Object)this.getStyleId()), String.format("%s_wrapper", element.getId()), (IUIElementHost)this);
        if (this.stretchElementDuringWrapping()) {
            DependencyObjectInjector.inject((IDependencyReceiver)wrappingRegion, (IDependencyDataProvider)new IDependencyDataProvider(){

                public boolean hasDependencyData(@NotNull String name) {
                    return name.contains("elementSize");
                }

                @NotNull
                public <T> IDependencyObject<T> get(@NotNull String name) {
                    return DependencyObjectHelper.createFromProperty((Property)PropertyCreationHelper.createFromOptional(context -> new Vector2d(AbstractChildInstantiatingAndLayoutControllableUIElement.this.getOrientation() == Orientation.TOP_BOTTOM ? AbstractChildInstantiatingAndLayoutControllableUIElement.this.getLocalInternalBoundingBox().getSize().getX() : element.getMinimalInternalSizeOfParent().getX(), AbstractChildInstantiatingAndLayoutControllableUIElement.this.getOrientation() == Orientation.LEFT_RIGHT ? AbstractChildInstantiatingAndLayoutControllableUIElement.this.getLocalInternalBoundingBox().getSize().getY() : element.getMinimalInternalSizeOfParent().getY()), (context, value) -> {}, (boolean)false), (Object)new Vector2d());
                }
            });
        }
        element.setParent((IUIElementHost)wrappingRegion);
        wrappingRegion.put(element.getId(), element);
        wrappingRegion.setParent((IUIElementHost)this);
        wrappingRegion.update(this.getUiManager().getUpdateManager());
        element.update(this.getParent().getUiManager().getUpdateManager());
        this.put(wrappingRegion.getId(), (Object)wrappingRegion);
    }

    public static abstract class AbstractChildInstantiatingAndLayoutControllableUIElementFactory<U extends AbstractChildInstantiatingAndLayoutControllableUIElement>
    extends AbstractChildrenContainingUIElement.AbstractChildrenContainingUIElementFactory<U> {
        @NotNull
        private final IChildInstantiatingAndLayoutControllableUIElementConstructor<U> constructor;
        @NotNull
        private final AbstractSimpleUIElement.AbstractSimpleUIElementFactory.ISimpleUIElementWriter<U> writer;

        public AbstractChildInstantiatingAndLayoutControllableUIElementFactory(@NotNull Class<U> clz, @NotNull String type, @NotNull IChildInstantiatingAndLayoutControllableUIElementConstructor<U> constructor, @NotNull AbstractSimpleUIElement.AbstractSimpleUIElementFactory.ISimpleUIElementWriter<U> writer) {
            super(clz, type, (elementData, engine, id, parent, styleId, alignments, dock, margin, padding, elementSize, dataContext, visible, enabled) -> {
                IDependencyObject templateResource = elementData.getFromRawDataWithDefault("template", engine, (Object)IIdentifier.create((String)"minecraft:missingno"), IIdentifier.class, new Object[0]);
                IDependencyObject source = elementData.getFromRawDataWithDefault("source", engine, (Object)Lists.newArrayList(), IIdentifier.class, new Object[0]);
                Double scrollOffset = (Double)elementData.getRawWithoutBinding("initialOffset", (Object)0.0, Double.class, new Object[0]);
                IDependencyObject orientation = elementData.getFromRawDataWithDefault("orientation", engine, (Object)Orientation.TOP_BOTTOM, Orientation.class, new Object[0]);
                Object instance = constructor.constructUsing(elementData, engine, id, parent, (IDependencyObject<IIdentifier>)styleId, (IDependencyObject<EnumSet<Alignment>>)alignments, (IDependencyObject<Dock>)dock, (IDependencyObject<AxisDistance>)margin, (IDependencyObject<AxisDistance>)padding, (IDependencyObject<Vector2d>)elementSize, (IDependencyObject<Object>)dataContext, (IDependencyObject<Boolean>)visible, (IDependencyObject<Boolean>)enabled, (IDependencyObject<IIdentifier>)templateResource, (IDependencyObject<Object>)source, (IDependencyObject<Orientation>)orientation, !elementData.getMetaData().hasChildren(), scrollOffset);
                return instance;
            }, (element, builder) -> {
                builder.addComponent("initialOffset", (Object)element.scrollOffset, Double.class).addComponent("orientation", (Object)element.getOrientation(), Orientation.class);
                writer.write(element, builder);
            });
            this.constructor = constructor;
            this.writer = writer;
        }

        @FunctionalInterface
        public static interface IChildInstantiatingAndLayoutControllableUIElementConstructor<U extends AbstractChildInstantiatingAndLayoutControllableUIElement> {
            public U constructUsing(@NotNull IUIElementData<?> var1, @NotNull IBindingEngine var2, @NotNull String var3, @Nullable IUIElementHost var4, @NotNull IDependencyObject<IIdentifier> var5, @NotNull IDependencyObject<EnumSet<Alignment>> var6, @NotNull IDependencyObject<Dock> var7, @NotNull IDependencyObject<AxisDistance> var8, @NotNull IDependencyObject<AxisDistance> var9, @NotNull IDependencyObject<Vector2d> var10, @NotNull IDependencyObject<Object> var11, @NotNull IDependencyObject<Boolean> var12, @NotNull IDependencyObject<Boolean> var13, @NotNull IDependencyObject<IIdentifier> var14, @NotNull IDependencyObject<Object> var15, @NotNull IDependencyObject<Orientation> var16, @NotNull boolean var17, @NotNull Double var18);
        }
    }
}

