/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.blockout.context;

import com.ldtteam.blockout.context.core.IContext;
import com.ldtteam.blockout.util.Constants;
import com.ldtteam.jvoxelizer.dimension.IDimension;
import com.ldtteam.jvoxelizer.util.math.coordinate.block.IBlockCoordinate;
import org.jetbrains.annotations.NotNull;

public class PositionContext
implements IContext {
    private static final long serialVersionUID = Constants.SERIAL_VAR_ID;
    private int dimensionId;
    private int x;
    private int y;
    private int z;

    public PositionContext() {
    }

    public PositionContext(int dimensionId, int x, int y, int z) {
        this.dimensionId = dimensionId;
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public PositionContext(@NotNull IDimension world, @NotNull IBlockCoordinate pos) {
        this.dimensionId = world.getId();
        this.x = pos.getX();
        this.y = pos.getY();
        this.z = pos.getZ();
    }

    public int hashCode() {
        int result = this.getDimensionId();
        result = 31 * result + this.getX();
        result = 31 * result + this.getY();
        result = 31 * result + this.getZ();
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PositionContext)) {
            return false;
        }
        PositionContext that = (PositionContext)o;
        if (this.getDimensionId() != that.getDimensionId()) {
            return false;
        }
        if (this.getX() != that.getX()) {
            return false;
        }
        if (this.getY() != that.getY()) {
            return false;
        }
        return this.getZ() == that.getZ();
    }

    public String toString() {
        return "PositionContext{dimensionId=" + this.dimensionId + ", x=" + this.x + ", y=" + this.y + ", z=" + this.z + '}';
    }

    public int getDimensionId() {
        return this.dimensionId;
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public int getZ() {
        return this.z;
    }
}

