/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.blockout.connector.server;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.ldtteam.blockout.connector.common.CommonGuiInstantiationController;
import com.ldtteam.blockout.connector.common.builder.CommonGuiKeyBuilder;
import com.ldtteam.blockout.connector.core.IGuiController;
import com.ldtteam.blockout.connector.core.IGuiKey;
import com.ldtteam.blockout.connector.core.builder.IGuiKeyBuilder;
import com.ldtteam.blockout.element.IUIElement;
import com.ldtteam.blockout.element.IUIElementHost;
import com.ldtteam.blockout.element.root.RootGuiElement;
import com.ldtteam.blockout.inventory.BlockOutContainerData;
import com.ldtteam.blockout.inventory.BlockOutContainerLogic;
import com.ldtteam.blockout.network.NetworkManager;
import com.ldtteam.blockout.network.message.CloseGuiCommandMessage;
import com.ldtteam.blockout.network.message.OpenGuiCommandMessage;
import com.ldtteam.blockout.network.message.core.IBlockOutServerToClientMessage;
import com.ldtteam.blockout.proxy.ProxyHolder;
import com.ldtteam.blockout.util.Log;
import com.ldtteam.jvoxelizer.IGameEngine;
import com.ldtteam.jvoxelizer.common.gameevent.event.player.IPlayerEntityEvent;
import com.ldtteam.jvoxelizer.entity.living.player.IFakePlayer;
import com.ldtteam.jvoxelizer.entity.living.player.IMultiplayerPlayerEntity;
import com.ldtteam.jvoxelizer.entity.living.player.IPlayerEntity;
import com.ldtteam.jvoxelizer.event.IEvent;
import com.ldtteam.jvoxelizer.event.manager.IEventManager;
import com.ldtteam.jvoxelizer.inventory.IContainer;
import com.ldtteam.jvoxelizer.inventory.IContainerListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ServerGuiController
implements IGuiController {
    private final Map<IGuiKey, RootGuiElement> openUis = new HashMap<IGuiKey, RootGuiElement>();
    private final Map<IGuiKey, List<UUID>> watchers = new HashMap<IGuiKey, List<UUID>>();
    private final Map<UUID, IGuiKey> playerWatching = new HashMap<UUID, IGuiKey>();

    public void openUI(@NotNull IPlayerEntity player, Consumer<IGuiKeyBuilder> ... guiKeyBuilderConsumer) {
        CommonGuiKeyBuilder builder = new CommonGuiKeyBuilder();
        Arrays.stream(guiKeyBuilderConsumer).forEach(iGuiKeyBuilderConsumer -> iGuiKeyBuilderConsumer.accept(builder));
        this.openUI(player, builder.build());
    }

    public void openUI(@NotNull IPlayerEntity player, @NotNull IGuiKey key) {
        this.openUI(player.getId(), key);
    }

    public void openUI(@NotNull UUID playerId, Consumer<IGuiKeyBuilder> ... guiKeyBuilderConsumer) {
        CommonGuiKeyBuilder builder = new CommonGuiKeyBuilder();
        Arrays.stream(guiKeyBuilderConsumer).forEach(iGuiKeyBuilderConsumer -> iGuiKeyBuilderConsumer.accept(builder));
        this.openUI(playerId, builder.build());
    }

    public void openUI(@NotNull UUID playerId, @NotNull IGuiKey key) {
        RootGuiElement host;
        this.closeUI(playerId);
        IMultiplayerPlayerEntity player = IGameEngine.getInstance().getCurrentServerInstance().getPlayerManager().getById(playerId);
        if (player == null) {
            Log.getLogger().warn("Failed to open UI for: " + playerId.toString() + ". Could not Identify player.");
            return;
        }
        if (player instanceof IFakePlayer) {
            return;
        }
        if (!this.openUis.containsKey(key)) {
            try {
                host = CommonGuiInstantiationController.getInstance().instantiateNewGui(key);
            }
            catch (IllegalArgumentException ex) {
                Log.getLogger().error("Failed to build guitemp for: " + playerId, (Throwable)ex);
                return;
            }
            this.openUis.put(key, host);
        } else {
            host = this.openUis.get(key);
        }
        this.watchers.putIfAbsent(key, new ArrayList());
        this.watchers.get(key).add(playerId);
        this.playerWatching.put(playerId, key);
        this.openGui(key, host, player);
    }

    public void closeUI(@NotNull IPlayerEntity player) {
        this.closeUI(player.getId());
    }

    public void closeUI(@NotNull UUID playerId) {
        IMultiplayerPlayerEntity player = IGameEngine.getInstance().getCurrentServerInstance().getPlayerManager().getById(playerId);
        if (player == null) {
            Log.getLogger().warn("Failed to close UI for: " + playerId.toString() + ". Could not Identify player.");
            return;
        }
        if (player instanceof IFakePlayer) {
            return;
        }
        if (this.playerWatching.containsKey(playerId)) {
            IGuiKey currentlyWatching = this.playerWatching.get(playerId);
            this.watchers.get(currentlyWatching).remove(playerId);
            this.playerWatching.remove(playerId);
            if (this.watchers.get(currentlyWatching).isEmpty()) {
                this.watchers.remove(currentlyWatching);
                this.openUis.remove(currentlyWatching);
            }
        }
        try {
            NetworkManager.sendTo((IBlockOutServerToClientMessage)new CloseGuiCommandMessage(), player);
        }
        catch (Exception ex) {
            Log.getLogger().info("Could not send close message. Player might have logged out when UI was open.");
        }
    }

    @Nullable
    public IGuiKey getOpenUI(@NotNull IPlayerEntity player) {
        return this.getOpenUI(player.getId());
    }

    @Nullable
    public IGuiKey getOpenUI(@NotNull UUID player) {
        return this.playerWatching.get(player);
    }

    @Nullable
    public RootGuiElement getRoot(@NotNull IGuiKey guiKey) {
        return this.openUis.get(guiKey);
    }

    private void openGui(@NotNull IGuiKey key, @NotNull RootGuiElement rootGuiElement, @NotNull IMultiplayerPlayerEntity playerMP) {
        playerMP.incrementWindowId();
        playerMP.closeOpenContainer();
        NetworkManager.sendTo((IBlockOutServerToClientMessage)new OpenGuiCommandMessage(key, ProxyHolder.getInstance().getFactoryController().getDataFromElement((IUIElement)rootGuiElement), playerMP.getCurrentWindowId()), playerMP);
        IContainer<BlockOutContainerData> container = BlockOutContainerLogic.create(key, (IUIElementHost)this.openUis.get(key), playerMP.getCurrentWindowId());
        playerMP.setOpenContainer(container);
        playerMP.getOpenContainer().addListener((IContainerListener)playerMP);
        IEventManager.post((IEvent)IPlayerEntityEvent.IContainerEvent.IOpen.create((IPlayerEntity)playerMP, (IContainer)playerMP.getOpenContainer()));
    }

    public ImmutableList<UUID> getUUIDsOfPlayersWatching(@NotNull IGuiKey key) {
        if (this.watchers.get(key) == null) {
            return ImmutableList.of();
        }
        return ImmutableList.copyOf((Collection)this.watchers.get(key));
    }

    public ImmutableMap<IGuiKey, RootGuiElement> getOpenUis() {
        return ImmutableMap.copyOf(this.openUis);
    }

    public ImmutableList<RootGuiElement> getOpenRoots() {
        return ImmutableList.copyOf(this.openUis.values());
    }
}

