/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.blockout.connector.common.inventory.provider;

import com.ldtteam.blockout.connector.core.inventory.IItemHandlerManager;
import com.ldtteam.blockout.connector.core.inventory.IItemHandlerProvider;
import com.ldtteam.blockout.proxy.ProxyHolder;
import com.ldtteam.jvoxelizer.block.entity.IBlockEntity;
import com.ldtteam.jvoxelizer.common.capability.ICapability;
import com.ldtteam.jvoxelizer.dimension.IDimension;
import com.ldtteam.jvoxelizer.item.handling.IItemHandler;
import com.ldtteam.jvoxelizer.util.facing.IFacing;
import com.ldtteam.jvoxelizer.util.identifier.IIdentifier;
import com.ldtteam.jvoxelizer.util.math.coordinate.block.IBlockCoordinate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CommonTileBasedProvider
implements IItemHandlerProvider {
    @NotNull
    private final String id;
    @NotNull
    private final int dimId;
    @NotNull
    private final int x;
    @NotNull
    private final int y;
    @NotNull
    private final int z;
    @Nullable
    private final IFacing facing;

    public CommonTileBasedProvider(@NotNull IIdentifier id, @NotNull int dimId, @NotNull int x, @NotNull int y, @NotNull int z, @Nullable IFacing facing) {
        this.id = id.toString();
        this.dimId = dimId;
        this.x = x;
        this.y = y;
        this.z = z;
        this.facing = facing;
    }

    public int hashCode() {
        int result = this.getId().hashCode();
        result = 31 * result + this.dimId;
        result = 31 * result + this.x;
        result = 31 * result + this.y;
        result = 31 * result + this.z;
        result = 31 * result + (this.facing != null ? this.facing.hashCode() : 0);
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CommonTileBasedProvider that = (CommonTileBasedProvider)o;
        if (this.dimId != that.dimId) {
            return false;
        }
        if (this.x != that.x) {
            return false;
        }
        if (this.y != that.y) {
            return false;
        }
        if (this.z != that.z) {
            return false;
        }
        if (!this.getId().equals(that.getId())) {
            return false;
        }
        return this.facing == that.facing;
    }

    @NotNull
    public IIdentifier getId() {
        return IIdentifier.create((String)this.id);
    }

    @Nullable
    public IItemHandler get(@NotNull IItemHandlerManager manager) {
        IDimension blockAccess = ProxyHolder.getInstance().getDimensionFromDimensionId(this.dimId);
        IBlockEntity tileEntity = blockAccess.getBlockEntity(IBlockCoordinate.create((int)this.x, (int)this.y, (int)this.z));
        if (tileEntity == null) {
            return null;
        }
        if (tileEntity.hasCapability(ICapability.getItemHandlerCapability(), this.facing)) {
            return (IItemHandler)tileEntity.getCapability(ICapability.getItemHandlerCapability(), this.facing);
        }
        return null;
    }
}

