/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.blockout.connector.common.inventory.provider;

import com.ldtteam.blockout.connector.core.inventory.IItemHandlerManager;
import com.ldtteam.blockout.connector.core.inventory.IItemHandlerProvider;
import com.ldtteam.blockout.proxy.ProxyHolder;
import com.ldtteam.jvoxelizer.common.capability.ICapability;
import com.ldtteam.jvoxelizer.dimension.IDimension;
import com.ldtteam.jvoxelizer.entity.IEntity;
import com.ldtteam.jvoxelizer.item.handling.IItemHandler;
import com.ldtteam.jvoxelizer.util.facing.IFacing;
import com.ldtteam.jvoxelizer.util.identifier.IIdentifier;
import java.util.UUID;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CommonEntityBasedProvider
implements IItemHandlerProvider {
    @NotNull
    private final String id;
    @NotNull
    private final int dimId;
    @NotNull
    private final UUID entityId;
    @Nullable
    private final IFacing facing;

    public CommonEntityBasedProvider(@NotNull IIdentifier id, @NotNull int dimId, @NotNull UUID entityId, @Nullable IFacing facing) {
        this.id = id.toString();
        this.dimId = dimId;
        this.entityId = entityId;
        this.facing = facing;
    }

    public int hashCode() {
        int result = this.getId().hashCode();
        result = 31 * result + this.dimId;
        result = 31 * result + this.entityId.hashCode();
        result = 31 * result + (this.facing != null ? this.facing.hashCode() : 0);
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CommonEntityBasedProvider that = (CommonEntityBasedProvider)o;
        if (this.dimId != that.dimId) {
            return false;
        }
        if (!this.getId().equals(that.getId())) {
            return false;
        }
        if (!this.entityId.equals(that.entityId)) {
            return false;
        }
        return this.facing == that.facing;
    }

    @NotNull
    public IIdentifier getId() {
        return IIdentifier.create((String)this.id);
    }

    @Nullable
    public IItemHandler get(@NotNull IItemHandlerManager manager) {
        IDimension blockAccess = ProxyHolder.getInstance().getDimensionFromDimensionId(this.dimId);
        IEntity entity = blockAccess.getLoadedEntities().stream().filter(e -> e.getId().equals(this.entityId)).findFirst().orElse(null);
        if (entity == null) {
            return IItemHandler.empty();
        }
        if (!entity.hasCapability(ICapability.getItemHandlerCapability(), this.facing)) {
            throw new IllegalStateException("Gui created with an entity inventory for an entity that has no entity.");
        }
        return (IItemHandler)entity.getCapability(ICapability.getItemHandlerCapability(), this.facing);
    }
}

