/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.blockout.connector.common.inventory.builder;

import com.google.common.collect.Lists;
import com.ldtteam.blockout.connector.common.inventory.CommonItemHandlerManager;
import com.ldtteam.blockout.connector.common.inventory.provider.CommonEntityBasedProvider;
import com.ldtteam.blockout.connector.common.inventory.provider.CommonRangedBasedProvider;
import com.ldtteam.blockout.connector.common.inventory.provider.CommonTileBasedProvider;
import com.ldtteam.blockout.connector.core.inventory.IItemHandlerManager;
import com.ldtteam.blockout.connector.core.inventory.IItemHandlerProvider;
import com.ldtteam.blockout.connector.core.inventory.builder.IItemHandlerManagerBuilder;
import com.ldtteam.jvoxelizer.util.facing.IFacing;
import com.ldtteam.jvoxelizer.util.identifier.IIdentifier;
import java.util.List;
import java.util.UUID;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CommonItemHandlerManagerBuilder
implements IItemHandlerManagerBuilder {
    @NotNull
    private final List<IItemHandlerProvider> providerList = Lists.newArrayList();

    @NotNull
    public IItemHandlerManagerBuilder withProvider(@NotNull IItemHandlerProvider provider) {
        this.providerList.add(provider);
        return this;
    }

    @NotNull
    public IItemHandlerManagerBuilder withTileBasedProvider(@NotNull IIdentifier id, @NotNull int dimId, @NotNull int x, @NotNull int y, @NotNull int z, @Nullable IFacing facing) {
        return this.withProvider(new CommonTileBasedProvider(id, dimId, x, y, z, facing));
    }

    @NotNull
    public IItemHandlerManagerBuilder withEntityBasedProvider(@NotNull IIdentifier id, @NotNull int dimId, @NotNull UUID entityId, @Nullable IFacing facing) {
        return this.withProvider(new CommonEntityBasedProvider(id, dimId, entityId, facing));
    }

    @NotNull
    public IItemHandlerManagerBuilder withWrapped(@NotNull IIdentifier id, @NotNull IIdentifier wrappedId, @NotNull int minSlot, @NotNull int maxSlotExcluding) {
        return this.withProvider(new CommonRangedBasedProvider(id.toString(), wrappedId.toString(), minSlot, maxSlotExcluding));
    }

    @NotNull
    public IItemHandlerManagerBuilder copyFrom(@NotNull IItemHandlerManager manager) {
        this.providerList.addAll(manager.getAllProviders());
        return this;
    }

    @NotNull
    public IItemHandlerManager build() {
        return new CommonItemHandlerManager(this.providerList);
    }
}

