/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.blockout.connector.common.inventory;

import com.google.common.collect.ImmutableList;
import com.ldtteam.blockout.connector.core.inventory.IItemHandlerManager;
import com.ldtteam.blockout.connector.core.inventory.IItemHandlerProvider;
import com.ldtteam.jvoxelizer.item.handling.IItemHandler;
import com.ldtteam.jvoxelizer.util.identifier.IIdentifier;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CommonItemHandlerManager
implements IItemHandlerManager {
    @NotNull
    private final Map<String, IItemHandlerProvider> providerMap;

    public CommonItemHandlerManager(@NotNull List<IItemHandlerProvider> providerList) {
        this.providerMap = providerList.stream().collect(Collectors.toMap(provider -> provider.getId().toString(), Function.identity()));
    }

    @Nullable
    public IItemHandler getItemHandlerFromId(@NotNull IIdentifier id) {
        if (this.providerMap.containsKey(id.toString())) {
            return this.providerMap.get(id.toString()).get((IItemHandlerManager)this);
        }
        return null;
    }

    @NotNull
    public List<IIdentifier> getAllItemHandlerIds() {
        return ImmutableList.copyOf((Collection)this.providerMap.keySet().stream().map(IIdentifier::create).collect(Collectors.toList()));
    }

    @NotNull
    public List<IItemHandlerProvider> getAllProviders() {
        return ImmutableList.copyOf(this.providerMap.values());
    }

    public int hashCode() {
        return this.providerMap.hashCode();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CommonItemHandlerManager that = (CommonItemHandlerManager)o;
        return this.providerMap.equals(that.providerMap);
    }
}

