/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.blockout.connector.common.definition.loader;

import com.google.common.io.CharStreams;
import com.ldtteam.blockout.connector.core.IGuiDefinitionLoader;
import com.ldtteam.blockout.util.Log;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URISyntaxException;
import java.net.URL;
import org.apache.http.HttpResponse;
import org.apache.http.client.RedirectStrategy;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.client.LaxRedirectStrategy;
import org.jetbrains.annotations.NotNull;

public class CommonWebFileBasedGuiDefinitionLoader
implements IGuiDefinitionLoader {
    @NotNull
    private final URL url;

    private CommonWebFileBasedGuiDefinitionLoader() {
        this.url = null;
    }

    public CommonWebFileBasedGuiDefinitionLoader(@NotNull URL url) {
        this.url = url;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    public String getGuiDefinition() {
        try (CloseableHttpClient closeableHttpClient = HttpClients.custom().setRedirectStrategy((RedirectStrategy)new LaxRedirectStrategy()).build();){
            HttpGet getter = new HttpGet(this.url.toURI());
            String string = (String)closeableHttpClient.execute((HttpUriRequest)getter, (ResponseHandler)new HttpResultToStringHandler());
            return string;
        }
        catch (IOException e) {
            Log.getLogger().error("Failed to download the guitemp definition from: " + this.url.toString(), (Throwable)e);
            return "";
        }
        catch (URISyntaxException e) {
            Log.getLogger().error("Failed to parse the url for the guitemp definition from: " + this.url.toString(), (Throwable)e);
            return "";
        }
    }

    private static final class HttpResultToStringHandler
    implements ResponseHandler<String> {
        private HttpResultToStringHandler() {
        }

        public String handleResponse(HttpResponse response) throws IOException {
            String data;
            InputStream stream = response.getEntity().getContent();
            try (InputStreamReader reader = new InputStreamReader(stream);){
                data = CharStreams.toString((Readable)reader);
            }
            return data;
        }
    }
}

