/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.blockout.connector.common.definition.loader;

import com.google.common.io.CharStreams;
import com.ldtteam.blockout.connector.core.IGuiDefinitionLoader;
import com.ldtteam.blockout.proxy.ProxyHolder;
import com.ldtteam.blockout.util.Log;
import com.ldtteam.jvoxelizer.util.identifier.IIdentifier;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

public class CommonIIdentifierBasedGuiDefinitionLoader
implements IGuiDefinitionLoader {
    @NotNull
    private final String domain;
    @NotNull
    private final String path;

    private CommonIIdentifierBasedGuiDefinitionLoader() {
        this.domain = "";
        this.path = "";
    }

    public CommonIIdentifierBasedGuiDefinitionLoader(IIdentifier location) {
        this.domain = location.getDomain();
        this.path = location.getPath();
    }

    @NotNull
    public String getGuiDefinition() {
        try {
            String data;
            InputStream stream = ProxyHolder.getInstance().getResourceStream(this.getLocation());
            try (InputStreamReader reader = new InputStreamReader(stream);){
                data = CharStreams.toString((Readable)reader);
            }
            return data;
        }
        catch (Exception e) {
            Log.getLogger().warn("Failed to read data from location: " + this.getLocation(), (Throwable)e);
            return "";
        }
    }

    @NotNull
    public IIdentifier getLocation() {
        return IIdentifier.create((String)this.domain, (String)this.path);
    }

    public int hashCode() {
        return Objects.hash(this.getLocation());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CommonIIdentifierBasedGuiDefinitionLoader that = (CommonIIdentifierBasedGuiDefinitionLoader)o;
        return Objects.equals(this.getLocation(), that.getLocation());
    }
}

