/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.blockout.connector.common.builder;

import com.ldtteam.blockout.builder.core.IBlockOutGuiConstructionData;
import com.ldtteam.blockout.builder.core.builder.IBlockOutGuiConstructionDataBuilder;
import com.ldtteam.blockout.builder.data.builder.BlockOutGuiConstructionDataBuilder;
import com.ldtteam.blockout.connector.common.CommonGuiKey;
import com.ldtteam.blockout.connector.common.definition.loader.CommonClassBasedDefinitionLoader;
import com.ldtteam.blockout.connector.common.definition.loader.CommonIIdentifierBasedGuiDefinitionLoader;
import com.ldtteam.blockout.connector.common.definition.loader.CommonWebFileBasedGuiDefinitionLoader;
import com.ldtteam.blockout.connector.common.inventory.builder.CommonItemHandlerManagerBuilder;
import com.ldtteam.blockout.connector.core.IGuiDefinitionLoader;
import com.ldtteam.blockout.connector.core.IGuiKey;
import com.ldtteam.blockout.connector.core.builder.IGuiKeyBuilder;
import com.ldtteam.blockout.connector.core.inventory.IItemHandlerManager;
import com.ldtteam.blockout.connector.core.inventory.builder.IItemHandlerManagerBuilder;
import com.ldtteam.blockout.context.ClientSideOnlyContext;
import com.ldtteam.blockout.context.EntityContext;
import com.ldtteam.blockout.context.PositionContext;
import com.ldtteam.blockout.context.core.IContext;
import com.ldtteam.jvoxelizer.dimension.IDimension;
import com.ldtteam.jvoxelizer.entity.IEntity;
import com.ldtteam.jvoxelizer.util.identifier.IIdentifier;
import com.ldtteam.jvoxelizer.util.math.coordinate.block.IBlockCoordinate;
import java.net.URL;
import java.util.Arrays;
import java.util.UUID;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;

public class CommonGuiKeyBuilder
implements IGuiKeyBuilder {
    @NotNull
    private IGuiDefinitionLoader guiDefinitionLoader;
    @NotNull
    private IBlockOutGuiConstructionDataBuilder blockOutGuiConstructionDataBuilder = new BlockOutGuiConstructionDataBuilder();
    @NotNull
    private IContext context;
    @NotNull
    private IItemHandlerManagerBuilder iItemHandlerManagerBuilder = new CommonItemHandlerManagerBuilder();

    @NotNull
    public IGuiKeyBuilder ofWebResource(@NotNull URL url) {
        this.guiDefinitionLoader = new CommonWebFileBasedGuiDefinitionLoader(url);
        return this;
    }

    @NotNull
    public IGuiKeyBuilder ofFile(@NotNull IIdentifier location) {
        this.guiDefinitionLoader = new CommonIIdentifierBasedGuiDefinitionLoader(location);
        return this;
    }

    @NotNull
    public IGuiKeyBuilder ofClass(@NotNull Class<?> clazz) {
        this.guiDefinitionLoader = new CommonClassBasedDefinitionLoader(clazz);
        return this;
    }

    public IGuiKeyBuilder ofDefinition(@NotNull IGuiDefinitionLoader definitionLoader) {
        this.guiDefinitionLoader = definitionLoader;
        return this;
    }

    @NotNull
    public IGuiKeyBuilder usingData(Consumer<IBlockOutGuiConstructionDataBuilder> ... builderConsumer) {
        Arrays.stream(builderConsumer).forEach(consumer -> consumer.accept(this.blockOutGuiConstructionDataBuilder));
        return this;
    }

    @NotNull
    public IGuiKeyBuilder usingData(@NotNull IBlockOutGuiConstructionData data) {
        this.blockOutGuiConstructionDataBuilder.copyFrom(data);
        return this;
    }

    @NotNull
    public IGuiKeyBuilder withItemHandlerManager(@NotNull IItemHandlerManager manager) {
        this.iItemHandlerManagerBuilder.copyFrom(manager);
        return this;
    }

    @NotNull
    public IGuiKeyBuilder withItemHandlerManager(Consumer<IItemHandlerManagerBuilder> ... configurer) {
        CommonItemHandlerManagerBuilder builder = new CommonItemHandlerManagerBuilder();
        Arrays.stream(configurer).forEach(consumer -> consumer.accept(builder));
        return this.withItemHandlerManager(builder.build());
    }

    @NotNull
    public IGuiKeyBuilder forEntity(@NotNull UUID entityId) {
        this.context = new EntityContext(entityId);
        return this;
    }

    @NotNull
    public IGuiKeyBuilder forEntity(@NotNull IEntity entity) {
        this.context = new EntityContext(entity);
        return this;
    }

    @NotNull
    public IGuiKeyBuilder forPosition(@NotNull int dimensionId, @NotNull int x, @NotNull int y, @NotNull int z) {
        this.context = new PositionContext(dimensionId, x, y, z);
        return this;
    }

    @NotNull
    public IGuiKeyBuilder forPosition(@NotNull IDimension world, @NotNull IBlockCoordinate blockPos) {
        this.context = new PositionContext(world, blockPos);
        return this;
    }

    @NotNull
    public IGuiKeyBuilder forClientSideOnly() {
        this.context = new ClientSideOnlyContext();
        return this;
    }

    @NotNull
    public IGuiKeyBuilder forContext(@NotNull IContext context) {
        this.context = context;
        return this;
    }

    @NotNull
    public IGuiKey build() {
        return new CommonGuiKey(this.guiDefinitionLoader, this.blockOutGuiConstructionDataBuilder.build(), this.context, this.iItemHandlerManagerBuilder.build());
    }
}

