/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.blockout.connector.common;

import com.ldtteam.blockout.connector.core.IGuiDefinitionLoader;
import com.ldtteam.blockout.connector.core.ILoaderManager;
import com.ldtteam.blockout.loader.ILoader;
import com.ldtteam.blockout.loader.core.IUIElementData;
import com.ldtteam.blockout.util.Log;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CommonLoaderManager
implements ILoaderManager {
    private final Set<ILoader> loaders = new HashSet<ILoader>();

    public void registerLoader(@NotNull ILoader loader) {
        this.loaders.add(loader);
    }

    public IUIElementData loadData(@NotNull IGuiDefinitionLoader dataLoader) {
        try {
            List<LoadingResult> resultList = this.loaders.stream().map(l -> {
                try {
                    return new LoadingResult(l.loadDataFromDefinition(dataLoader.getGuiDefinition()), null, "");
                }
                catch (Exception e) {
                    return new LoadingResult(null, e, l.getClass().getName());
                }
            }).collect(Collectors.toList());
            if (resultList.stream().noneMatch(LoadingResult::wasSuccessful)) {
                resultList.forEach(rec$ -> ((LoadingResult)rec$).LogError());
                return null;
            }
            return resultList.stream().filter(LoadingResult::wasSuccessful).findFirst().map(LoadingResult::getElementData).orElseThrow(() -> new IllegalStateException("Failed to find successful result!"));
        }
        catch (Exception e) {
            Log.getLogger().warn((Object)e);
            return null;
        }
    }

    private final class LoadingResult {
        @Nullable
        private final IUIElementData<?> elementData;
        @Nullable
        private final Exception exception;
        @Nullable
        private final String loaderName;

        public LoadingResult(@Nullable IUIElementData<?> elementData, @Nullable Exception exception, String loaderName) {
            this.elementData = elementData;
            this.exception = exception;
            this.loaderName = loaderName;
        }

        public boolean wasSuccessful() {
            return this.exception == null && this.elementData != null;
        }

        @Nullable
        public IUIElementData<?> getElementData() {
            return this.elementData;
        }

        @Nullable
        public Exception getException() {
            return this.exception;
        }

        private void LogError() {
            Log.getLogger().warn(String.format("Failed to parse UI data into element using loader: %s", this.getLoaderName()), (Throwable)this.exception);
        }

        @Nullable
        public String getLoaderName() {
            return this.loaderName;
        }
    }
}

