/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.blockout.connector.common;

import com.ldtteam.blockout.builder.core.IBlockOutGuiConstructionData;
import com.ldtteam.blockout.builder.data.builder.BlockOutGuiConstructionDataBuilder;
import com.ldtteam.blockout.connector.core.IGuiDefinitionLoader;
import com.ldtteam.blockout.connector.core.IGuiKey;
import com.ldtteam.blockout.connector.core.inventory.IItemHandlerManager;
import com.ldtteam.blockout.context.core.IContext;
import org.jetbrains.annotations.NotNull;

public class CommonGuiKey
implements IGuiKey {
    @NotNull
    private final IGuiDefinitionLoader loader;
    @NotNull
    private final transient IBlockOutGuiConstructionData constructionData;
    @NotNull
    private final IContext context;
    @NotNull
    private final IItemHandlerManager itemHandlerManager;

    private CommonGuiKey() {
        this.loader = null;
        this.constructionData = new BlockOutGuiConstructionDataBuilder().build();
        this.context = null;
        this.itemHandlerManager = null;
    }

    public CommonGuiKey(@NotNull IGuiDefinitionLoader loader, @NotNull IBlockOutGuiConstructionData constructionData, @NotNull IContext context, @NotNull IItemHandlerManager itemHandlerManager) {
        this.loader = loader;
        this.constructionData = constructionData;
        this.context = context;
        this.itemHandlerManager = itemHandlerManager;
    }

    public int hashCode() {
        int result = this.loader.hashCode();
        result = 31 * result + this.getConstructionData().hashCode();
        result = 31 * result + this.context.hashCode();
        result = 31 * result + this.getItemHandlerManager().hashCode();
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CommonGuiKey that = (CommonGuiKey)o;
        if (!this.loader.equals(that.loader)) {
            return false;
        }
        if (!this.getConstructionData().equals(that.getConstructionData())) {
            return false;
        }
        if (!this.context.equals(that.context)) {
            return false;
        }
        return this.getItemHandlerManager().equals(that.getItemHandlerManager());
    }

    @NotNull
    public IGuiDefinitionLoader getGuiDefinitionLoader() {
        return this.loader;
    }

    @NotNull
    public IBlockOutGuiConstructionData getConstructionData() {
        return this.constructionData;
    }

    @NotNull
    public IItemHandlerManager getItemHandlerManager() {
        return this.itemHandlerManager;
    }

    @NotNull
    public IContext getGuiContext() {
        return this.context;
    }
}

