/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.blockout.connector.common;

import com.ldtteam.blockout.binding.dependency.IDependencyReceiver;
import com.ldtteam.blockout.binding.dependency.injection.DependencyObjectInjector;
import com.ldtteam.blockout.binding.dependency.injection.IDependencyDataProvider;
import com.ldtteam.blockout.connector.core.IGuiKey;
import com.ldtteam.blockout.element.IUIElement;
import com.ldtteam.blockout.element.root.RootGuiElement;
import com.ldtteam.blockout.event.injector.EventHandlerInjector;
import com.ldtteam.blockout.event.injector.IEventHandlerProvider;
import com.ldtteam.blockout.loader.core.IUIElementData;
import com.ldtteam.blockout.management.UIManager;
import com.ldtteam.blockout.proxy.ProxyHolder;
import org.jetbrains.annotations.NotNull;

public class CommonGuiInstantiationController {
    private static CommonGuiInstantiationController ourInstance = new CommonGuiInstantiationController();

    private CommonGuiInstantiationController() {
    }

    public static CommonGuiInstantiationController getInstance() {
        return ourInstance;
    }

    public RootGuiElement instantiateNewGui(@NotNull IGuiKey key) {
        IUIElementData elementData = ProxyHolder.getInstance().getLoaderManager().loadData(key.getGuiDefinitionLoader());
        if (elementData == null) {
            throw new IllegalArgumentException("The given guikey contains no valid IUIElementData");
        }
        IUIElement element = ProxyHolder.getInstance().getFactoryController().getElementFromData(elementData);
        if (!(element instanceof RootGuiElement)) {
            throw new IllegalArgumentException("The given guikey has no Root as root element.");
        }
        RootGuiElement host = (RootGuiElement)element;
        DependencyObjectInjector.inject((IDependencyReceiver)host, (IDependencyDataProvider)key.getConstructionData());
        host.getAllCombinedChildElements().values().forEach(c -> DependencyObjectInjector.inject((IDependencyReceiver)c, (IDependencyDataProvider)key.getConstructionData()));
        EventHandlerInjector.inject((IUIElement)host, (IEventHandlerProvider)key.getConstructionData());
        host.getAllCombinedChildElements().values().forEach(c -> EventHandlerInjector.inject((IUIElement)c, (IEventHandlerProvider)key.getConstructionData()));
        host.setUiManager(new UIManager(host, key));
        host.getUiManager().getUpdateManager().updateElement((IUIElement)host);
        return host;
    }
}

