/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.blockout.connector.common;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.ImmutableSet;
import com.ldtteam.blockout.connector.core.IUIElementFactoryController;
import com.ldtteam.blockout.element.IUIElement;
import com.ldtteam.blockout.factory.IUIElementFactory;
import com.ldtteam.blockout.loader.binding.core.IBindingEngine;
import com.ldtteam.blockout.loader.binding.engine.SimpleBindingEngine;
import com.ldtteam.blockout.loader.core.IUIElementData;
import com.ldtteam.blockout.loader.core.IUIElementDataBuilder;
import com.ldtteam.blockout.loader.core.IUIElementMetaDataBuilder;
import com.ldtteam.blockout.loader.core.component.IUIElementDataComponent;
import com.ldtteam.blockout.loader.object.ObjectUIElementBuilder;
import com.ldtteam.jvoxelizer.util.identifier.IIdentifier;
import java.util.Collection;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public class CommonFactoryController
implements IUIElementFactoryController {
    private final BiMap<String, IUIElementFactory<?>> factoryBiMap = HashBiMap.create();

    public IUIElementFactoryController registerFactory(@NotNull IUIElementFactory<?> factory) {
        this.factoryBiMap.forcePut((Object)factory.getTypeName(), factory);
        return this;
    }

    @NotNull
    public IUIElement getElementFromData(@NotNull IUIElementData data) {
        String type = data.getMetaData().getType();
        if (!this.factoryBiMap.containsKey((Object)type)) {
            throw new IllegalArgumentException("Unknown type is contained in the given data.");
        }
        return ((IUIElementFactory)this.factoryBiMap.get((Object)type)).readFromElementData(data, (IBindingEngine)SimpleBindingEngine.getInstance());
    }

    @NotNull
    public <T extends IUIElement> IUIElementData getDataFromElement(@NotNull T element) {
        return this.getDataFromElementWithBuilder(element, new ObjectUIElementBuilder());
    }

    @NotNull
    public <T extends IUIElement, C extends IUIElementDataComponent, D extends IUIElementData<C>, B extends IUIElementDataBuilder<D>> D getDataFromElementWithBuilder(@NotNull T element, @NotNull B builder) {
        String type = element.getType();
        if (!this.factoryBiMap.containsKey((Object)type)) {
            throw new IllegalArgumentException("Unknown type is contained in the given data.");
        }
        IUIElementFactory factory = (IUIElementFactory)this.factoryBiMap.get((Object)type);
        builder.withMetaData(this.buildMetaDataBuilder(element));
        builder.addComponent("style", (Object)element.getStyleId(), IIdentifier.class);
        factory.writeToElementData(element, builder);
        return (D)builder.build();
    }

    @NotNull
    public ImmutableSet<Class<?>> getAllKnownTypes() {
        return ImmutableSet.copyOf((Collection)this.factoryBiMap.values().stream().map(IUIElementFactory::getProducedElementClass).collect(Collectors.toSet()));
    }

    private <T extends IUIElement> Consumer<IUIElementMetaDataBuilder<?>> buildMetaDataBuilder(@NotNull T element) {
        return metaDataBuilder -> metaDataBuilder.withId(element.getId()).withType(element.getType());
    }
}

