/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.blockout.connector.client;

import com.ldtteam.blockout.connector.common.CommonGuiInstantiationController;
import com.ldtteam.blockout.connector.common.builder.CommonGuiKeyBuilder;
import com.ldtteam.blockout.connector.core.IGuiController;
import com.ldtteam.blockout.connector.core.IGuiKey;
import com.ldtteam.blockout.connector.core.builder.IGuiKeyBuilder;
import com.ldtteam.blockout.element.IUIElementHost;
import com.ldtteam.blockout.element.root.RootGuiElement;
import com.ldtteam.blockout.element.simple.Slot;
import com.ldtteam.blockout.gui.BlockOutGuiLogic;
import com.ldtteam.blockout.util.Log;
import com.ldtteam.jvoxelizer.IGameEngine;
import com.ldtteam.jvoxelizer.entity.living.player.IPlayerEntity;
import com.ldtteam.jvoxelizer.util.tuple.ITuple;
import java.util.Arrays;
import java.util.UUID;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ClientSideOnlyGuiController
implements IGuiController {
    private static final UUID DUMMY_ID = new UUID(0L, 0L);
    @Nullable
    private ITuple<IGuiKey, RootGuiElement> openClientSideOnlyGui = null;

    public void openUI(@Nullable IPlayerEntity player, Consumer<IGuiKeyBuilder> ... guiKeyBuilderConsumer) {
        CommonGuiKeyBuilder builder = new CommonGuiKeyBuilder();
        Arrays.stream(guiKeyBuilderConsumer).forEach(iGuiKeyBuilderConsumer -> iGuiKeyBuilderConsumer.accept(builder));
        this.openUI(player, builder.build());
    }

    public void openUI(@Nullable IPlayerEntity player, @NotNull IGuiKey key) {
        this.openUI(DUMMY_ID, key);
    }

    public void openUI(@Nullable UUID playerId, Consumer<IGuiKeyBuilder> ... guiKeyBuilderConsumer) {
        CommonGuiKeyBuilder builder = new CommonGuiKeyBuilder();
        Arrays.stream(guiKeyBuilderConsumer).forEach(iGuiKeyBuilderConsumer -> iGuiKeyBuilderConsumer.accept(builder));
        this.openUI(DUMMY_ID, builder.build());
    }

    public void openUI(@Nullable UUID playerId, @NotNull IGuiKey key) {
        RootGuiElement host;
        this.closeUI(playerId);
        if (!key.getItemHandlerManager().getAllItemHandlerIds().isEmpty()) {
            throw new IllegalArgumentException("Can not build a ClientSide only gui with inventory support.");
        }
        try {
            host = CommonGuiInstantiationController.getInstance().instantiateNewGui(key);
            if (host.getAllCombinedChildElements().entrySet().stream().anyMatch(e -> e instanceof Slot)) {
                throw new IllegalArgumentException("Can not open UI that holds Slots. Inventories are not supported in ClientSide only gui's.");
            }
        }
        catch (IllegalArgumentException ex) {
            Log.getLogger().error("Failed to build client side only gui.", (Throwable)ex);
            return;
        }
        this.openClientSideOnlyGui = ITuple.create((Object)key, (Object)((Object)host));
        this.openGui(key, host);
    }

    public void closeUI(@Nullable IPlayerEntity player) {
        this.closeUI(DUMMY_ID);
    }

    public void closeUI(@Nullable UUID playerId) {
        IGameEngine.getInstance().displayGuiScreen(null);
    }

    @Nullable
    public IGuiKey getOpenUI(@Nullable IPlayerEntity player) {
        if (IGameEngine.getInstance().getSinglePlayerPlayerEntity() != player) {
            throw new IllegalArgumentException("Can not get UI from remote player for ClientSide gui's");
        }
        if (this.openClientSideOnlyGui == null) {
            return null;
        }
        return (IGuiKey)this.openClientSideOnlyGui.getFirst();
    }

    @Nullable
    public IGuiKey getOpenUI(@Nullable UUID player) {
        if (IGameEngine.getInstance().getSinglePlayerPlayerEntity() == null && player != null || IGameEngine.getInstance().getSinglePlayerPlayerEntity() != null && player == null || IGameEngine.getInstance().getSinglePlayerPlayerEntity().getId() != player) {
            throw new IllegalArgumentException("Can not get UI from remote player for ClientSide gui's");
        }
        if (this.openClientSideOnlyGui == null) {
            return null;
        }
        return (IGuiKey)this.openClientSideOnlyGui.getFirst();
    }

    @Nullable
    public RootGuiElement getRoot(@Nullable IGuiKey guiKey) {
        if (guiKey == null && this.openClientSideOnlyGui == null) {
            return null;
        }
        if (this.openClientSideOnlyGui != null) {
            if (this.openClientSideOnlyGui.getFirst() != guiKey) {
                throw new IllegalArgumentException("Can not get root from unknown gui key.");
            }
            return (RootGuiElement)((Object)this.openClientSideOnlyGui.getSecond());
        }
        return null;
    }

    private void openGui(@NotNull IGuiKey key, @NotNull RootGuiElement rootGuiElement) {
        IGameEngine.getInstance().displayGuiScreen(BlockOutGuiLogic.createClientSideOnly(key, (IUIElementHost)rootGuiElement));
    }
}

