/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.blockout.connector.client;

import com.ldtteam.blockout.connector.common.builder.CommonGuiKeyBuilder;
import com.ldtteam.blockout.connector.core.IGuiController;
import com.ldtteam.blockout.connector.core.IGuiKey;
import com.ldtteam.blockout.connector.core.builder.IGuiKeyBuilder;
import com.ldtteam.blockout.element.root.RootGuiElement;
import com.ldtteam.blockout.network.NetworkManager;
import com.ldtteam.blockout.network.message.CloseGuiRequestMessage;
import com.ldtteam.blockout.network.message.OpenGuiRequestMessage;
import com.ldtteam.blockout.util.Log;
import com.ldtteam.jvoxelizer.IGameEngine;
import com.ldtteam.jvoxelizer.entity.living.player.IPlayerEntity;
import java.util.Arrays;
import java.util.UUID;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ClientGuiController
implements IGuiController {
    public void openUI(@NotNull IPlayerEntity player, Consumer<IGuiKeyBuilder> ... guiKeyBuilderConsumer) {
        CommonGuiKeyBuilder builder = new CommonGuiKeyBuilder();
        Arrays.stream(guiKeyBuilderConsumer).forEach(iGuiKeyBuilderConsumer -> iGuiKeyBuilderConsumer.accept(builder));
        this.openUI(player, builder.build());
    }

    public void openUI(@NotNull IPlayerEntity player, @NotNull IGuiKey key) {
        this.openUI(player.getId(), key);
    }

    public void openUI(@NotNull UUID playerId, Consumer<IGuiKeyBuilder> ... guiKeyBuilderConsumer) {
        CommonGuiKeyBuilder builder = new CommonGuiKeyBuilder();
        Arrays.stream(guiKeyBuilderConsumer).forEach(iGuiKeyBuilderConsumer -> iGuiKeyBuilderConsumer.accept(builder));
        this.openUI(playerId, builder.build());
    }

    public void openUI(@NotNull UUID playerId, @NotNull IGuiKey key) {
        if (!playerId.equals(IGameEngine.getInstance().getSinglePlayerPlayerEntity().getId())) {
            Log.getLogger().warn("Cannot open UI of other player.");
            return;
        }
        NetworkManager.sendToServer(new OpenGuiRequestMessage(key));
    }

    public void closeUI(@NotNull IPlayerEntity player) {
        this.closeUI(player.getId());
    }

    public void closeUI(@NotNull UUID playerId) {
        if (!playerId.equals(IGameEngine.getInstance().getSinglePlayerPlayerEntity().getId())) {
            Log.getLogger().warn("Cannot close UI of other player.");
            return;
        }
        NetworkManager.sendToServer(new CloseGuiRequestMessage());
    }

    @Nullable
    public IGuiKey getOpenUI(@NotNull IPlayerEntity player) {
        return null;
    }

    @Nullable
    public IGuiKey getOpenUI(@NotNull UUID player) {
        return null;
    }

    @Nullable
    public RootGuiElement getRoot(@NotNull IGuiKey guiKey) {
        return null;
    }
}

