/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.blockout.compat;

import com.ldtteam.blockout.compat.ClientTickManager;
import com.ldtteam.blockout.connector.core.IGuiKey;
import com.ldtteam.blockout.connector.server.ServerGuiController;
import com.ldtteam.blockout.element.IUIElement;
import com.ldtteam.blockout.element.root.RootGuiElement;
import com.ldtteam.blockout.gui.BlockOutGuiData;
import com.ldtteam.blockout.inventory.BlockOutContainerData;
import com.ldtteam.blockout.inventory.BlockOutContainerLogic;
import com.ldtteam.blockout.management.server.update.ServerUpdateManager;
import com.ldtteam.blockout.proxy.ProxyHolder;
import com.ldtteam.blockout.util.Log;
import com.ldtteam.jvoxelizer.IGameEngine;
import com.ldtteam.jvoxelizer.client.gui.IGuiContainer;
import com.ldtteam.jvoxelizer.common.gameevent.event.ITickEvent;
import com.ldtteam.jvoxelizer.common.gameevent.event.player.IPlayerGameEvent;
import com.ldtteam.jvoxelizer.entity.living.player.IMultiplayerPlayerEntity;
import com.ldtteam.jvoxelizer.entity.living.player.IPlayerEntity;
import com.ldtteam.jvoxelizer.inventory.IContainer;
import com.ldtteam.jvoxelizer.util.distribution.executor.IDistributionExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.time.StopWatch;

public class UpdateHandler {
    private static Thread updateThread = null;

    public static void onPlayerLoggedOut(IPlayerGameEvent.ILoggedOutEvent event) {
        if (event.getPlayerEntity() instanceof IMultiplayerPlayerEntity) {
            IMultiplayerPlayerEntity playerMP = (IMultiplayerPlayerEntity)event.getPlayerEntity();
            ProxyHolder.getInstance().getGuiController().closeUI((IPlayerEntity)playerMP);
        }
    }

    public static void onTickClientTick(ITickEvent.IClientTickEvent event) {
        if (event.getPhase() != ITickEvent.Phase.END) {
            return;
        }
        IDistributionExecutor.onClient(() -> {
            if (IGameEngine.getInstance().getCurrentGui() instanceof IGuiContainer && IGameEngine.getInstance().getCurrentGui().getInstanceData() instanceof BlockOutGuiData) {
                IGuiContainer currentScreen = (IGuiContainer)IGameEngine.getInstance().getCurrentGui();
                ((BlockOutGuiData)currentScreen.getInstanceData()).getRoot().getUiManager().getUpdateManager().updateElement((IUIElement)((BlockOutGuiData)currentScreen.getInstanceData()).getRoot());
                ClientTickManager.getInstance().onClientTick();
            }
        });
    }

    public static void onTickServerTick(ITickEvent.IServerTickEvent event) {
        IDistributionExecutor.onServer(() -> {
            ServerGuiController guiController = (ServerGuiController)ProxyHolder.getInstance().getGuiController();
            guiController.getOpenUis().entrySet().forEach(e -> {
                if (((RootGuiElement)((Object)((Object)((Object)e.getValue())))).getUiManager().getUpdateManager() instanceof ServerUpdateManager) {
                    ServerUpdateManager updateManager = (ServerUpdateManager)((RootGuiElement)((Object)((Object)((Object)e.getValue())))).getUiManager().getUpdateManager();
                    StopWatch stopWatch = StopWatch.createStarted();
                    updateManager.updateElement((IUIElement)e.getValue());
                    stopWatch.stop();
                    if (stopWatch.getTime(TimeUnit.MILLISECONDS) > 5L) {
                        // empty if block
                    }
                    if (updateManager.isDirty()) {
                        updateManager.onNetworkTick();
                        guiController.getUUIDsOfPlayersWatching((IGuiKey)e.getKey()).forEach(uuid -> {
                            IContainer blockOutCandidate = IGameEngine.getInstance().getCurrentServerInstance().getPlayerManager().getById(uuid).getOpenContainer();
                            if (blockOutCandidate.getInstanceData() instanceof BlockOutContainerData) {
                                IContainer blockOutContainer = blockOutCandidate;
                                BlockOutContainerLogic.reinitializeSlots((IContainer<BlockOutContainerData>)blockOutContainer);
                            } else {
                                Log.getLogger().error("Can not reinitialize slots. Container is not owned by BlockOut.", (Throwable)new IllegalStateException("Unknown container type: " + blockOutCandidate.getClass().toString()));
                            }
                        });
                    }
                }
            });
        });
    }
}

