/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.blockout.builder.data.builder;

import com.ldtteam.blockout.binding.dependency.IDependencyObject;
import com.ldtteam.blockout.builder.core.IBlockOutGuiConstructionData;
import com.ldtteam.blockout.builder.core.builder.IBlockOutGuiConstructionDataBuilder;
import com.ldtteam.blockout.builder.core.builder.IBlockOutUIElementConstructionDataBuilder;
import com.ldtteam.blockout.builder.data.BlockOutGuiConstructionData;
import com.ldtteam.blockout.element.IUIElement;
import com.ldtteam.blockout.event.IEventHandler;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;

public class BlockOutGuiConstructionDataBuilder
implements IBlockOutGuiConstructionDataBuilder {
    private final Map<String, IDependencyObject<?>> dependencyData = new HashMap();
    private final Map<String, Map<Class<?>, Map<Class<?>, List<IEventHandler<?, ?>>>>> eventHandlerData = new HashMap();

    @NotNull
    public IBlockOutGuiConstructionDataBuilder withDependency(@NotNull String controlId, @NotNull String fieldName, @NotNull IDependencyObject<?> dependency) {
        this.dependencyData.put(String.format("%s#%s", controlId, fieldName), dependency);
        return this;
    }

    @NotNull
    public <S, A> IBlockOutGuiConstructionDataBuilder withEventHandler(@NotNull String controlId, @NotNull String eventName, @NotNull Class<S> controlTypeClass, @NotNull Class<A> argumentTypeClass, @NotNull IEventHandler<? super S, ? super A> eventHandler) {
        String eventId = String.format("%s#%s", controlId, eventName);
        if (!this.eventHandlerData.containsKey(eventId)) {
            this.eventHandlerData.put(eventId, new HashMap());
        }
        if (!this.eventHandlerData.get(eventId).containsKey(controlTypeClass)) {
            this.eventHandlerData.get(eventId).put(controlTypeClass, new HashMap());
        }
        if (!this.eventHandlerData.get(eventId).get(controlTypeClass).containsKey(argumentTypeClass)) {
            this.eventHandlerData.get(eventId).get(controlTypeClass).put(argumentTypeClass, new ArrayList());
        }
        this.eventHandlerData.get(eventId).get(controlTypeClass).get(argumentTypeClass).add(eventHandler);
        return this;
    }

    @NotNull
    public <T extends IUIElement, B extends IBlockOutUIElementConstructionDataBuilder<B, T>> IBlockOutGuiConstructionDataBuilder withControl(@NotNull String controlId, @NotNull Class<B> builderClass, @NotNull Consumer<B> builderInstanceConsumer) {
        try {
            Constructor<B> constructor = builderClass.getConstructor(String.class, IBlockOutGuiConstructionDataBuilder.class);
            IBlockOutUIElementConstructionDataBuilder builder = (IBlockOutUIElementConstructionDataBuilder)constructor.newInstance(controlId, this);
            builderInstanceConsumer.accept(builder);
            return this;
        }
        catch (Exception ex) {
            throw new IllegalArgumentException("The given builder class does not have a constructor which takes a ControlId and this builder!", ex);
        }
    }

    public IBlockOutGuiConstructionDataBuilder copyFrom(@NotNull IBlockOutGuiConstructionData data) {
        this.dependencyData.putAll(data.getDependencyData());
        this.eventHandlerData.putAll(data.getEventHandlerData());
        return this;
    }

    @NotNull
    public IBlockOutGuiConstructionData build() {
        return new BlockOutGuiConstructionData(this.dependencyData, this.eventHandlerData);
    }
}

