/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.blockout.builder.data;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import com.ldtteam.blockout.binding.dependency.IDependencyObject;
import com.ldtteam.blockout.builder.core.IBlockOutGuiConstructionData;
import com.ldtteam.blockout.event.IEventHandler;
import com.ldtteam.blockout.proxy.IProxy;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public class BlockOutGuiConstructionData
implements IBlockOutGuiConstructionData {
    private final Map<String, IDependencyObject<?>> dependencyData;
    private final Map<String, Map<Class<?>, Map<Class<?>, List<IEventHandler<?, ?>>>>> eventHandlerData;

    public BlockOutGuiConstructionData() {
        this(Maps.newHashMap(), Maps.newHashMap());
    }

    public BlockOutGuiConstructionData(Map<String, IDependencyObject<?>> dependencyData, Map<String, Map<Class<?>, Map<Class<?>, List<IEventHandler<?, ?>>>>> eventHandlerData) {
        this.dependencyData = dependencyData;
        this.eventHandlerData = eventHandlerData;
    }

    @NotNull
    public <S, A> List<IEventHandler<S, A>> getEventHandlers(@NotNull String id, @NotNull Class<S> sourceClass, @NotNull Class<A> argumentClass) {
        if (!this.eventHandlerData.containsKey(id)) {
            return ImmutableList.of();
        }
        if (!this.eventHandlerData.get(id).containsKey(sourceClass)) {
            return ImmutableList.of();
        }
        Map<Class<?>, List<IEventHandler<?, ?>>> eventHandlerMapOfSourceTypeForId = this.eventHandlerData.get(id).get(sourceClass);
        HashMap eventHandlerTargetTypeMap = Maps.newHashMap();
        eventHandlerMapOfSourceTypeForId.keySet().forEach(candidateArgumentType -> {
            if (IProxy.getInstance().getReflectionManager().getAllSupers(argumentClass).contains(candidateArgumentType)) {
                Class argumentTypeSuper = candidateArgumentType;
                List eventHandlers = ((List)eventHandlerMapOfSourceTypeForId.get(candidateArgumentType)).stream().map(unwrappedType -> (arg_0, arg_1) -> ((IEventHandler)unwrappedType).handleWithCast(arg_0, arg_1)).collect(Collectors.toList());
                eventHandlerTargetTypeMap.put(argumentTypeSuper, eventHandlers);
            }
        });
        return ImmutableList.copyOf((Collection)eventHandlerTargetTypeMap.entrySet().stream().flatMap(e -> ((List)e.getValue()).stream()).collect(Collectors.toList()));
    }

    public Map<String, IDependencyObject<?>> getDependencyData() {
        return this.dependencyData;
    }

    public Map<String, Map<Class<?>, Map<Class<?>, List<IEventHandler<?, ?>>>>> getEventHandlerData() {
        return this.eventHandlerData;
    }

    public boolean hasDependencyData(@NotNull String name) {
        return this.dependencyData.containsKey(name);
    }

    @NotNull
    public <T> IDependencyObject<T> get(@NotNull String name) {
        if (!this.hasDependencyData(name)) {
            throw new IllegalArgumentException("No known dependency data available for the requested name and type.");
        }
        return this.dependencyData.get(name);
    }
}

