/*
 * Decompiled with CFR 0.152.
 */
package bettercombat.mod.util;

import bettercombat.mod.capability.CapabilityOffhandCooldown;
import bettercombat.mod.handler.EventHandlers;
import bettercombat.mod.util.ConfigurationHandler;
import bettercombat.mod.util.Sounds;
import com.google.common.collect.Multimap;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.annotation.Nonnull;
import jline.internal.Nullable;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.IEntityMultiPart;
import net.minecraft.entity.MultiPartEntityPart;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Enchantments;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemAxe;
import net.minecraft.item.ItemShield;
import net.minecraft.item.ItemSpade;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemSword;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.SPacketEntityVelocity;
import net.minecraft.stats.StatList;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.event.ForgeEventFactory;

public final class Helpers {
    private Helpers() {
    }

    public static <T> void execNullable(@Nullable T obj, Consumer<T> onNonNull) {
        if (obj != null) {
            onNonNull.accept(obj);
        }
    }

    public static <T, R> R execNullable(@Nullable T obj, Function<T, R> onNonNull, R orElse) {
        if (obj != null) {
            return onNonNull.apply(obj);
        }
        return orElse;
    }

    public static int getOffhandCooldown(EntityPlayer player) {
        Multimap modifiers = player.func_184592_cb().func_111283_C(EntityEquipmentSlot.MAINHAND);
        double speed = 4.0;
        for (Map.Entry modifier : modifiers.entries()) {
            if (!((String)modifier.getKey()).contains("attackSpeed")) continue;
            speed = ((AttributeModifier)modifier.getValue()).func_111164_d();
        }
        return (int)(20.0 / (4.0 + speed));
    }

    public static float getOffhandDamage(EntityPlayer player) {
        Multimap modifiers = player.func_184592_cb().func_111283_C(EntityEquipmentSlot.MAINHAND);
        float attack = 4.0f;
        for (Map.Entry modifier : modifiers.entries()) {
            if (!((String)modifier.getKey()).contains("attackDamage")) continue;
            attack = (float)((AttributeModifier)modifier.getValue()).func_111164_d();
        }
        return (1.0f + attack) * (ConfigurationHandler.weakerOffhand ? ConfigurationHandler.offHandEfficiency : 1.0f);
    }

    public static int getOffhandFireAspect(EntityPlayer player) {
        NBTTagList tagList = player.func_184592_cb().func_77986_q();
        for (int i = 0; i < tagList.func_74745_c(); ++i) {
            NBTTagCompound tag = tagList.func_150305_b(i);
            if (tag.func_74762_e("id") != Enchantment.func_185258_b((Enchantment)Enchantments.field_77334_n)) continue;
            return tag.func_74762_e("lvl");
        }
        return 0;
    }

    public static int getOffhandKnockback(EntityPlayer player) {
        NBTTagList tagList = player.func_184592_cb().func_77986_q();
        for (int i = 0; i < tagList.func_74745_c(); ++i) {
            NBTTagCompound tag = tagList.func_150305_b(i);
            if (tag.func_74762_e("id") != Enchantment.func_185258_b((Enchantment)Enchantments.field_180313_o)) continue;
            return tag.func_74762_e("lvl");
        }
        return 0;
    }

    public static void attackTargetEntityItem(EntityPlayer player, Entity targetEntity, boolean offhand) {
        if (!ForgeHooks.onPlayerAttackTarget((EntityPlayer)player, (Entity)targetEntity)) {
            return;
        }
        if (targetEntity.func_70075_an() && !targetEntity.func_85031_j((Entity)player)) {
            float cooledStr;
            float damage;
            float f = damage = offhand ? Helpers.getOffhandDamage(player) : (float)player.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e();
            float cMod = targetEntity instanceof EntityLivingBase ? EnchantmentHelper.func_152377_a((ItemStack)(offhand ? player.func_184592_cb() : player.func_184614_ca()), (EnumCreatureAttribute)((EntityLivingBase)targetEntity).func_70668_bt()) : EnchantmentHelper.func_152377_a((ItemStack)(offhand ? player.func_184592_cb() : player.func_184614_ca()), (EnumCreatureAttribute)EnumCreatureAttribute.UNDEFINED);
            int cooldown = 0;
            if (offhand) {
                cooldown = Helpers.getOffhandCooldown(player);
                cooledStr = 1.0f - (float)Helpers.execNullable(player.getCapability(EventHandlers.TUTO_CAP, null), CapabilityOffhandCooldown::getOffhandCooldown, 0).intValue() / (float)cooldown;
            } else {
                cooledStr = player.func_184825_o(0.5f);
            }
            damage *= 0.2f + cooledStr * cooledStr * 0.8f;
            cMod *= cooledStr;
            if (offhand) {
                EventHandlers.INSTANCE.offhandCooldown = cooldown;
            } else {
                player.func_184821_cY();
            }
            if (damage > 0.0f || cMod > 0.0f) {
                boolean attacked;
                ItemStack ohItem;
                int fireAspect;
                boolean isStrong = cooledStr > 0.9f;
                boolean knockback = false;
                boolean isCrit = ConfigurationHandler.randomCrits && player.func_70681_au().nextFloat() < ConfigurationHandler.critChance && !player.func_70051_ag();
                boolean isSword = false;
                int knockbackMod = offhand ? Helpers.getOffhandKnockback(player) : EnchantmentHelper.func_77501_a((EntityLivingBase)player);
                int n = fireAspect = offhand ? Helpers.getOffhandFireAspect(player) : EnchantmentHelper.func_90036_a((EntityLivingBase)player);
                if (player.func_70051_ag() && isStrong) {
                    player.field_70170_p.func_184148_a(null, player.field_70165_t, player.field_70163_u, player.field_70161_v, SoundEvents.field_187721_dT, player.func_184176_by(), 1.0f, 1.0f);
                    ++knockbackMod;
                    knockback = true;
                }
                if (isCrit) {
                    damage *= 1.5f;
                }
                damage += cMod;
                double tgtDistDelta = player.field_70140_Q - player.field_70141_P;
                if (isStrong && !isCrit && !knockback && player.field_70122_E && tgtDistDelta < (double)player.func_70689_ay() && (ohItem = player.func_184586_b(offhand ? EnumHand.OFF_HAND : EnumHand.MAIN_HAND)).func_77973_b() instanceof ItemSword) {
                    isSword = true;
                }
                float tgtHealth = 0.0f;
                boolean burnInflicted = false;
                if (targetEntity instanceof EntityLivingBase) {
                    tgtHealth = ((EntityLivingBase)targetEntity).func_110143_aJ();
                    if (fireAspect > 0 && !targetEntity.func_70027_ad()) {
                        targetEntity.func_70015_d(1);
                        burnInflicted = true;
                    }
                }
                double tgtMotionX = targetEntity.field_70159_w;
                double tgtMotionY = targetEntity.field_70181_x;
                double tgtMotionZ = targetEntity.field_70179_y;
                if (offhand) {
                    float attackDmgFinal = damage;
                    attacked = Helpers.execNullable(targetEntity.getCapability(EventHandlers.SECONDHURTTIMER_CAP, null), sht -> sht.attackEntityFromOffhand(targetEntity, DamageSource.func_76365_a((EntityPlayer)player), attackDmgFinal), false);
                } else {
                    attacked = targetEntity.func_70097_a(DamageSource.func_76365_a((EntityPlayer)player), damage);
                }
                if (attacked) {
                    IEntityMultiPart ientitymultipart;
                    ItemStack heldItem;
                    if (knockbackMod > 0) {
                        if (targetEntity instanceof EntityLivingBase) {
                            ((EntityLivingBase)targetEntity).func_70653_a((Entity)player, (float)knockbackMod * 0.5f, (double)MathHelper.func_76126_a((float)(player.field_70177_z * ((float)Math.PI / 180))), (double)(-MathHelper.func_76134_b((float)(player.field_70177_z * ((float)Math.PI / 180)))));
                        } else {
                            targetEntity.func_70024_g((double)(-MathHelper.func_76126_a((float)(player.field_70177_z * ((float)Math.PI / 180))) * (float)knockbackMod * 0.5f), 0.1, (double)(MathHelper.func_76134_b((float)(player.field_70177_z * ((float)Math.PI / 180))) * (float)knockbackMod * 0.5f));
                        }
                        player.field_70159_w *= 0.6;
                        player.field_70179_y *= 0.6;
                        if (!ConfigurationHandler.moreSprint) {
                            player.func_70031_b(false);
                        }
                    }
                    if (isSword) {
                        for (EntityLivingBase living : player.field_70170_p.func_72872_a(EntityLivingBase.class, targetEntity.func_174813_aQ().func_72314_b(1.0, 0.25, 1.0))) {
                            if (living == player || living == targetEntity || player.func_184191_r((Entity)living) || !(player.func_70068_e((Entity)living) < 9.0)) continue;
                            living.func_70653_a((Entity)player, 0.4f, (double)MathHelper.func_76126_a((float)(player.field_70177_z * ((float)Math.PI / 180))), (double)(-MathHelper.func_76134_b((float)(player.field_70177_z * ((float)Math.PI / 180)))));
                            if (offhand) {
                                Helpers.execNullable(targetEntity.getCapability(EventHandlers.SECONDHURTTIMER_CAP, null), sht -> sht.attackEntityFromOffhand((Entity)living, DamageSource.func_76365_a((EntityPlayer)player), 1.0f));
                                continue;
                            }
                            living.func_70097_a(DamageSource.func_76365_a((EntityPlayer)player), 1.0f);
                        }
                        player.field_70170_p.func_184148_a(null, player.field_70165_t, player.field_70163_u, player.field_70161_v, SoundEvents.field_187730_dW, player.func_184176_by(), 1.0f, 1.0f);
                        player.func_184810_cG();
                    }
                    if (targetEntity instanceof EntityPlayerMP && targetEntity.field_70133_I) {
                        ((EntityPlayerMP)targetEntity).field_71135_a.func_147359_a((Packet)new SPacketEntityVelocity(targetEntity));
                        targetEntity.field_70133_I = false;
                        targetEntity.field_70159_w = tgtMotionX;
                        targetEntity.field_70181_x = tgtMotionY;
                        targetEntity.field_70179_y = tgtMotionZ;
                    }
                    if (isCrit) {
                        if (offhand) {
                            player.field_70170_p.func_184148_a(null, player.field_70165_t, player.field_70163_u, player.field_70161_v, SoundEvents.field_187718_dS, player.func_184176_by(), 1.0f, 1.0f);
                        }
                        player.func_71009_b(targetEntity);
                    }
                    boolean playSound = true;
                    ItemStack itemStack = heldItem = offhand ? player.func_184592_cb() : player.func_184614_ca();
                    if (!heldItem.func_190926_b()) {
                        if (heldItem.func_77973_b() instanceof ItemSpade) {
                            playSound = false;
                        }
                        if (playSound) {
                            if (!(!ConfigurationHandler.hitSound || ConfigurationHandler.critSound && isCrit)) {
                                player.field_70170_p.func_184148_a(null, player.field_70165_t, player.field_70163_u, player.field_70161_v, Sounds.SWORD_SLASH, player.func_184176_by(), 1.0f, 1.0f);
                            }
                            if (ConfigurationHandler.critSound && isCrit) {
                                player.field_70170_p.func_184148_a(null, player.field_70165_t, player.field_70163_u, player.field_70161_v, Sounds.CRITICAL_STRIKE, player.func_184176_by(), 1.0f, 1.0f);
                            }
                        }
                    }
                    if (!isCrit && !isSword) {
                        if (isStrong) {
                            player.field_70170_p.func_184148_a(null, player.field_70165_t, player.field_70163_u, player.field_70161_v, SoundEvents.field_187727_dV, player.func_184176_by(), 1.0f, 1.0f);
                        } else {
                            player.field_70170_p.func_184148_a(null, player.field_70165_t, player.field_70163_u, player.field_70161_v, SoundEvents.field_187733_dX, player.func_184176_by(), 1.0f, 1.0f);
                        }
                    }
                    if (cMod > 0.0f) {
                        player.func_71047_c(targetEntity);
                    }
                    if (!player.field_70170_p.field_72995_K && targetEntity instanceof EntityPlayer) {
                        ItemStack activeItem;
                        EntityPlayer entityplayer = (EntityPlayer)targetEntity;
                        ItemStack itemStack2 = activeItem = entityplayer.func_184587_cr() ? entityplayer.func_184607_cu() : ItemStack.field_190927_a;
                        if (heldItem.func_77973_b() instanceof ItemAxe && activeItem.func_77973_b() instanceof ItemShield) {
                            float efficiency = 0.25f + (float)EnchantmentHelper.func_185293_e((EntityLivingBase)player) * 0.05f;
                            if (knockback) {
                                efficiency += 0.75f;
                            }
                            if (player.func_70681_au().nextFloat() < efficiency) {
                                entityplayer.func_184811_cZ().func_185145_a(activeItem.func_77973_b(), 100);
                                player.field_70170_p.func_72960_a((Entity)entityplayer, (byte)30);
                            }
                        }
                    }
                    player.func_130011_c(targetEntity);
                    if (targetEntity instanceof EntityLivingBase) {
                        EnchantmentHelper.func_151384_a((EntityLivingBase)((EntityLivingBase)targetEntity), (Entity)player);
                    }
                    EnchantmentHelper.func_151385_b((EntityLivingBase)player, (Entity)targetEntity);
                    Entity entity = targetEntity;
                    if (targetEntity instanceof MultiPartEntityPart && (ientitymultipart = ((MultiPartEntityPart)targetEntity).field_70259_a) instanceof EntityLivingBase) {
                        entity = (EntityLivingBase)ientitymultipart;
                    }
                    if (!heldItem.func_190926_b() && entity instanceof EntityLivingBase) {
                        ItemStack beforeHitCopy = heldItem.func_77946_l();
                        heldItem.func_77961_a((EntityLivingBase)entity, player);
                        if (heldItem.func_190926_b()) {
                            player.func_184611_a(offhand ? EnumHand.OFF_HAND : EnumHand.MAIN_HAND, ItemStack.field_190927_a);
                            ForgeEventFactory.onPlayerDestroyItem((EntityPlayer)player, (ItemStack)beforeHitCopy, (EnumHand)(offhand ? EnumHand.OFF_HAND : EnumHand.MAIN_HAND));
                        }
                    }
                    if (targetEntity instanceof EntityLivingBase) {
                        float healthDelta = tgtHealth - ((EntityLivingBase)targetEntity).func_110143_aJ();
                        player.func_71064_a(StatList.field_188111_y, Math.round(healthDelta * 10.0f));
                        if (fireAspect > 0) {
                            targetEntity.func_70015_d(fireAspect * 4);
                        }
                        if (player.field_70170_p instanceof WorldServer && healthDelta > 2.0f) {
                            int k = (int)((double)healthDelta * 0.5);
                            ((WorldServer)player.field_70170_p).func_175739_a(EnumParticleTypes.DAMAGE_INDICATOR, targetEntity.field_70165_t, targetEntity.field_70163_u + (double)(targetEntity.field_70131_O * 0.5f), targetEntity.field_70161_v, k, 0.1, 0.0, 0.1, 0.2, new int[0]);
                        }
                    }
                    player.func_71020_j(0.3f);
                } else {
                    player.field_70170_p.func_184148_a(null, player.field_70165_t, player.field_70163_u, player.field_70161_v, SoundEvents.field_187724_dU, player.func_184176_by(), 1.0f, 1.0f);
                    if (burnInflicted) {
                        targetEntity.func_70066_B();
                    }
                }
            }
        }
    }

    @Nonnull
    public static <T> T getNull() {
        return null;
    }
}

